/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayAllocationSite;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.cli.Options;

public final class RubyArray
extends RubyBasicObject {
    public static final int ARRAYS_SMALL = Options.TRUFFLE_ARRAYS_SMALL.load();
    private final ArrayAllocationSite allocationSite;
    private Object store;
    private int size;

    public RubyArray(RubyClass arrayClass) {
        this(arrayClass, null, 0);
    }

    public RubyArray(RubyClass arrayClass, Object store, int size2) {
        this(arrayClass, null, store, size2);
    }

    public RubyArray(RubyClass arrayClass, ArrayAllocationSite allocationSite, Object store, int size2) {
        super(arrayClass);
        this.allocationSite = allocationSite;
        this.setStore(store, size2);
    }

    public static RubyArray fromObject(RubyClass arrayClass, Object object) {
        RubyNode.notDesignedForCompilation();
        Object[] store = object instanceof Integer ? new int[]{(Integer)object} : (object instanceof Long ? (Object[])new long[]{(Long)object} : (object instanceof Double ? (Object[])new double[]{(Double)object} : (Object[])new Object[]{object}));
        return new RubyArray(arrayClass, store, 1);
    }

    public static RubyArray fromObjects(RubyClass arrayClass, Object ... objects) {
        int n;
        Object[] store;
        RubyNode.notDesignedForCompilation();
        if (objects.length == 0) {
            return new RubyArray(arrayClass);
        }
        if (objects.length == 1) {
            return RubyArray.fromObject(arrayClass, objects[0]);
        }
        boolean canUseInteger = true;
        boolean canUseLong = true;
        boolean canUseDouble = true;
        for (Object object : objects) {
            if (object instanceof Integer) {
                canUseDouble = false;
                continue;
            }
            if (object instanceof Long) {
                canUseInteger = canUseInteger && CoreLibrary.fitsIntoInteger((Long)object);
                canUseDouble = false;
                continue;
            }
            if (object instanceof Double) {
                canUseInteger = false;
                canUseLong = false;
                continue;
            }
            canUseInteger = false;
            canUseLong = false;
            canUseDouble = false;
        }
        if (canUseInteger) {
            store = new int[objects.length];
            for (n = 0; n < objects.length; ++n) {
                Object object = objects[n];
                if (object instanceof Integer) {
                    store[n] = (Integer)object;
                    continue;
                }
                if (object instanceof Long) {
                    store[n] = (int)((Long)object).longValue();
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return new RubyArray(arrayClass, store, objects.length);
        }
        if (canUseLong) {
            store = new long[objects.length];
            for (n = 0; n < objects.length; ++n) {
                Object object = objects[n];
                if (object instanceof Integer) {
                    store[n] = (int)((long)((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    store[n] = (int)((Long)object).longValue();
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return new RubyArray(arrayClass, store, objects.length);
        }
        if (canUseDouble) {
            store = new double[objects.length];
            for (n = 0; n < objects.length; ++n) {
                store[n] = (int)CoreLibrary.toDouble(objects[n]);
            }
            return new RubyArray(arrayClass, store, objects.length);
        }
        return new RubyArray(arrayClass, objects, objects.length);
    }

    public Object[] slowToArray() {
        RubyNode.notDesignedForCompilation();
        return Arrays.copyOf(ArrayUtils.box(this.store), this.size);
    }

    public Object slowShift() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.size == 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        this.store = ArrayUtils.box(this.store);
        Object value2 = ((Object[])this.store)[0];
        System.arraycopy(this.store, 1, this.store, 0, this.size - 1);
        --this.size;
        return value2;
    }

    public void slowUnshift(Object ... values2) {
        RubyNode.notDesignedForCompilation();
        Object[] newStore = new Object[this.size + values2.length];
        System.arraycopy(values2, 0, newStore, 0, values2.length);
        ArrayUtils.copy(this.store, newStore, values2.length, this.size);
        this.setStore(newStore, newStore.length);
    }

    public void slowPush(Object value2) {
        RubyNode.notDesignedForCompilation();
        this.store = Arrays.copyOf(ArrayUtils.box(this.store), this.size + 1);
        ((Object[])this.store)[this.size] = value2;
        ++this.size;
    }

    public int normaliseIndex(int index2) {
        return RubyArray.normaliseIndex(this.size, index2);
    }

    public static int normaliseIndex(int length2, int index2) {
        if (CompilerDirectives.injectBranchProbability(0.25, index2 < 0)) {
            return length2 + index2;
        }
        return index2;
    }

    public int clampExclusiveIndex(int index2) {
        return RubyArray.clampExclusiveIndex(this.size, index2);
    }

    public static int clampExclusiveIndex(int length2, int index2) {
        if (index2 < 0) {
            return 0;
        }
        if (index2 > length2) {
            return length2;
        }
        return index2;
    }

    public Object getStore() {
        return this.store;
    }

    public void setStore(Object store, int size2) {
        assert (this.verifyStore(store, size2));
        this.store = store;
        this.size = size2;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size2) {
        assert (this.verifyStore(this.store, size2));
        this.size = size2;
    }

    private boolean verifyStore(Object store, int size2) {
        assert (store == null || store instanceof Object[] || store instanceof int[] || store instanceof long[] || store instanceof double[]);
        assert (!(store instanceof Object[]) || size2 <= ((Object[])store).length);
        assert (!(store instanceof int[]) || size2 <= ((int[])store).length);
        assert (!(store instanceof long[]) || size2 <= ((long[])store).length);
        assert (!(store instanceof double[]) || size2 <= ((double[])store).length);
        return true;
    }

    public ArrayAllocationSite getAllocationSite() {
        return this.allocationSite;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (Object object : this.slowToArray()) {
            if (!(object instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)object).visitObjectGraph(visitor);
        }
    }

    public static class ArrayAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyArray(rubyClass);
        }
    }
}

