/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jruby.TruffleBridge;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.backtrace.DebugBacktraceFormatter;
import org.jruby.truffle.runtime.backtrace.ImplementationDebugBacktraceFormatter;
import org.jruby.truffle.runtime.backtrace.MRIBacktraceFormatter;
import org.jruby.util.cli.Options;

public class Backtrace {
    public static final BacktraceFormatter DISPLAY_FORMATTER = Backtrace.getFormatter(Options.TRUFFLE_BACKTRACE_DISPLAY_FORMAT.load());
    public static final BacktraceFormatter EXCEPTION_FORMATTER = Backtrace.getFormatter(Options.TRUFFLE_BACKTRACE_EXCEPTION_FORMAT.load());
    public static final BacktraceFormatter DEBUG_FORMATTER = Backtrace.getFormatter(Options.TRUFFLE_BACKTRACE_DEBUG_FORMAT.load());
    public static final BacktraceFormatter PANIC_FORMATTER = Backtrace.getFormatter(Options.TRUFFLE_BACKTRACE_PANIC_FORMAT.load());
    private final Activation[] activations;

    public Backtrace(Activation[] activations) {
        this.activations = activations;
    }

    public List<Activation> getActivations() {
        return Collections.unmodifiableList(Arrays.asList(this.activations));
    }

    private static BacktraceFormatter getFormatter(TruffleBridge.BacktraceFormatter formatter) {
        switch (formatter) {
            case MRI: {
                return new MRIBacktraceFormatter();
            }
            case DEBUG: {
                return new DebugBacktraceFormatter();
            }
            case IMPL_DEBUG: {
                return new ImplementationDebugBacktraceFormatter();
            }
        }
        throw new UnsupportedOperationException();
    }
}

