/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.MethodLike;
import org.jruby.util.Memo;
import org.jruby.util.cli.Options;

public abstract class RubyCallStack {
    public static RubyModule getCurrentDeclaringModule() {
        FrameInstance currentFrame = Truffle.getRuntime().getCurrentFrame();
        MethodLike method = RubyCallStack.getMethod(currentFrame);
        return method.getDeclaringModule();
    }

    public static InternalMethod getCurrentMethod() {
        CompilerAsserts.neverPartOfCompilation();
        FrameInstance currentFrame = Truffle.getRuntime().getCurrentFrame();
        MethodLike method = RubyCallStack.getMethod(currentFrame);
        if (method instanceof InternalMethod) {
            return (InternalMethod)method;
        }
        return Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<InternalMethod>(){

            @Override
            public InternalMethod visitFrame(FrameInstance frameInstance) {
                MethodLike maybeMethod = RubyCallStack.getMethod(frameInstance);
                if (maybeMethod instanceof InternalMethod) {
                    return (InternalMethod)maybeMethod;
                }
                return null;
            }
        });
    }

    public static InternalMethod getCallingMethod() {
        CompilerAsserts.neverPartOfCompilation();
        final Memo<Boolean> seenCurrent = new Memo<Boolean>();
        FrameInstance currentFrame = Truffle.getRuntime().getCurrentFrame();
        MethodLike method = RubyCallStack.getMethod(currentFrame);
        if (method instanceof InternalMethod) {
            seenCurrent.set(true);
        }
        return Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<InternalMethod>(){

            @Override
            public InternalMethod visitFrame(FrameInstance frameInstance) {
                MethodLike maybeMethod = RubyCallStack.getMethod(frameInstance);
                if (maybeMethod instanceof InternalMethod) {
                    if (((Boolean)seenCurrent.get()).booleanValue()) {
                        return (InternalMethod)maybeMethod;
                    }
                    seenCurrent.set(true);
                    return null;
                }
                return null;
            }
        });
    }

    public static MethodLike getMethod(FrameInstance frame) {
        CompilerAsserts.neverPartOfCompilation();
        if (frame == null) {
            return null;
        }
        return RubyArguments.getMethod(frame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true).getArguments());
    }

    public static Backtrace getBacktrace(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        final ArrayList<Activation> activations = new ArrayList<Activation>();
        if (Options.TRUFFLE_BACKTRACE_GENERATE.load().booleanValue()) {
            if (currentNode != null && Truffle.getRuntime().getCurrentFrame() != null) {
                activations.add(new Activation(currentNode, Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize()));
            }
            Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<InternalMethod>(){

                @Override
                public InternalMethod visitFrame(FrameInstance frameInstance) {
                    if (frameInstance.getCallNode() != null) {
                        activations.add(new Activation(frameInstance.getCallNode(), frameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize()));
                    }
                    return null;
                }
            });
        }
        return new Backtrace(activations.toArray(new Activation[activations.size()]));
    }

    public static Node getTopMostUserCallNode() {
        CompilerAsserts.neverPartOfCompilation();
        return Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Node>(){

            @Override
            public Node visitFrame(FrameInstance frameInstance) {
                if (frameInstance.getCallNode().getEncapsulatingSourceSection() instanceof CoreSourceSection) {
                    return null;
                }
                return frameInstance.getCallNode();
            }
        });
    }
}

