/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.supercall.AbstractGeneralSuperCallNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

public class GeneralSuperCallNode
extends AbstractGeneralSuperCallNode {
    private final boolean isSplatted;
    @Node.Child
    private RubyNode block;
    @Node.Children
    private final RubyNode[] arguments;

    public GeneralSuperCallNode(RubyContext context, SourceSection sourceSection, RubyNode block, RubyNode[] arguments, boolean isSplatted) {
        super(context, sourceSection);
        assert (arguments != null);
        assert (!isSplatted || arguments.length == 1);
        this.block = block;
        this.arguments = arguments;
        this.isSplatted = isSplatted;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object blockTempObject;
        RubyBasicObject self2 = (RubyBasicObject)RubyArguments.getSelf(frame.getArguments());
        Object[] argumentsObjects = new Object[this.arguments.length];
        CompilerAsserts.compilationConstant(this.arguments.length);
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            argumentsObjects[i2] = this.arguments[i2].execute(frame);
        }
        RubyProc blockObject = this.block != null ? ((blockTempObject = this.block.execute(frame)) instanceof RubyNilClass ? null : (RubyProc)blockTempObject) : null;
        if (!this.guard()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookup(frame);
        }
        if (this.method == null || this.callNode == null) {
            throw new IllegalStateException("No call node installed");
        }
        if (this.isSplatted) {
            GeneralSuperCallNode.notDesignedForCompilation();
            RubyArray argumentsArray = (RubyArray)argumentsObjects[0];
            return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), self2, blockObject, argumentsArray.slowToArray()));
        }
        return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), self2, blockObject, argumentsObjects));
    }
}

