/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;

public abstract class TypePrimitiveNodes {

    @RubiniusPrimitive(name="object_infect", needsSelf=false)
    public static abstract class ObjectInfectPrimitiveNode
    extends RubiniusPrimitiveNode {
        public ObjectInfectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ObjectInfectPrimitiveNode(ObjectInfectPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object objectInfect(Object object) {
            throw new UnsupportedOperationException("object_infect");
        }
    }

    @RubiniusPrimitive(name="encoding_get_object_encoding", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingPrimitiveNode
    extends RubiniusPrimitiveNode {
        public EncodingGetObjectEncodingPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingGetObjectEncodingPrimitiveNode(EncodingGetObjectEncodingPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object encodingGetObjectEncoding(Object object) {
            throw new UnsupportedOperationException("encoding_get_object_encoding");
        }
    }

    @RubiniusPrimitive(name="vm_set_module_name", needsSelf=false)
    public static abstract class VMSetModuleNamePrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMSetModuleNamePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public VMSetModuleNamePrimitiveNode(VMSetModuleNamePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object vmSetModuleName(Object object) {
            throw new UnsupportedOperationException("vm_set_module_name");
        }
    }

    @RubiniusPrimitive(name="vm_get_module_name", needsSelf=false)
    public static abstract class VMGetModuleNamePrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMGetModuleNamePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public VMGetModuleNamePrimitiveNode(VMGetModuleNamePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object vmGetModuleName(Object object) {
            throw new UnsupportedOperationException("vm_get_module_name");
        }
    }

    @RubiniusPrimitive(name="vm_object_equal", needsSelf=false)
    public static abstract class VMObjectEqualPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMObjectEqualPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public VMObjectEqualPrimitiveNode(VMObjectEqualPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object vmObjectEqual(Object a, Object b2) {
            throw new UnsupportedOperationException("vm_object_equal");
        }
    }

    @RubiniusPrimitive(name="vm_object_respond_to", needsSelf=false)
    public static abstract class VMObjectRespondToPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;

        public VMObjectRespondToPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.respondToNode = KernelNodesFactory.RespondToNodeFactory.create(context, sourceSection, new RubyNode[]{null, null, null});
        }

        public VMObjectRespondToPrimitiveNode(VMObjectRespondToPrimitiveNode prev) {
            super(prev);
            this.respondToNode = prev.respondToNode;
        }

        @Specialization
        public boolean vmObjectRespondTo(VirtualFrame frame, Object object, Object name2, boolean includePrivate) {
            return this.respondToNode.executeDoesRespondTo(frame, object, name2, includePrivate);
        }
    }

    @RubiniusPrimitive(name="vm_singleton_class_object", needsSelf=false)
    public static abstract class VMObjectSingletonClassObjectPrimitiveNode
    extends RubiniusPrimitiveNode {
        public VMObjectSingletonClassObjectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public VMObjectSingletonClassObjectPrimitiveNode(VMObjectSingletonClassObjectPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object vmSingletonClassObject(Object object) {
            throw new UnsupportedOperationException("vm_singleton_class_object");
        }
    }

    @RubiniusPrimitive(name="vm_object_singleton_class", needsSelf=false)
    public static abstract class VMObjectSingletonClassPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private KernelNodes.SingletonClassMethodNode singletonClassNode;

        public VMObjectSingletonClassPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = KernelNodesFactory.SingletonClassMethodNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public VMObjectSingletonClassPrimitiveNode(VMObjectSingletonClassPrimitiveNode prev) {
            super(prev);
            this.singletonClassNode = prev.singletonClassNode;
        }

        @Specialization
        public Object vmObjectClass(VirtualFrame frame, Object object) {
            return this.singletonClassNode.singletonClass(frame, object);
        }
    }

    @RubiniusPrimitive(name="vm_object_class", needsSelf=false)
    public static abstract class VMObjectClassPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private KernelNodes.ClassNode classNode;

        public VMObjectClassPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = KernelNodesFactory.ClassNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public VMObjectClassPrimitiveNode(VMObjectClassPrimitiveNode prev) {
            super(prev);
            this.classNode = prev.classNode;
        }

        @Specialization
        public RubyClass vmObjectClass(VirtualFrame frame, Object object) {
            return this.classNode.executeGetClass(frame, object);
        }
    }

    @RubiniusPrimitive(name="vm_object_kind_of", needsSelf=false)
    public static abstract class VMObjectKindOfPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private KernelNodes.IsANode isANode;

        public VMObjectKindOfPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public VMObjectKindOfPrimitiveNode(VMObjectKindOfPrimitiveNode prev) {
            super(prev);
            this.isANode = prev.isANode;
        }

        @Specialization
        public boolean vmObjectKindOf(VirtualFrame frame, Object object, RubyClass rubyClass) {
            return this.isANode.executeIsA(frame, object, rubyClass);
        }
    }
}

