/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class ReadOptionalArgumentNode
extends RubyNode {
    private final int index;
    private final int minimum;
    @Node.Child
    private RubyNode defaultValue;
    private final BranchProfile defaultValueProfile = BranchProfile.create();

    public ReadOptionalArgumentNode(RubyContext context, SourceSection sourceSection, int index2, int minimum, RubyNode defaultValue) {
        super(context, sourceSection);
        this.index = index2;
        this.minimum = minimum;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (RubyArguments.getUserArgumentsCount(frame.getArguments()) < this.minimum) {
            this.defaultValueProfile.enter();
            return this.defaultValue.execute(frame);
        }
        return RubyArguments.getUserArgument(frame.getArguments(), this.index);
    }
}

