/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.MathNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;

@GeneratedBy(value=MathNodes.class)
public final class MathNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ACosNodeFactory.getInstance(), ACosHNodeFactory.getInstance(), ASinNodeFactory.getInstance(), ASinHNodeFactory.getInstance(), ATanNodeFactory.getInstance(), ATan2NodeFactory.getInstance(), ATanHNodeFactory.getInstance(), CbRtNodeFactory.getInstance(), CosNodeFactory.getInstance(), CosHNodeFactory.getInstance(), ErfNodeFactory.getInstance(), ErfcNodeFactory.getInstance(), ExpNodeFactory.getInstance(), FrExpNodeFactory.getInstance(), GammaNodeFactory.getInstance(), HypotNodeFactory.getInstance(), LdexpNodeFactory.getInstance(), LGammaNodeFactory.getInstance(), LogNodeFactory.getInstance(), Log10NodeFactory.getInstance(), Log2NodeFactory.getInstance(), SinNodeFactory.getInstance(), SinHNodeFactory.getInstance(), TanNodeFactory.getInstance(), TanHNodeFactory.getInstance(), SqrtNodeFactory.getInstance(), SimpleMonadicMathNodeFactory.getInstance(), SimpleDyadicMathNodeFactory.getInstance());
    }

    @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
    protected static final class SimpleDyadicMathNodeFactory
    extends NodeFactoryBase<MathNodes.SimpleDyadicMathNode> {
        private static SimpleDyadicMathNodeFactory simpleDyadicMathNodeFactoryInstance;

        private SimpleDyadicMathNodeFactory() {
            super(MathNodes.SimpleDyadicMathNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.SimpleDyadicMathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleDyadicMathNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        protected static MathNodes.SimpleDyadicMathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SimpleDyadicMathUninitializedNode.create0(context, sourceSection, arguments);
        }

        protected static NodeFactory<MathNodes.SimpleDyadicMathNode> getInstance() {
            if (simpleDyadicMathNodeFactoryInstance == null) {
                simpleDyadicMathNodeFactoryInstance = new SimpleDyadicMathNodeFactory();
            }
            return simpleDyadicMathNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SimpleDyadicMathPolymorphicNode
        extends SimpleDyadicMathBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SimpleDyadicMathPolymorphicNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathDoubleNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            SimpleDyadicMathDoubleNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathDoubleNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathDoubleRubyBignumNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            SimpleDyadicMathDoubleRubyBignumNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathDoubleRubyBignumNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathDoubleLongNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            SimpleDyadicMathDoubleLongNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathDoubleLongNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathDoubleIntNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            SimpleDyadicMathDoubleIntNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathDoubleIntNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathRubyBignumDoubleNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            SimpleDyadicMathRubyBignumDoubleNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathRubyBignumDoubleNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathRubyBignumNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            SimpleDyadicMathRubyBignumNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathRubyBignumNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathRubyBignumLongNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            SimpleDyadicMathRubyBignumLongNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathRubyBignumLongNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathRubyBignumIntNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            SimpleDyadicMathRubyBignumIntNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathRubyBignumIntNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathLongDoubleNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            SimpleDyadicMathLongDoubleNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathLongDoubleNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathLongRubyBignumNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            SimpleDyadicMathLongRubyBignumNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathLongRubyBignumNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathLongNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            SimpleDyadicMathLongNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathLongNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathLongIntNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            SimpleDyadicMathLongIntNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathLongIntNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathIntDoubleNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            SimpleDyadicMathIntDoubleNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathIntDoubleNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathIntRubyBignumNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            SimpleDyadicMathIntRubyBignumNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathIntRubyBignumNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathIntLongNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            SimpleDyadicMathIntLongNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathIntLongNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleDyadicMathIntNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            SimpleDyadicMathIntNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(MathNodes.SimpleDyadicMathNode current2) {
                return new SimpleDyadicMathIntNode((SimpleDyadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SimpleDyadicMathUninitializedNode
        extends SimpleDyadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleDyadicMathUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SimpleDyadicMathUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SimpleDyadicMathUninitializedNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SimpleDyadicMathBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.SimpleDyadicMathNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SimpleDyadicMathUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        private static abstract class SimpleDyadicMathBaseNode
        extends MathNodes.SimpleDyadicMathNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SimpleDyadicMathBaseNode next0;

            SimpleDyadicMathBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SimpleDyadicMathBaseNode(SimpleDyadicMathBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                SimpleDyadicMathBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SimpleDyadicMathBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SimpleDyadicMathUninitializedNode(this);
                    ((SimpleDyadicMathUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = SimpleDyadicMathBaseNode.createInfo0(reason2, frameValue, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new SimpleDyadicMathUninitializedNode(this), new SimpleDyadicMathPolymorphicNode(this), (SimpleDyadicMathBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SimpleDyadicMathBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathIntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathLongRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathLongDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathRubyBignumDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SimpleDyadicMathBaseNode)SimpleDyadicMathDoubleNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SimpleDyadicMathBaseNode otherCast = (SimpleDyadicMathBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SimpleDyadicMathBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
    protected static final class SimpleMonadicMathNodeFactory
    extends NodeFactoryBase<MathNodes.SimpleMonadicMathNode> {
        private static SimpleMonadicMathNodeFactory simpleMonadicMathNodeFactoryInstance;

        private SimpleMonadicMathNodeFactory() {
            super(MathNodes.SimpleMonadicMathNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.SimpleMonadicMathNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleMonadicMathNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        protected static MathNodes.SimpleMonadicMathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SimpleMonadicMathUninitializedNode.create0(context, sourceSection, arguments);
        }

        protected static NodeFactory<MathNodes.SimpleMonadicMathNode> getInstance() {
            if (simpleMonadicMathNodeFactoryInstance == null) {
                simpleMonadicMathNodeFactoryInstance = new SimpleMonadicMathNodeFactory();
            }
            return simpleMonadicMathNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SimpleMonadicMathPolymorphicNode
        extends SimpleMonadicMathBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SimpleMonadicMathPolymorphicNode(SimpleMonadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleMonadicMathDoubleNode
        extends SimpleMonadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleMonadicMathDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            SimpleMonadicMathDoubleNode(SimpleMonadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SimpleMonadicMathNode create0(MathNodes.SimpleMonadicMathNode current2) {
                return new SimpleMonadicMathDoubleNode((SimpleMonadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleMonadicMathRubyBignumNode
        extends SimpleMonadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleMonadicMathRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            SimpleMonadicMathRubyBignumNode(SimpleMonadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SimpleMonadicMathNode create0(MathNodes.SimpleMonadicMathNode current2) {
                return new SimpleMonadicMathRubyBignumNode((SimpleMonadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleMonadicMathLongNode
        extends SimpleMonadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleMonadicMathLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            SimpleMonadicMathLongNode(SimpleMonadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SimpleMonadicMathNode create0(MathNodes.SimpleMonadicMathNode current2) {
                return new SimpleMonadicMathLongNode((SimpleMonadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SimpleMonadicMathIntNode
        extends SimpleMonadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleMonadicMathIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            SimpleMonadicMathIntNode(SimpleMonadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SimpleMonadicMathNode create0(MathNodes.SimpleMonadicMathNode current2) {
                return new SimpleMonadicMathIntNode((SimpleMonadicMathBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SimpleMonadicMathUninitializedNode
        extends SimpleMonadicMathBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SimpleMonadicMathUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SimpleMonadicMathUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SimpleMonadicMathUninitializedNode(SimpleMonadicMathBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SimpleMonadicMathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SimpleMonadicMathNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SimpleMonadicMathUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        private static abstract class SimpleMonadicMathBaseNode
        extends MathNodes.SimpleMonadicMathNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SimpleMonadicMathBaseNode next0;

            SimpleMonadicMathBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SimpleMonadicMathBaseNode(SimpleMonadicMathBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SimpleMonadicMathBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SimpleMonadicMathBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SimpleMonadicMathUninitializedNode(this);
                    ((SimpleMonadicMathUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = SimpleMonadicMathBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new SimpleMonadicMathUninitializedNode(this), new SimpleMonadicMathPolymorphicNode(this), (SimpleMonadicMathBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SimpleMonadicMathBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (SimpleMonadicMathBaseNode)SimpleMonadicMathIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (SimpleMonadicMathBaseNode)SimpleMonadicMathLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (SimpleMonadicMathBaseNode)SimpleMonadicMathRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (SimpleMonadicMathBaseNode)SimpleMonadicMathDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SimpleMonadicMathBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SimpleMonadicMathBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.SqrtNode.class)
    public static final class SqrtNodeFactory
    extends NodeFactoryBase<MathNodes.SqrtNode> {
        private static SqrtNodeFactory sqrtNodeFactoryInstance;

        private SqrtNodeFactory() {
            super(MathNodes.SqrtNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.SqrtNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SqrtNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.SqrtNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SqrtUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.SqrtNode> getInstance() {
            if (sqrtNodeFactoryInstance == null) {
                sqrtNodeFactoryInstance = new SqrtNodeFactory();
            }
            return sqrtNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SqrtPolymorphicNode
        extends SqrtBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SqrtPolymorphicNode(SqrtBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SqrtDoubleNode
        extends SqrtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqrtDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            SqrtDoubleNode(SqrtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SqrtNode create0(MathNodes.SqrtNode current2) {
                return new SqrtDoubleNode((SqrtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SqrtRubyBignumNode
        extends SqrtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqrtRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            SqrtRubyBignumNode(SqrtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SqrtNode create0(MathNodes.SqrtNode current2) {
                return new SqrtRubyBignumNode((SqrtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SqrtLongNode
        extends SqrtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqrtLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            SqrtLongNode(SqrtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SqrtNode create0(MathNodes.SqrtNode current2) {
                return new SqrtLongNode((SqrtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SqrtIntNode
        extends SqrtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqrtIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            SqrtIntNode(SqrtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SqrtNode create0(MathNodes.SqrtNode current2) {
                return new SqrtIntNode((SqrtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SqrtUninitializedNode
        extends SqrtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SqrtUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SqrtUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SqrtUninitializedNode(SqrtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SqrtBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SqrtNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SqrtUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        private static abstract class SqrtBaseNode
        extends MathNodes.SqrtNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SqrtBaseNode next0;

            SqrtBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SqrtBaseNode(SqrtBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SqrtBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SqrtBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SqrtUninitializedNode(this);
                    ((SqrtUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = SqrtBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new SqrtUninitializedNode(this), new SqrtPolymorphicNode(this), (SqrtBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SqrtBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (SqrtBaseNode)SqrtIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (SqrtBaseNode)SqrtLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (SqrtBaseNode)SqrtRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (SqrtBaseNode)SqrtDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SqrtBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SqrtBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.TanHNode.class)
    public static final class TanHNodeFactory
    extends NodeFactoryBase<MathNodes.TanHNode> {
        private static TanHNodeFactory tanHNodeFactoryInstance;

        private TanHNodeFactory() {
            super(MathNodes.TanHNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.TanHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return TanHNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.TanHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return TanHUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.TanHNode> getInstance() {
            if (tanHNodeFactoryInstance == null) {
                tanHNodeFactoryInstance = new TanHNodeFactory();
            }
            return tanHNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class TanHPolymorphicNode
        extends TanHBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            TanHPolymorphicNode(TanHBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanHDoubleNode
        extends TanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanHDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            TanHDoubleNode(TanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanHNode create0(MathNodes.TanHNode current2) {
                return new TanHDoubleNode((TanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanHRubyBignumNode
        extends TanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanHRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            TanHRubyBignumNode(TanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanHNode create0(MathNodes.TanHNode current2) {
                return new TanHRubyBignumNode((TanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanHLongNode
        extends TanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanHLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            TanHLongNode(TanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanHNode create0(MathNodes.TanHNode current2) {
                return new TanHLongNode((TanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanHIntNode
        extends TanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanHIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            TanHIntNode(TanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanHNode create0(MathNodes.TanHNode current2) {
                return new TanHIntNode((TanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class TanHUninitializedNode
        extends TanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanHUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            TanHUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            TanHUninitializedNode(TanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                TanHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanHNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new TanHUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        private static abstract class TanHBaseNode
        extends MathNodes.TanHNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected TanHBaseNode next0;

            TanHBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            TanHBaseNode(TanHBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                TanHBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                TanHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new TanHUninitializedNode(this);
                    ((TanHUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = TanHBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new TanHUninitializedNode(this), new TanHPolymorphicNode(this), (TanHBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final TanHBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (TanHBaseNode)TanHIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (TanHBaseNode)TanHLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (TanHBaseNode)TanHRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (TanHBaseNode)TanHDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((TanHBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (TanHBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.TanNode.class)
    public static final class TanNodeFactory
    extends NodeFactoryBase<MathNodes.TanNode> {
        private static TanNodeFactory tanNodeFactoryInstance;

        private TanNodeFactory() {
            super(MathNodes.TanNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.TanNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return TanNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.TanNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return TanUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.TanNode> getInstance() {
            if (tanNodeFactoryInstance == null) {
                tanNodeFactoryInstance = new TanNodeFactory();
            }
            return tanNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class TanPolymorphicNode
        extends TanBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            TanPolymorphicNode(TanBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanDoubleNode
        extends TanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            TanDoubleNode(TanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanNode create0(MathNodes.TanNode current2) {
                return new TanDoubleNode((TanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanRubyBignumNode
        extends TanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            TanRubyBignumNode(TanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanNode create0(MathNodes.TanNode current2) {
                return new TanRubyBignumNode((TanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanLongNode
        extends TanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            TanLongNode(TanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanNode create0(MathNodes.TanNode current2) {
                return new TanLongNode((TanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TanIntNode
        extends TanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            TanIntNode(TanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanNode create0(MathNodes.TanNode current2) {
                return new TanIntNode((TanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class TanUninitializedNode
        extends TanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TanUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            TanUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            TanUninitializedNode(TanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                TanBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.TanNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new TanUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        private static abstract class TanBaseNode
        extends MathNodes.TanNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected TanBaseNode next0;

            TanBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            TanBaseNode(TanBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                TanBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                TanBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new TanUninitializedNode(this);
                    ((TanUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = TanBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new TanUninitializedNode(this), new TanPolymorphicNode(this), (TanBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final TanBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (TanBaseNode)TanIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (TanBaseNode)TanLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (TanBaseNode)TanRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (TanBaseNode)TanDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((TanBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (TanBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.SinHNode.class)
    public static final class SinHNodeFactory
    extends NodeFactoryBase<MathNodes.SinHNode> {
        private static SinHNodeFactory sinHNodeFactoryInstance;

        private SinHNodeFactory() {
            super(MathNodes.SinHNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.SinHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SinHNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.SinHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SinHUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.SinHNode> getInstance() {
            if (sinHNodeFactoryInstance == null) {
                sinHNodeFactoryInstance = new SinHNodeFactory();
            }
            return sinHNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SinHPolymorphicNode
        extends SinHBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SinHPolymorphicNode(SinHBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinHDoubleNode
        extends SinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinHDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            SinHDoubleNode(SinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinHNode create0(MathNodes.SinHNode current2) {
                return new SinHDoubleNode((SinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinHRubyBignumNode
        extends SinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinHRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            SinHRubyBignumNode(SinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinHNode create0(MathNodes.SinHNode current2) {
                return new SinHRubyBignumNode((SinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinHLongNode
        extends SinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinHLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            SinHLongNode(SinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinHNode create0(MathNodes.SinHNode current2) {
                return new SinHLongNode((SinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinHIntNode
        extends SinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinHIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            SinHIntNode(SinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinHNode create0(MathNodes.SinHNode current2) {
                return new SinHIntNode((SinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SinHUninitializedNode
        extends SinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinHUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SinHUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SinHUninitializedNode(SinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SinHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinHNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SinHUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        private static abstract class SinHBaseNode
        extends MathNodes.SinHNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SinHBaseNode next0;

            SinHBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SinHBaseNode(SinHBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SinHBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SinHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SinHUninitializedNode(this);
                    ((SinHUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = SinHBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new SinHUninitializedNode(this), new SinHPolymorphicNode(this), (SinHBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SinHBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (SinHBaseNode)SinHIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (SinHBaseNode)SinHLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (SinHBaseNode)SinHRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (SinHBaseNode)SinHDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SinHBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SinHBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.SinNode.class)
    public static final class SinNodeFactory
    extends NodeFactoryBase<MathNodes.SinNode> {
        private static SinNodeFactory sinNodeFactoryInstance;

        private SinNodeFactory() {
            super(MathNodes.SinNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.SinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SinNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.SinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SinUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.SinNode> getInstance() {
            if (sinNodeFactoryInstance == null) {
                sinNodeFactoryInstance = new SinNodeFactory();
            }
            return sinNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SinPolymorphicNode
        extends SinBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SinPolymorphicNode(SinBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinDoubleNode
        extends SinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            SinDoubleNode(SinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinNode create0(MathNodes.SinNode current2) {
                return new SinDoubleNode((SinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinRubyBignumNode
        extends SinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            SinRubyBignumNode(SinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinNode create0(MathNodes.SinNode current2) {
                return new SinRubyBignumNode((SinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinLongNode
        extends SinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            SinLongNode(SinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinNode create0(MathNodes.SinNode current2) {
                return new SinLongNode((SinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SinIntNode
        extends SinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            SinIntNode(SinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinNode create0(MathNodes.SinNode current2) {
                return new SinIntNode((SinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SinUninitializedNode
        extends SinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SinUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SinUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SinUninitializedNode(SinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.SinNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SinUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        private static abstract class SinBaseNode
        extends MathNodes.SinNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SinBaseNode next0;

            SinBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SinBaseNode(SinBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SinBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SinUninitializedNode(this);
                    ((SinUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = SinBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new SinUninitializedNode(this), new SinPolymorphicNode(this), (SinBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SinBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (SinBaseNode)SinIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (SinBaseNode)SinLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (SinBaseNode)SinRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (SinBaseNode)SinDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SinBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SinBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.Log2Node.class)
    public static final class Log2NodeFactory
    extends NodeFactoryBase<MathNodes.Log2Node> {
        private static Log2NodeFactory log2NodeFactoryInstance;

        private Log2NodeFactory() {
            super(MathNodes.Log2Node.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.Log2Node createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return Log2NodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.Log2Node create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return Log2UninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.Log2Node> getInstance() {
            if (log2NodeFactoryInstance == null) {
                log2NodeFactoryInstance = new Log2NodeFactory();
            }
            return log2NodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class Log2PolymorphicNode
        extends Log2BaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            Log2PolymorphicNode(Log2BaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log2DoubleNode
        extends Log2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log2DoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            Log2DoubleNode(Log2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log2Node create0(MathNodes.Log2Node current2) {
                return new Log2DoubleNode((Log2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log2RubyBignumNode
        extends Log2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log2RubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            Log2RubyBignumNode(Log2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log2Node create0(MathNodes.Log2Node current2) {
                return new Log2RubyBignumNode((Log2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log2LongNode
        extends Log2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log2LongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            Log2LongNode(Log2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log2Node create0(MathNodes.Log2Node current2) {
                return new Log2LongNode((Log2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log2IntNode
        extends Log2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log2IntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            Log2IntNode(Log2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log2Node create0(MathNodes.Log2Node current2) {
                return new Log2IntNode((Log2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class Log2UninitializedNode
        extends Log2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log2UninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            Log2UninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            Log2UninitializedNode(Log2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                Log2BaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log2Node create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new Log2UninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        private static abstract class Log2BaseNode
        extends MathNodes.Log2Node
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected Log2BaseNode next0;

            Log2BaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            Log2BaseNode(Log2BaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                Log2BaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                Log2BaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new Log2UninitializedNode(this);
                    ((Log2UninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = Log2BaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new Log2UninitializedNode(this), new Log2PolymorphicNode(this), (Log2BaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final Log2BaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (Log2BaseNode)Log2IntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (Log2BaseNode)Log2LongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (Log2BaseNode)Log2RubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (Log2BaseNode)Log2DoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((Log2BaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (Log2BaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.Log10Node.class)
    public static final class Log10NodeFactory
    extends NodeFactoryBase<MathNodes.Log10Node> {
        private static Log10NodeFactory log10NodeFactoryInstance;

        private Log10NodeFactory() {
            super(MathNodes.Log10Node.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.Log10Node createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return Log10NodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.Log10Node create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return Log10UninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.Log10Node> getInstance() {
            if (log10NodeFactoryInstance == null) {
                log10NodeFactoryInstance = new Log10NodeFactory();
            }
            return log10NodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class Log10PolymorphicNode
        extends Log10BaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            Log10PolymorphicNode(Log10BaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log10DoubleNode
        extends Log10BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log10DoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            Log10DoubleNode(Log10BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log10Node create0(MathNodes.Log10Node current2) {
                return new Log10DoubleNode((Log10BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log10RubyBignumNode
        extends Log10BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log10RubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            Log10RubyBignumNode(Log10BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log10Node create0(MathNodes.Log10Node current2) {
                return new Log10RubyBignumNode((Log10BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log10LongNode
        extends Log10BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log10LongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            Log10LongNode(Log10BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log10Node create0(MathNodes.Log10Node current2) {
                return new Log10LongNode((Log10BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class Log10IntNode
        extends Log10BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log10IntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            Log10IntNode(Log10BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log10Node create0(MathNodes.Log10Node current2) {
                return new Log10IntNode((Log10BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class Log10UninitializedNode
        extends Log10BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(Log10UninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            Log10UninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            Log10UninitializedNode(Log10BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                Log10BaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.Log10Node create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new Log10UninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        private static abstract class Log10BaseNode
        extends MathNodes.Log10Node
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected Log10BaseNode next0;

            Log10BaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            Log10BaseNode(Log10BaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                Log10BaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                Log10BaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new Log10UninitializedNode(this);
                    ((Log10UninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = Log10BaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new Log10UninitializedNode(this), new Log10PolymorphicNode(this), (Log10BaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final Log10BaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (Log10BaseNode)Log10IntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (Log10BaseNode)Log10LongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (Log10BaseNode)Log10RubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (Log10BaseNode)Log10DoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((Log10BaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (Log10BaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.LogNode.class)
    public static final class LogNodeFactory
    extends NodeFactoryBase<MathNodes.LogNode> {
        private static LogNodeFactory logNodeFactoryInstance;

        private LogNodeFactory() {
            super(MathNodes.LogNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.LogNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LogNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.LogNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LogUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.LogNode> getInstance() {
            if (logNodeFactoryInstance == null) {
                logNodeFactoryInstance = new LogNodeFactory();
            }
            return logNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LogPolymorphicNode
        extends LogBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LogPolymorphicNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogObjectUndefinedPlaceholderNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, UndefinedPlaceholder.class}, 0, 0);

            LogObjectUndefinedPlaceholderNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.function(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.function(frameValue, arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogObjectUndefinedPlaceholderNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogDoubleUndefinedPlaceholderNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, UndefinedPlaceholder.class}, 0, 0);

            LogDoubleUndefinedPlaceholderNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogDoubleUndefinedPlaceholderNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogRubyBignumUndefinedPlaceholderNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogRubyBignumUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, UndefinedPlaceholder.class}, 0, 0);

            LogRubyBignumUndefinedPlaceholderNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogRubyBignumUndefinedPlaceholderNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogLongUndefinedPlaceholderNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogLongUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            LogLongUndefinedPlaceholderNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogLongUndefinedPlaceholderNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogIntUndefinedPlaceholderNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            LogIntUndefinedPlaceholderNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogIntUndefinedPlaceholderNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogDoubleNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            LogDoubleNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogDoubleNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogDoubleRubyBignumNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            LogDoubleRubyBignumNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogDoubleRubyBignumNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogDoubleLongNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            LogDoubleLongNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogDoubleLongNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogDoubleIntNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            LogDoubleIntNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogDoubleIntNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogRubyBignumDoubleNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            LogRubyBignumDoubleNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogRubyBignumDoubleNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogRubyBignumNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            LogRubyBignumNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogRubyBignumNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogRubyBignumLongNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            LogRubyBignumLongNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogRubyBignumLongNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogRubyBignumIntNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            LogRubyBignumIntNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogRubyBignumIntNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogLongDoubleNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            LogLongDoubleNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogLongDoubleNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogLongRubyBignumNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            LogLongRubyBignumNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogLongRubyBignumNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogLongNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            LogLongNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogLongNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogLongIntNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            LogLongIntNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogLongIntNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogIntDoubleNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            LogIntDoubleNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogIntDoubleNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogIntRubyBignumNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            LogIntRubyBignumNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogIntRubyBignumNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogIntLongNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            LogIntLongNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogIntLongNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LogIntNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LogIntNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(MathNodes.LogNode current2) {
                return new LogIntNode((LogBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LogUninitializedNode
        extends LogBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LogUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LogUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LogUninitializedNode(LogBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LogBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LogNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LogUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        private static abstract class LogBaseNode
        extends MathNodes.LogNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LogBaseNode next0;

            LogBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LogBaseNode(LogBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LogBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LogBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LogUninitializedNode(this);
                    ((LogUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = LogBaseNode.createInfo0(reason2, frameValue, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new LogUninitializedNode(this), new LogPolymorphicNode(this), (LogBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LogBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LogBaseNode)LogIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LogBaseNode)LogIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LogBaseNode)LogIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LogBaseNode)LogIntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LogBaseNode)LogLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LogBaseNode)LogLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LogBaseNode)LogLongRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LogBaseNode)LogLongDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LogBaseNode)LogRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LogBaseNode)LogRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LogBaseNode)LogRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LogBaseNode)LogRubyBignumDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LogBaseNode)LogDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LogBaseNode)LogDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LogBaseNode)LogDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LogBaseNode)LogDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                        return (LogBaseNode)LogIntUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (LogBaseNode)LogLongUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                        return (LogBaseNode)LogRubyBignumUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                        return (LogBaseNode)LogDoubleUndefinedPlaceholderNode.create0(this);
                    }
                    return (LogBaseNode)LogObjectUndefinedPlaceholderNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LogBaseNode otherCast = (LogBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LogBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.LGammaNode.class)
    public static final class LGammaNodeFactory
    extends NodeFactoryBase<MathNodes.LGammaNode> {
        private static LGammaNodeFactory lGammaNodeFactoryInstance;

        private LGammaNodeFactory() {
            super(MathNodes.LGammaNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.LGammaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LGammaNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.LGammaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LGammaUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.LGammaNode> getInstance() {
            if (lGammaNodeFactoryInstance == null) {
                lGammaNodeFactoryInstance = new LGammaNodeFactory();
            }
            return lGammaNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LGammaPolymorphicNode
        extends LGammaBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LGammaPolymorphicNode(LGammaBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LGammaDoubleNode
        extends LGammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LGammaDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            LGammaDoubleNode(LGammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.lgamma(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.lgamma(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.LGammaNode create0(MathNodes.LGammaNode current2) {
                return new LGammaDoubleNode((LGammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LGammaRubyBignumNode
        extends LGammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LGammaRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            LGammaRubyBignumNode(LGammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.lgamma(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.lgamma(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.LGammaNode create0(MathNodes.LGammaNode current2) {
                return new LGammaRubyBignumNode((LGammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LGammaLongNode
        extends LGammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LGammaLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            LGammaLongNode(LGammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.lgamma(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.lgamma(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.LGammaNode create0(MathNodes.LGammaNode current2) {
                return new LGammaLongNode((LGammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LGammaIntNode
        extends LGammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LGammaIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            LGammaIntNode(LGammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.lgamma(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.lgamma(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.LGammaNode create0(MathNodes.LGammaNode current2) {
                return new LGammaIntNode((LGammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LGammaUninitializedNode
        extends LGammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LGammaUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LGammaUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LGammaUninitializedNode(LGammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LGammaBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.lgamma(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.LGammaNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LGammaUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        private static abstract class LGammaBaseNode
        extends MathNodes.LGammaNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LGammaBaseNode next0;

            LGammaBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LGammaBaseNode(LGammaBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                LGammaBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LGammaBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LGammaUninitializedNode(this);
                    ((LGammaUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = LGammaBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new LGammaUninitializedNode(this), new LGammaPolymorphicNode(this), (LGammaBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LGammaBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (LGammaBaseNode)LGammaIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (LGammaBaseNode)LGammaLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (LGammaBaseNode)LGammaRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (LGammaBaseNode)LGammaDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LGammaBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LGammaBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.LdexpNode.class)
    public static final class LdexpNodeFactory
    extends NodeFactoryBase<MathNodes.LdexpNode> {
        private static LdexpNodeFactory ldexpNodeFactoryInstance;

        private LdexpNodeFactory() {
            super(MathNodes.LdexpNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.LdexpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LdexpNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.LdexpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LdexpUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.LdexpNode> getInstance() {
            if (ldexpNodeFactoryInstance == null) {
                ldexpNodeFactoryInstance = new LdexpNodeFactory();
            }
            return ldexpNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LdexpPolymorphicNode
        extends LdexpBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LdexpPolymorphicNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpDoubleNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            LdexpDoubleNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpDoubleNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpDoubleLongNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            LdexpDoubleLongNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpDoubleLongNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpDoubleIntNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            LdexpDoubleIntNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpDoubleIntNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpRubyBignumDoubleNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            LdexpRubyBignumDoubleNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpRubyBignumDoubleNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpRubyBignumLongNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            LdexpRubyBignumLongNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpRubyBignumLongNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpRubyBignumIntNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            LdexpRubyBignumIntNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpRubyBignumIntNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpLongDoubleNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            LdexpLongDoubleNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpLongDoubleNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpLongNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            LdexpLongNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpLongNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpLongIntNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            LdexpLongIntNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpLongIntNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpIntDoubleNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            LdexpIntDoubleNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpIntDoubleNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpIntLongNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            LdexpIntLongNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpIntLongNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LdexpIntNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            LdexpIntNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(MathNodes.LdexpNode current2) {
                return new LdexpIntNode((LdexpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LdexpUninitializedNode
        extends LdexpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LdexpUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LdexpUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LdexpUninitializedNode(LdexpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LdexpBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.LdexpNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LdexpUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        private static abstract class LdexpBaseNode
        extends MathNodes.LdexpNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LdexpBaseNode next0;

            LdexpBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LdexpBaseNode(LdexpBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                LdexpBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LdexpBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LdexpUninitializedNode(this);
                    ((LdexpUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = LdexpBaseNode.createInfo0(reason2, frameValue, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new LdexpUninitializedNode(this), new LdexpPolymorphicNode(this), (LdexpBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LdexpBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LdexpBaseNode)LdexpIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LdexpBaseNode)LdexpIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LdexpBaseNode)LdexpIntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LdexpBaseNode)LdexpLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LdexpBaseNode)LdexpLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LdexpBaseNode)LdexpLongDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LdexpBaseNode)LdexpRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LdexpBaseNode)LdexpRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LdexpBaseNode)LdexpRubyBignumDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LdexpBaseNode)LdexpDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LdexpBaseNode)LdexpDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LdexpBaseNode)LdexpDoubleNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LdexpBaseNode otherCast = (LdexpBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LdexpBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.HypotNode.class)
    public static final class HypotNodeFactory
    extends NodeFactoryBase<MathNodes.HypotNode> {
        private static HypotNodeFactory hypotNodeFactoryInstance;

        private HypotNodeFactory() {
            super(MathNodes.HypotNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.HypotNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HypotNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.HypotNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return HypotUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.HypotNode> getInstance() {
            if (hypotNodeFactoryInstance == null) {
                hypotNodeFactoryInstance = new HypotNodeFactory();
            }
            return hypotNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class HypotPolymorphicNode
        extends HypotBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            HypotPolymorphicNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotDoubleNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            HypotDoubleNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotDoubleNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotDoubleRubyBignumNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            HypotDoubleRubyBignumNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotDoubleRubyBignumNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotDoubleLongNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            HypotDoubleLongNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotDoubleLongNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotDoubleIntNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            HypotDoubleIntNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotDoubleIntNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotRubyBignumDoubleNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotRubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            HypotRubyBignumDoubleNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotRubyBignumDoubleNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotRubyBignumNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            HypotRubyBignumNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotRubyBignumNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotRubyBignumLongNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotRubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            HypotRubyBignumLongNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotRubyBignumLongNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotRubyBignumIntNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotRubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            HypotRubyBignumIntNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotRubyBignumIntNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotLongDoubleNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotLongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            HypotLongDoubleNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotLongDoubleNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotLongRubyBignumNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotLongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            HypotLongRubyBignumNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotLongRubyBignumNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotLongNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            HypotLongNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotLongNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotLongIntNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            HypotLongIntNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotLongIntNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotIntDoubleNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotIntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            HypotIntDoubleNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotIntDoubleNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotIntRubyBignumNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            HypotIntRubyBignumNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotIntRubyBignumNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotIntLongNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            HypotIntLongNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotIntLongNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HypotIntNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            HypotIntNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(MathNodes.HypotNode current2) {
                return new HypotIntNode((HypotBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class HypotUninitializedNode
        extends HypotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HypotUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            HypotUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            HypotUninitializedNode(HypotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                HypotBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.HypotNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new HypotUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        private static abstract class HypotBaseNode
        extends MathNodes.HypotNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected HypotBaseNode next0;

            HypotBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            HypotBaseNode(HypotBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                HypotBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                HypotBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new HypotUninitializedNode(this);
                    ((HypotUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = HypotBaseNode.createInfo0(reason2, frameValue, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new HypotUninitializedNode(this), new HypotPolymorphicNode(this), (HypotBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final HypotBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (HypotBaseNode)HypotIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (HypotBaseNode)HypotIntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (HypotBaseNode)HypotIntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (HypotBaseNode)HypotIntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (HypotBaseNode)HypotLongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (HypotBaseNode)HypotLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (HypotBaseNode)HypotLongRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (HypotBaseNode)HypotLongDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (HypotBaseNode)HypotRubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (HypotBaseNode)HypotRubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (HypotBaseNode)HypotRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (HypotBaseNode)HypotRubyBignumDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (HypotBaseNode)HypotDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (HypotBaseNode)HypotDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (HypotBaseNode)HypotDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (HypotBaseNode)HypotDoubleNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    HypotBaseNode otherCast = (HypotBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (HypotBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.GammaNode.class)
    public static final class GammaNodeFactory
    extends NodeFactoryBase<MathNodes.GammaNode> {
        private static GammaNodeFactory gammaNodeFactoryInstance;

        private GammaNodeFactory() {
            super(MathNodes.GammaNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.GammaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GammaNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.GammaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GammaUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.GammaNode> getInstance() {
            if (gammaNodeFactoryInstance == null) {
                gammaNodeFactoryInstance = new GammaNodeFactory();
            }
            return gammaNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GammaPolymorphicNode
        extends GammaBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            GammaPolymorphicNode(GammaBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GammaDoubleNode
        extends GammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GammaDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            GammaDoubleNode(GammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.GammaNode create0(MathNodes.GammaNode current2) {
                return new GammaDoubleNode((GammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GammaRubyBignumNode
        extends GammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GammaRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            GammaRubyBignumNode(GammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.GammaNode create0(MathNodes.GammaNode current2) {
                return new GammaRubyBignumNode((GammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GammaLongNode
        extends GammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GammaLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            GammaLongNode(GammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.GammaNode create0(MathNodes.GammaNode current2) {
                return new GammaLongNode((GammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GammaIntNode
        extends GammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GammaIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            GammaIntNode(GammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.GammaNode create0(MathNodes.GammaNode current2) {
                return new GammaIntNode((GammaBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GammaUninitializedNode
        extends GammaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GammaUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GammaUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GammaUninitializedNode(GammaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                GammaBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.GammaNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GammaUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        private static abstract class GammaBaseNode
        extends MathNodes.GammaNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GammaBaseNode next0;

            GammaBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GammaBaseNode(GammaBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                GammaBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GammaBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new GammaUninitializedNode(this);
                    ((GammaUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = GammaBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new GammaUninitializedNode(this), new GammaPolymorphicNode(this), (GammaBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GammaBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (GammaBaseNode)GammaIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (GammaBaseNode)GammaLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (GammaBaseNode)GammaRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (GammaBaseNode)GammaDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((GammaBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (GammaBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.FrExpNode.class)
    public static final class FrExpNodeFactory
    extends NodeFactoryBase<MathNodes.FrExpNode> {
        private static FrExpNodeFactory frExpNodeFactoryInstance;

        private FrExpNodeFactory() {
            super(MathNodes.FrExpNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.FrExpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FrExpNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.FrExpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FrExpUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.FrExpNode> getInstance() {
            if (frExpNodeFactoryInstance == null) {
                frExpNodeFactoryInstance = new FrExpNodeFactory();
            }
            return frExpNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FrExpPolymorphicNode
        extends FrExpBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FrExpPolymorphicNode(FrExpBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FrExpDoubleNode
        extends FrExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FrExpDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            FrExpDoubleNode(FrExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.frexp(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.frexp(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.FrExpNode create0(MathNodes.FrExpNode current2) {
                return new FrExpDoubleNode((FrExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FrExpRubyBignumNode
        extends FrExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FrExpRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            FrExpRubyBignumNode(FrExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.frexp(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.frexp(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.FrExpNode create0(MathNodes.FrExpNode current2) {
                return new FrExpRubyBignumNode((FrExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FrExpLongNode
        extends FrExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FrExpLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            FrExpLongNode(FrExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.frexp(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.frexp(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.FrExpNode create0(MathNodes.FrExpNode current2) {
                return new FrExpLongNode((FrExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FrExpIntNode
        extends FrExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FrExpIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            FrExpIntNode(FrExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.frexp(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.frexp(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.FrExpNode create0(MathNodes.FrExpNode current2) {
                return new FrExpIntNode((FrExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FrExpUninitializedNode
        extends FrExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FrExpUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FrExpUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FrExpUninitializedNode(FrExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FrExpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.frexp(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.FrExpNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FrExpUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        private static abstract class FrExpBaseNode
        extends MathNodes.FrExpNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FrExpBaseNode next0;

            FrExpBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FrExpBaseNode(FrExpBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FrExpBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FrExpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FrExpUninitializedNode(this);
                    ((FrExpUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = FrExpBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new FrExpUninitializedNode(this), new FrExpPolymorphicNode(this), (FrExpBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FrExpBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (FrExpBaseNode)FrExpIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (FrExpBaseNode)FrExpLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (FrExpBaseNode)FrExpRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (FrExpBaseNode)FrExpDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FrExpBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FrExpBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ExpNode.class)
    public static final class ExpNodeFactory
    extends NodeFactoryBase<MathNodes.ExpNode> {
        private static ExpNodeFactory expNodeFactoryInstance;

        private ExpNodeFactory() {
            super(MathNodes.ExpNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ExpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExpNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ExpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExpUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ExpNode> getInstance() {
            if (expNodeFactoryInstance == null) {
                expNodeFactoryInstance = new ExpNodeFactory();
            }
            return expNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExpPolymorphicNode
        extends ExpBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExpPolymorphicNode(ExpBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExpDoubleNode
        extends ExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ExpDoubleNode(ExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ExpNode create0(MathNodes.ExpNode current2) {
                return new ExpDoubleNode((ExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExpRubyBignumNode
        extends ExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ExpRubyBignumNode(ExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ExpNode create0(MathNodes.ExpNode current2) {
                return new ExpRubyBignumNode((ExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExpLongNode
        extends ExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ExpLongNode(ExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ExpNode create0(MathNodes.ExpNode current2) {
                return new ExpLongNode((ExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExpIntNode
        extends ExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ExpIntNode(ExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ExpNode create0(MathNodes.ExpNode current2) {
                return new ExpIntNode((ExpBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExpUninitializedNode
        extends ExpBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExpUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExpUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExpUninitializedNode(ExpBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ExpNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExpUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        private static abstract class ExpBaseNode
        extends MathNodes.ExpNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExpBaseNode next0;

            ExpBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExpBaseNode(ExpBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ExpBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExpBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExpUninitializedNode(this);
                    ((ExpUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ExpBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ExpUninitializedNode(this), new ExpPolymorphicNode(this), (ExpBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExpBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ExpBaseNode)ExpIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ExpBaseNode)ExpLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ExpBaseNode)ExpRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ExpBaseNode)ExpDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExpBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExpBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ErfcNode.class)
    public static final class ErfcNodeFactory
    extends NodeFactoryBase<MathNodes.ErfcNode> {
        private static ErfcNodeFactory erfcNodeFactoryInstance;

        private ErfcNodeFactory() {
            super(MathNodes.ErfcNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ErfcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ErfcNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ErfcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ErfcUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ErfcNode> getInstance() {
            if (erfcNodeFactoryInstance == null) {
                erfcNodeFactoryInstance = new ErfcNodeFactory();
            }
            return erfcNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ErfcPolymorphicNode
        extends ErfcBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ErfcPolymorphicNode(ErfcBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfcDoubleNode
        extends ErfcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfcDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ErfcDoubleNode(ErfcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfcNode create0(MathNodes.ErfcNode current2) {
                return new ErfcDoubleNode((ErfcBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfcRubyBignumNode
        extends ErfcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfcRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ErfcRubyBignumNode(ErfcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfcNode create0(MathNodes.ErfcNode current2) {
                return new ErfcRubyBignumNode((ErfcBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfcLongNode
        extends ErfcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfcLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ErfcLongNode(ErfcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfcNode create0(MathNodes.ErfcNode current2) {
                return new ErfcLongNode((ErfcBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfcIntNode
        extends ErfcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfcIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ErfcIntNode(ErfcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfcNode create0(MathNodes.ErfcNode current2) {
                return new ErfcIntNode((ErfcBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ErfcUninitializedNode
        extends ErfcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfcUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ErfcUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ErfcUninitializedNode(ErfcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ErfcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfcNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ErfcUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        private static abstract class ErfcBaseNode
        extends MathNodes.ErfcNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ErfcBaseNode next0;

            ErfcBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ErfcBaseNode(ErfcBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ErfcBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ErfcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ErfcUninitializedNode(this);
                    ((ErfcUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ErfcBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ErfcUninitializedNode(this), new ErfcPolymorphicNode(this), (ErfcBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ErfcBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ErfcBaseNode)ErfcIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ErfcBaseNode)ErfcLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ErfcBaseNode)ErfcRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ErfcBaseNode)ErfcDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ErfcBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ErfcBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ErfNode.class)
    public static final class ErfNodeFactory
    extends NodeFactoryBase<MathNodes.ErfNode> {
        private static ErfNodeFactory erfNodeFactoryInstance;

        private ErfNodeFactory() {
            super(MathNodes.ErfNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ErfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ErfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ErfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ErfUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ErfNode> getInstance() {
            if (erfNodeFactoryInstance == null) {
                erfNodeFactoryInstance = new ErfNodeFactory();
            }
            return erfNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ErfPolymorphicNode
        extends ErfBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ErfPolymorphicNode(ErfBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfDoubleNode
        extends ErfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ErfDoubleNode(ErfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfNode create0(MathNodes.ErfNode current2) {
                return new ErfDoubleNode((ErfBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfRubyBignumNode
        extends ErfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ErfRubyBignumNode(ErfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfNode create0(MathNodes.ErfNode current2) {
                return new ErfRubyBignumNode((ErfBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfLongNode
        extends ErfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ErfLongNode(ErfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfNode create0(MathNodes.ErfNode current2) {
                return new ErfLongNode((ErfBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErfIntNode
        extends ErfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ErfIntNode(ErfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfNode create0(MathNodes.ErfNode current2) {
                return new ErfIntNode((ErfBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ErfUninitializedNode
        extends ErfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErfUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ErfUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ErfUninitializedNode(ErfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ErfBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ErfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ErfUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        private static abstract class ErfBaseNode
        extends MathNodes.ErfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ErfBaseNode next0;

            ErfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ErfBaseNode(ErfBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ErfBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ErfBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ErfUninitializedNode(this);
                    ((ErfUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ErfBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ErfUninitializedNode(this), new ErfPolymorphicNode(this), (ErfBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ErfBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ErfBaseNode)ErfIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ErfBaseNode)ErfLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ErfBaseNode)ErfRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ErfBaseNode)ErfDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ErfBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ErfBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.CosHNode.class)
    public static final class CosHNodeFactory
    extends NodeFactoryBase<MathNodes.CosHNode> {
        private static CosHNodeFactory cosHNodeFactoryInstance;

        private CosHNodeFactory() {
            super(MathNodes.CosHNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.CosHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CosHNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.CosHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CosHUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.CosHNode> getInstance() {
            if (cosHNodeFactoryInstance == null) {
                cosHNodeFactoryInstance = new CosHNodeFactory();
            }
            return cosHNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CosHPolymorphicNode
        extends CosHBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CosHPolymorphicNode(CosHBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosHDoubleNode
        extends CosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosHDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            CosHDoubleNode(CosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosHNode create0(MathNodes.CosHNode current2) {
                return new CosHDoubleNode((CosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosHRubyBignumNode
        extends CosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosHRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            CosHRubyBignumNode(CosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosHNode create0(MathNodes.CosHNode current2) {
                return new CosHRubyBignumNode((CosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosHLongNode
        extends CosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosHLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            CosHLongNode(CosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosHNode create0(MathNodes.CosHNode current2) {
                return new CosHLongNode((CosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosHIntNode
        extends CosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosHIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            CosHIntNode(CosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosHNode create0(MathNodes.CosHNode current2) {
                return new CosHIntNode((CosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CosHUninitializedNode
        extends CosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosHUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CosHUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CosHUninitializedNode(CosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CosHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosHNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CosHUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        private static abstract class CosHBaseNode
        extends MathNodes.CosHNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CosHBaseNode next0;

            CosHBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CosHBaseNode(CosHBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                CosHBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CosHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CosHUninitializedNode(this);
                    ((CosHUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = CosHBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new CosHUninitializedNode(this), new CosHPolymorphicNode(this), (CosHBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CosHBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (CosHBaseNode)CosHIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (CosHBaseNode)CosHLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (CosHBaseNode)CosHRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (CosHBaseNode)CosHDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CosHBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CosHBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.CosNode.class)
    public static final class CosNodeFactory
    extends NodeFactoryBase<MathNodes.CosNode> {
        private static CosNodeFactory cosNodeFactoryInstance;

        private CosNodeFactory() {
            super(MathNodes.CosNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.CosNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CosNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.CosNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CosUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.CosNode> getInstance() {
            if (cosNodeFactoryInstance == null) {
                cosNodeFactoryInstance = new CosNodeFactory();
            }
            return cosNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CosPolymorphicNode
        extends CosBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CosPolymorphicNode(CosBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosDoubleNode
        extends CosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            CosDoubleNode(CosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosNode create0(MathNodes.CosNode current2) {
                return new CosDoubleNode((CosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosRubyBignumNode
        extends CosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            CosRubyBignumNode(CosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosNode create0(MathNodes.CosNode current2) {
                return new CosRubyBignumNode((CosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosLongNode
        extends CosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            CosLongNode(CosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosNode create0(MathNodes.CosNode current2) {
                return new CosLongNode((CosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CosIntNode
        extends CosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            CosIntNode(CosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosNode create0(MathNodes.CosNode current2) {
                return new CosIntNode((CosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CosUninitializedNode
        extends CosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CosUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CosUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CosUninitializedNode(CosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CosBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CosNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CosUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        private static abstract class CosBaseNode
        extends MathNodes.CosNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CosBaseNode next0;

            CosBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CosBaseNode(CosBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                CosBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CosBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CosUninitializedNode(this);
                    ((CosUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = CosBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new CosUninitializedNode(this), new CosPolymorphicNode(this), (CosBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CosBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (CosBaseNode)CosIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (CosBaseNode)CosLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (CosBaseNode)CosRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (CosBaseNode)CosDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CosBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CosBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.CbRtNode.class)
    public static final class CbRtNodeFactory
    extends NodeFactoryBase<MathNodes.CbRtNode> {
        private static CbRtNodeFactory cbRtNodeFactoryInstance;

        private CbRtNodeFactory() {
            super(MathNodes.CbRtNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.CbRtNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CbRtNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.CbRtNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CbRtUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.CbRtNode> getInstance() {
            if (cbRtNodeFactoryInstance == null) {
                cbRtNodeFactoryInstance = new CbRtNodeFactory();
            }
            return cbRtNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CbRtPolymorphicNode
        extends CbRtBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CbRtPolymorphicNode(CbRtBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CbRtDoubleNode
        extends CbRtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CbRtDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            CbRtDoubleNode(CbRtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CbRtNode create0(MathNodes.CbRtNode current2) {
                return new CbRtDoubleNode((CbRtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CbRtRubyBignumNode
        extends CbRtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CbRtRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            CbRtRubyBignumNode(CbRtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CbRtNode create0(MathNodes.CbRtNode current2) {
                return new CbRtRubyBignumNode((CbRtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CbRtLongNode
        extends CbRtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CbRtLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            CbRtLongNode(CbRtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CbRtNode create0(MathNodes.CbRtNode current2) {
                return new CbRtLongNode((CbRtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CbRtIntNode
        extends CbRtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CbRtIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            CbRtIntNode(CbRtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CbRtNode create0(MathNodes.CbRtNode current2) {
                return new CbRtIntNode((CbRtBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CbRtUninitializedNode
        extends CbRtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CbRtUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CbRtUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CbRtUninitializedNode(CbRtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CbRtBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.CbRtNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CbRtUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        private static abstract class CbRtBaseNode
        extends MathNodes.CbRtNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CbRtBaseNode next0;

            CbRtBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CbRtBaseNode(CbRtBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                CbRtBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CbRtBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CbRtUninitializedNode(this);
                    ((CbRtUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = CbRtBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new CbRtUninitializedNode(this), new CbRtPolymorphicNode(this), (CbRtBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CbRtBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (CbRtBaseNode)CbRtIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (CbRtBaseNode)CbRtLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (CbRtBaseNode)CbRtRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (CbRtBaseNode)CbRtDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CbRtBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CbRtBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATanHNode.class)
    public static final class ATanHNodeFactory
    extends NodeFactoryBase<MathNodes.ATanHNode> {
        private static ATanHNodeFactory aTanHNodeFactoryInstance;

        private ATanHNodeFactory() {
            super(MathNodes.ATanHNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ATanHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ATanHNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ATanHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ATanHUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ATanHNode> getInstance() {
            if (aTanHNodeFactoryInstance == null) {
                aTanHNodeFactoryInstance = new ATanHNodeFactory();
            }
            return aTanHNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ATanHPolymorphicNode
        extends ATanHBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ATanHPolymorphicNode(ATanHBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanHDoubleNode
        extends ATanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanHDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ATanHDoubleNode(ATanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanHNode create0(MathNodes.ATanHNode current2) {
                return new ATanHDoubleNode((ATanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanHRubyBignumNode
        extends ATanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanHRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ATanHRubyBignumNode(ATanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanHNode create0(MathNodes.ATanHNode current2) {
                return new ATanHRubyBignumNode((ATanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanHLongNode
        extends ATanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanHLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ATanHLongNode(ATanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanHNode create0(MathNodes.ATanHNode current2) {
                return new ATanHLongNode((ATanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanHIntNode
        extends ATanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanHIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ATanHIntNode(ATanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanHNode create0(MathNodes.ATanHNode current2) {
                return new ATanHIntNode((ATanHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ATanHUninitializedNode
        extends ATanHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanHUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ATanHUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ATanHUninitializedNode(ATanHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ATanHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanHNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ATanHUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        private static abstract class ATanHBaseNode
        extends MathNodes.ATanHNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ATanHBaseNode next0;

            ATanHBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ATanHBaseNode(ATanHBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ATanHBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ATanHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ATanHUninitializedNode(this);
                    ((ATanHUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ATanHBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ATanHUninitializedNode(this), new ATanHPolymorphicNode(this), (ATanHBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ATanHBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ATanHBaseNode)ATanHIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ATanHBaseNode)ATanHLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ATanHBaseNode)ATanHRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ATanHBaseNode)ATanHDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ATanHBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ATanHBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATan2Node.class)
    public static final class ATan2NodeFactory
    extends NodeFactoryBase<MathNodes.ATan2Node> {
        private static ATan2NodeFactory aTan2NodeFactoryInstance;

        private ATan2NodeFactory() {
            super(MathNodes.ATan2Node.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ATan2Node createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ATan2NodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ATan2Node create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ATan2UninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ATan2Node> getInstance() {
            if (aTan2NodeFactoryInstance == null) {
                aTan2NodeFactoryInstance = new ATan2NodeFactory();
            }
            return aTan2NodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ATan2PolymorphicNode
        extends ATan2BaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ATan2PolymorphicNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2DoubleNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2DoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            ATan2DoubleNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2DoubleNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2DoubleRubyBignumNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2DoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            ATan2DoubleRubyBignumNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2DoubleRubyBignumNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2DoubleLongNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2DoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            ATan2DoubleLongNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2DoubleLongNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2DoubleIntNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2DoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            ATan2DoubleIntNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2DoubleIntNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2RubyBignumDoubleNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2RubyBignumDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Double.TYPE}, 0, 0);

            ATan2RubyBignumDoubleNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2RubyBignumDoubleNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2RubyBignumNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2RubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyBignum.class}, 0, 0);

            ATan2RubyBignumNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2RubyBignumNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2RubyBignumLongNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2RubyBignumLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Long.TYPE}, 0, 0);

            ATan2RubyBignumLongNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2RubyBignumLongNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2RubyBignumIntNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2RubyBignumIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Integer.TYPE}, 0, 0);

            ATan2RubyBignumIntNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2RubyBignumIntNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2LongDoubleNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2LongDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Double.TYPE}, 0, 0);

            ATan2LongDoubleNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2LongDoubleNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2LongRubyBignumNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2LongRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyBignum.class}, 0, 0);

            ATan2LongRubyBignumNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2LongRubyBignumNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2LongNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2LongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            ATan2LongNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2LongNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2LongIntNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2LongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Integer.TYPE}, 0, 0);

            ATan2LongIntNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2LongIntNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2IntDoubleNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2IntDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Double.TYPE}, 0, 0);

            ATan2IntDoubleNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2IntDoubleNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2IntRubyBignumNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2IntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBignum.class}, 0, 0);

            ATan2IntRubyBignumNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2IntRubyBignumNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2IntLongNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2IntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Long.TYPE}, 0, 0);

            ATan2IntLongNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2IntLongNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATan2IntNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2IntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            ATan2IntNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.function(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.function(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(MathNodes.ATan2Node current2) {
                return new ATan2IntNode((ATan2BaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ATan2UninitializedNode
        extends ATan2BaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATan2UninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ATan2UninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ATan2UninitializedNode(ATan2BaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ATan2BaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MathNodes.ATan2Node create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ATan2UninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        private static abstract class ATan2BaseNode
        extends MathNodes.ATan2Node
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ATan2BaseNode next0;

            ATan2BaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ATan2BaseNode(ATan2BaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ATan2BaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ATan2BaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ATan2UninitializedNode(this);
                    ((ATan2UninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ATan2BaseNode.createInfo0(reason2, frameValue, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ATan2UninitializedNode(this), new ATan2PolymorphicNode(this), (ATan2BaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ATan2BaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ATan2BaseNode)ATan2IntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ATan2BaseNode)ATan2IntLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (ATan2BaseNode)ATan2IntRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (ATan2BaseNode)ATan2IntDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ATan2BaseNode)ATan2LongIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ATan2BaseNode)ATan2LongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (ATan2BaseNode)ATan2LongRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (ATan2BaseNode)ATan2LongDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ATan2BaseNode)ATan2RubyBignumIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ATan2BaseNode)ATan2RubyBignumLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (ATan2BaseNode)ATan2RubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (ATan2BaseNode)ATan2RubyBignumDoubleNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ATan2BaseNode)ATan2DoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ATan2BaseNode)ATan2DoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (ATan2BaseNode)ATan2DoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (ATan2BaseNode)ATan2DoubleNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ATan2BaseNode otherCast = (ATan2BaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ATan2BaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATanNode.class)
    public static final class ATanNodeFactory
    extends NodeFactoryBase<MathNodes.ATanNode> {
        private static ATanNodeFactory aTanNodeFactoryInstance;

        private ATanNodeFactory() {
            super(MathNodes.ATanNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ATanNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ATanNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ATanNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ATanUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ATanNode> getInstance() {
            if (aTanNodeFactoryInstance == null) {
                aTanNodeFactoryInstance = new ATanNodeFactory();
            }
            return aTanNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ATanPolymorphicNode
        extends ATanBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ATanPolymorphicNode(ATanBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanDoubleNode
        extends ATanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ATanDoubleNode(ATanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanNode create0(MathNodes.ATanNode current2) {
                return new ATanDoubleNode((ATanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanRubyBignumNode
        extends ATanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ATanRubyBignumNode(ATanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanNode create0(MathNodes.ATanNode current2) {
                return new ATanRubyBignumNode((ATanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanLongNode
        extends ATanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ATanLongNode(ATanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanNode create0(MathNodes.ATanNode current2) {
                return new ATanLongNode((ATanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ATanIntNode
        extends ATanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ATanIntNode(ATanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanNode create0(MathNodes.ATanNode current2) {
                return new ATanIntNode((ATanBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ATanUninitializedNode
        extends ATanBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ATanUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ATanUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ATanUninitializedNode(ATanBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ATanBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ATanNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ATanUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        private static abstract class ATanBaseNode
        extends MathNodes.ATanNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ATanBaseNode next0;

            ATanBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ATanBaseNode(ATanBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ATanBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ATanBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ATanUninitializedNode(this);
                    ((ATanUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ATanBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ATanUninitializedNode(this), new ATanPolymorphicNode(this), (ATanBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ATanBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ATanBaseNode)ATanIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ATanBaseNode)ATanLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ATanBaseNode)ATanRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ATanBaseNode)ATanDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ATanBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ATanBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ASinHNode.class)
    public static final class ASinHNodeFactory
    extends NodeFactoryBase<MathNodes.ASinHNode> {
        private static ASinHNodeFactory aSinHNodeFactoryInstance;

        private ASinHNodeFactory() {
            super(MathNodes.ASinHNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ASinHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ASinHNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ASinHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ASinHUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ASinHNode> getInstance() {
            if (aSinHNodeFactoryInstance == null) {
                aSinHNodeFactoryInstance = new ASinHNodeFactory();
            }
            return aSinHNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ASinHPolymorphicNode
        extends ASinHBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ASinHPolymorphicNode(ASinHBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinHDoubleNode
        extends ASinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinHDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ASinHDoubleNode(ASinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinHNode create0(MathNodes.ASinHNode current2) {
                return new ASinHDoubleNode((ASinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinHRubyBignumNode
        extends ASinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinHRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ASinHRubyBignumNode(ASinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinHNode create0(MathNodes.ASinHNode current2) {
                return new ASinHRubyBignumNode((ASinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinHLongNode
        extends ASinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinHLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ASinHLongNode(ASinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinHNode create0(MathNodes.ASinHNode current2) {
                return new ASinHLongNode((ASinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinHIntNode
        extends ASinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinHIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ASinHIntNode(ASinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinHNode create0(MathNodes.ASinHNode current2) {
                return new ASinHIntNode((ASinHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ASinHUninitializedNode
        extends ASinHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinHUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ASinHUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ASinHUninitializedNode(ASinHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ASinHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinHNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ASinHUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        private static abstract class ASinHBaseNode
        extends MathNodes.ASinHNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ASinHBaseNode next0;

            ASinHBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ASinHBaseNode(ASinHBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ASinHBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ASinHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ASinHUninitializedNode(this);
                    ((ASinHUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ASinHBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ASinHUninitializedNode(this), new ASinHPolymorphicNode(this), (ASinHBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ASinHBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ASinHBaseNode)ASinHIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ASinHBaseNode)ASinHLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ASinHBaseNode)ASinHRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ASinHBaseNode)ASinHDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ASinHBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ASinHBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ASinNode.class)
    public static final class ASinNodeFactory
    extends NodeFactoryBase<MathNodes.ASinNode> {
        private static ASinNodeFactory aSinNodeFactoryInstance;

        private ASinNodeFactory() {
            super(MathNodes.ASinNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ASinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ASinNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ASinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ASinUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ASinNode> getInstance() {
            if (aSinNodeFactoryInstance == null) {
                aSinNodeFactoryInstance = new ASinNodeFactory();
            }
            return aSinNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ASinPolymorphicNode
        extends ASinBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ASinPolymorphicNode(ASinBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinDoubleNode
        extends ASinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ASinDoubleNode(ASinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinNode create0(MathNodes.ASinNode current2) {
                return new ASinDoubleNode((ASinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinRubyBignumNode
        extends ASinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ASinRubyBignumNode(ASinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinNode create0(MathNodes.ASinNode current2) {
                return new ASinRubyBignumNode((ASinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinLongNode
        extends ASinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ASinLongNode(ASinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinNode create0(MathNodes.ASinNode current2) {
                return new ASinLongNode((ASinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ASinIntNode
        extends ASinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ASinIntNode(ASinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinNode create0(MathNodes.ASinNode current2) {
                return new ASinIntNode((ASinBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ASinUninitializedNode
        extends ASinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ASinUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ASinUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ASinUninitializedNode(ASinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ASinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ASinNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ASinUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        private static abstract class ASinBaseNode
        extends MathNodes.ASinNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ASinBaseNode next0;

            ASinBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ASinBaseNode(ASinBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ASinBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ASinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ASinUninitializedNode(this);
                    ((ASinUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ASinBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ASinUninitializedNode(this), new ASinPolymorphicNode(this), (ASinBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ASinBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ASinBaseNode)ASinIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ASinBaseNode)ASinLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ASinBaseNode)ASinRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ASinBaseNode)ASinDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ASinBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ASinBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ACosHNode.class)
    public static final class ACosHNodeFactory
    extends NodeFactoryBase<MathNodes.ACosHNode> {
        private static ACosHNodeFactory aCosHNodeFactoryInstance;

        private ACosHNodeFactory() {
            super(MathNodes.ACosHNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ACosHNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ACosHNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ACosHNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ACosHUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ACosHNode> getInstance() {
            if (aCosHNodeFactoryInstance == null) {
                aCosHNodeFactoryInstance = new ACosHNodeFactory();
            }
            return aCosHNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ACosHPolymorphicNode
        extends ACosHBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ACosHPolymorphicNode(ACosHBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosHDoubleNode
        extends ACosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosHDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ACosHDoubleNode(ACosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosHNode create0(MathNodes.ACosHNode current2) {
                return new ACosHDoubleNode((ACosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosHRubyBignumNode
        extends ACosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosHRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ACosHRubyBignumNode(ACosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosHNode create0(MathNodes.ACosHNode current2) {
                return new ACosHRubyBignumNode((ACosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosHLongNode
        extends ACosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosHLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ACosHLongNode(ACosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosHNode create0(MathNodes.ACosHNode current2) {
                return new ACosHLongNode((ACosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosHIntNode
        extends ACosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosHIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ACosHIntNode(ACosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosHNode create0(MathNodes.ACosHNode current2) {
                return new ACosHIntNode((ACosHBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ACosHUninitializedNode
        extends ACosHBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosHUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ACosHUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ACosHUninitializedNode(ACosHBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ACosHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosHNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ACosHUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        private static abstract class ACosHBaseNode
        extends MathNodes.ACosHNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ACosHBaseNode next0;

            ACosHBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ACosHBaseNode(ACosHBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ACosHBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ACosHBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ACosHUninitializedNode(this);
                    ((ACosHUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ACosHBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ACosHUninitializedNode(this), new ACosHPolymorphicNode(this), (ACosHBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ACosHBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ACosHBaseNode)ACosHIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ACosHBaseNode)ACosHLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ACosHBaseNode)ACosHRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ACosHBaseNode)ACosHDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ACosHBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ACosHBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=MathNodes.ACosNode.class)
    public static final class ACosNodeFactory
    extends NodeFactoryBase<MathNodes.ACosNode> {
        private static ACosNodeFactory aCosNodeFactoryInstance;

        private ACosNodeFactory() {
            super(MathNodes.ACosNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MathNodes.ACosNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ACosNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MathNodes.ACosNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ACosUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MathNodes.ACosNode> getInstance() {
            if (aCosNodeFactoryInstance == null) {
                aCosNodeFactoryInstance = new ACosNodeFactory();
            }
            return aCosNodeFactoryInstance;
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ACosPolymorphicNode
        extends ACosBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ACosPolymorphicNode(ACosBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosDoubleNode
        extends ACosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ACosDoubleNode(ACosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosNode create0(MathNodes.ACosNode current2) {
                return new ACosDoubleNode((ACosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosRubyBignumNode
        extends ACosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ACosRubyBignumNode(ACosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosNode create0(MathNodes.ACosNode current2) {
                return new ACosRubyBignumNode((ACosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosLongNode
        extends ACosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ACosLongNode(ACosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosNode create0(MathNodes.ACosNode current2) {
                return new ACosLongNode((ACosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ACosIntNode
        extends ACosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ACosIntNode(ACosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.function(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.function(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosNode create0(MathNodes.ACosNode current2) {
                return new ACosIntNode((ACosBaseNode)current2);
            }
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ACosUninitializedNode
        extends ACosBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ACosUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ACosUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ACosUninitializedNode(ACosBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ACosBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    return super.function(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static MathNodes.ACosNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ACosUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        private static abstract class ACosBaseNode
        extends MathNodes.ACosNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ACosBaseNode next0;

            ACosBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ACosBaseNode(ACosBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ACosBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ACosBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ACosUninitializedNode(this);
                    ((ACosUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ACosBaseNode.createInfo0(reason2, frameValue, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ACosUninitializedNode(this), new ACosPolymorphicNode(this), (ACosBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ACosBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ACosBaseNode)ACosIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ACosBaseNode)ACosLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ACosBaseNode)ACosRubyBignumNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ACosBaseNode)ACosDoubleNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ACosBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ACosBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, VirtualFrame frameValue, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

