/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;

@NodeChild(value="child")
public abstract class ProcCastNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toProc;

    public ProcCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toProc = DispatchHeadNodeFactory.createMethodCall(context);
    }

    public ProcCastNode(ProcCastNode prev) {
        super(prev);
        this.toProc = prev.toProc;
    }

    @Specialization
    public RubyNilClass doNil(RubyNilClass nil) {
        return nil;
    }

    @Specialization
    public RubyProc doRubyProc(RubyProc proc) {
        return proc;
    }

    @Specialization
    public RubyProc doObject(VirtualFrame frame, RubyBasicObject object) {
        ProcCastNode.notDesignedForCompilation();
        return (RubyProc)this.toProc.call(frame, object, "to_proc", null, new Object[0]);
    }
}

