/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.math.BigInteger;
import java.util.ArrayList;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Backref;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryCurrentModuleVariable;
import org.jruby.ir.operands.TemporaryCurrentScopeVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;

class OperandDecoderMap {
    private final IRReaderDecoder d;
    private final IRManager manager;

    public OperandDecoderMap(IRManager manager, IRReaderDecoder decoder) {
        this.manager = manager;
        this.d = decoder;
    }

    public Operand decode(OperandType type2) {
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("Decoding operand " + (Object)((Object)type2));
        }
        switch (type2) {
            case ARRAY: {
                return new Array(this.d.decodeOperandList());
            }
            case AS_STRING: {
                return new AsString(this.d.decodeOperand());
            }
            case BACKREF: {
                return new Backref(this.d.decodeChar());
            }
            case BIGNUM: {
                return new Bignum(new BigInteger(this.d.decodeString()));
            }
            case BOOLEAN: {
                return new UnboxedBoolean(this.d.decodeBoolean());
            }
            case CURRENT_SCOPE: {
                return new CurrentScope(this.d.decodeInt());
            }
            case DYNAMIC_SYMBOL: {
                return new DynamicSymbol(this.d.decodeOperand());
            }
            case FIXNUM: {
                return new Fixnum(this.d.decodeLong());
            }
            case FLOAT: {
                return new Float(this.d.decodeDouble());
            }
            case GLOBAL_VARIABLE: {
                return new GlobalVariable(this.d.decodeString());
            }
            case HASH: {
                return this.decodeHash();
            }
            case IR_EXCEPTION: {
                return IRException.getExceptionFromOrdinal(this.d.decodeByte());
            }
            case LABEL: {
                return this.decodeLabel();
            }
            case LOCAL_VARIABLE: {
                return this.d.getCurrentScope().getLocalVariable(this.d.decodeString(), this.d.decodeInt());
            }
            case NIL: {
                return this.manager.getNil();
            }
            case NTH_REF: {
                return new NthRef(this.d.decodeInt());
            }
            case OBJECT_CLASS: {
                return new ObjectClass();
            }
            case REGEXP: {
                return this.decodeRegexp();
            }
            case SCOPE_MODULE: {
                return new ScopeModule(this.d.decodeInt());
            }
            case SELF: {
                return Self.SELF;
            }
            case SPLAT: {
                return new Splat(this.d.decodeOperand());
            }
            case STANDARD_ERROR: {
                return new StandardError();
            }
            case STRING_LITERAL: {
                return new StringLiteral(this.d.decodeString());
            }
            case SVALUE: {
                return new SValue(this.d.decodeOperand());
            }
            case SYMBOL: {
                return new Symbol(this.d.decodeString(), USASCIIEncoding.INSTANCE);
            }
            case TEMPORARY_VARIABLE: {
                return this.decodeTemporaryVariable();
            }
            case UNBOXED_BOOLEAN: {
                return new UnboxedBoolean(this.d.decodeBoolean());
            }
            case UNBOXED_FIXNUM: {
                return new UnboxedFixnum(this.d.decodeLong());
            }
            case UNBOXED_FLOAT: {
                return new UnboxedFloat(this.d.decodeDouble());
            }
            case UNDEFINED_VALUE: {
                return UndefinedValue.UNDEFINED;
            }
            case UNEXECUTABLE_NIL: {
                return UnexecutableNil.U_NIL;
            }
            case WRAPPED_IR_CLOSURE: {
                return new WrappedIRClosure(this.d.decodeVariable(), (IRClosure)this.d.decodeScope());
            }
        }
        return null;
    }

    private Operand decodeHash() {
        int size2 = this.d.decodeInt();
        ArrayList<KeyValuePair<Operand, Operand>> pairs = new ArrayList<KeyValuePair<Operand, Operand>>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            pairs.add(new KeyValuePair<Operand, Operand>(this.d.decodeOperand(), this.d.decodeOperand()));
        }
        return new Hash(pairs);
    }

    private Operand decodeLabel() {
        String prefix = this.d.decodeString();
        int id2 = this.d.decodeInt();
        if ("_GLOBAL_ENSURE_BLOCK".equals(prefix)) {
            return new Label("_GLOBAL_ENSURE_BLOCK", 0);
        }
        String fullLabel = prefix + "_" + id2;
        if (this.d.getVars().containsKey(fullLabel)) {
            return this.d.getVars().get(fullLabel);
        }
        Label newLabel = new Label(prefix, id2);
        this.d.getVars().put(fullLabel, newLabel);
        return newLabel;
    }

    private Regexp decodeRegexp() {
        Operand regex = this.d.decodeOperand();
        boolean isNone = this.d.decodeBoolean();
        RegexpOptions options2 = RegexpOptions.fromEmbeddedOptions(this.d.decodeInt());
        options2.setEncodingNone(isNone);
        return new Regexp(regex, options2);
    }

    private Operand decodeTemporaryVariable() {
        TemporaryVariableType type2 = this.d.decodeTemporaryVariableType();
        switch (type2) {
            case CLOSURE: {
                return new TemporaryClosureVariable(this.d.decodeInt(), this.d.decodeInt());
            }
            case CURRENT_MODULE: {
                return TemporaryCurrentModuleVariable.ModuleVariableFor(this.d.decodeInt());
            }
            case CURRENT_SCOPE: {
                return TemporaryCurrentScopeVariable.ScopeVariableFor(this.d.decodeInt());
            }
            case FLOAT: {
                return new TemporaryFloatVariable(this.d.decodeInt());
            }
            case FIXNUM: {
                return new TemporaryFixnumVariable(this.d.decodeInt());
            }
            case LOCAL: {
                return new TemporaryLocalVariable(this.d.decodeInt());
            }
        }
        return null;
    }
}

