/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Arrays;
import org.jruby.RubyModule;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RuntimeHelperCall
extends ResultBaseInstr {
    Methods helperMethod;

    public RuntimeHelperCall(Variable result2, Methods helperMethod, Operand[] args2) {
        super(Operation.RUNTIME_HELPER, result2, args2);
        this.helperMethod = helperMethod;
    }

    public Operand[] getArgs() {
        return this.operands;
    }

    public Methods getHelperMethod() {
        return this.helperMethod;
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        boolean modifiedScope = false;
        if (this.helperMethod == Methods.IS_DEFINED_SUPER) {
            modifiedScope = true;
            scope.getFlags().add(IRFlags.REQUIRES_FRAME);
        }
        return modifiedScope;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        Variable var = this.getResult();
        return new RuntimeHelperCall(var == null ? null : ii.getRenamedVariable(var), this.helperMethod, this.cloneOperands(ii));
    }

    @Override
    public String toString() {
        return (this.getResult() == null ? "" : this.getResult() + " = ") + (Object)((Object)this.getOperation()) + "(" + (Object)((Object)this.helperMethod) + ", " + Arrays.toString(this.getArgs()) + ")";
    }

    public IRubyObject callHelper(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block.Type blockType) {
        StaticScope scope = currDynScope.getStaticScope();
        if (this.helperMethod == Methods.IS_DEFINED_BACKREF) {
            return IRRuntimeHelpers.isDefinedBackref(context);
        }
        switch (this.helperMethod) {
            case IS_DEFINED_NTH_REF: {
                return IRRuntimeHelpers.isDefinedNthRef(context, (int)((Fixnum)this.operands[0]).getValue());
            }
            case IS_DEFINED_GLOBAL: {
                return IRRuntimeHelpers.isDefinedGlobal(context, ((StringLiteral)this.operands[0]).getString());
            }
            case CHECK_FOR_LJE: {
                IRRuntimeHelpers.checkForLJE(context, currDynScope, ((Boolean)this.operands[0]).isTrue(), blockType);
                return null;
            }
        }
        Object arg1 = this.operands[0].retrieve(context, self2, currScope, currDynScope, temp);
        switch (this.helperMethod) {
            case HANDLE_PROPAGATE_BREAK: {
                return IRRuntimeHelpers.handlePropagatedBreak(context, currDynScope, arg1, blockType);
            }
            case HANDLE_NONLOCAL_RETURN: {
                return IRRuntimeHelpers.handleNonlocalReturn(scope, currDynScope, arg1, blockType);
            }
            case HANDLE_BREAK_AND_RETURNS_IN_LAMBDA: {
                return IRRuntimeHelpers.handleBreakAndReturnsInLambdas(context, scope, currDynScope, arg1, blockType);
            }
            case IS_DEFINED_CALL: {
                return IRRuntimeHelpers.isDefinedCall(context, self2, (IRubyObject)arg1, ((StringLiteral)this.operands[1]).getString());
            }
            case IS_DEFINED_CONSTANT_OR_METHOD: {
                return IRRuntimeHelpers.isDefinedConstantOrMethod(context, (IRubyObject)arg1, ((StringLiteral)this.operands[1]).getString());
            }
            case IS_DEFINED_INSTANCE_VAR: {
                return IRRuntimeHelpers.isDefinedInstanceVar(context, (IRubyObject)arg1, ((StringLiteral)this.operands[1]).getString());
            }
            case IS_DEFINED_CLASS_VAR: {
                return IRRuntimeHelpers.isDefinedClassVar(context, (RubyModule)arg1, ((StringLiteral)this.operands[1]).getString());
            }
            case IS_DEFINED_SUPER: {
                return IRRuntimeHelpers.isDefinedSuper(context, (IRubyObject)arg1);
            }
            case IS_DEFINED_METHOD: {
                return IRRuntimeHelpers.isDefinedMethod(context, (IRubyObject)arg1, ((StringLiteral)this.operands[1]).getString(), ((Boolean)this.operands[2]).isTrue());
            }
            case MERGE_KWARGS: {
                return IRRuntimeHelpers.mergeKeywordArguments(context, (IRubyObject)arg1, (IRubyObject)this.getArgs()[1].retrieve(context, self2, currScope, currDynScope, temp));
            }
        }
        throw new RuntimeException("Unknown IR runtime helper method: " + (Object)((Object)this.helperMethod) + "; INSTR: " + this);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.RuntimeHelperCall(this);
    }

    public static enum Methods {
        HANDLE_PROPAGATE_BREAK,
        HANDLE_NONLOCAL_RETURN,
        HANDLE_BREAK_AND_RETURNS_IN_LAMBDA,
        IS_DEFINED_BACKREF,
        IS_DEFINED_NTH_REF,
        IS_DEFINED_GLOBAL,
        IS_DEFINED_INSTANCE_VAR,
        IS_DEFINED_CLASS_VAR,
        IS_DEFINED_SUPER,
        IS_DEFINED_METHOD,
        IS_DEFINED_CALL,
        IS_DEFINED_CONSTANT_OR_METHOD,
        MERGE_KWARGS,
        CHECK_FOR_LJE;

    }
}

