/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveRestArgInstr
extends ReceiveArgBase
implements FixedArityInstr {
    public final int required;

    public ReceiveRestArgInstr(Variable result2, int required, int argIndex) {
        super(Operation.RECV_REST_ARG, result2, argIndex);
        this.required = required;
    }

    @Override
    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.required + ", " + this.argIndex + ")";
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{new Fixnum(this.required), new Fixnum(this.argIndex)};
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReceiveRestArgInstr(info.getRenamedVariable(this.result), this.required, this.argIndex);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            return new CopyInstr(ii.getRenamedVariable(this.result), ii.getArg(this.argIndex, true));
        }
        return new RestArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argIndex, this.required - this.argIndex, this.argIndex);
    }

    @Override
    public IRubyObject receiveArg(ThreadContext context, IRubyObject[] args2, boolean acceptsKeywordArguments) {
        return IRRuntimeHelpers.receiveRestArg(context, args2, this.required, this.argIndex, acceptsKeywordArguments);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveRestArgInstr(this);
    }
}

