/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class Instr {
    public static final Operand[] EMPTY_OPERANDS = new Operand[0];
    protected Operand[] operands;
    private int ipc = -1;
    private int rpc = -1;
    private final Operation operation;
    private boolean isDead;

    public Instr(Operation operation, Operand[] operands) {
        this.operation = operation;
        this.operands = operands;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.isDead() ? "[DEAD]" : "");
        if (this instanceof ResultInstr) {
            buf.append(((ResultInstr)((Object)this)).getResult()).append(" = ");
        }
        buf.append((Object)this.operation);
        if (this.operands.length > 0) {
            buf.append("(");
            for (int i2 = 0; i2 < this.operands.length - 1; ++i2) {
                buf.append(this.operands[i2]).append(", ");
            }
            buf.append(this.operands[this.operands.length - 1]).append(")");
        }
        return buf.toString();
    }

    @Interp
    public Operation getOperation() {
        return this.operation;
    }

    @Interp
    public int getIPC() {
        return this.ipc;
    }

    @Interp
    public void setIPC(int ipc) {
        this.ipc = ipc;
    }

    @Interp
    public int getRPC() {
        return this.rpc;
    }

    @Interp
    public void setRPC(int rpc) {
        this.rpc = rpc;
    }

    public boolean hasSideEffects() {
        return this.operation.hasSideEffects();
    }

    public boolean canRaiseException() {
        return this.operation.canRaiseException();
    }

    public boolean transfersControl() {
        return this.operation.transfersControl();
    }

    public boolean computeScopeFlags(IRScope scope) {
        return false;
    }

    public boolean canBeDeleted(IRScope s2) {
        if (this.hasSideEffects() || this.operation.isDebugOp() || this.canRaiseException() || this.transfersControl()) {
            return false;
        }
        if (this instanceof ResultInstr) {
            Variable r = ((ResultInstr)((Object)this)).getResult();
            if (s2.bindingHasEscaped()) {
                return !(r instanceof LocalVariable);
            }
        }
        return true;
    }

    public void markDead() {
        this.isDead = true;
    }

    @Interp
    public boolean isDead() {
        return this.isDead;
    }

    public Operand[] getOperands() {
        return this.operands;
    }

    public List<Variable> getUsedVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Operand operand : this.operands) {
            operand.addUsedVariables(vars);
        }
        return vars;
    }

    public void renameVars(Map<Operand, Operand> renameMap) {
        ResultInstr ri;
        Variable oldVar;
        Variable newVar;
        this.simplifyOperands(renameMap, true);
        if (this instanceof ResultInstr && (newVar = (Variable)renameMap.get(oldVar = (ri = (ResultInstr)((Object)this)).getResult())) != null) {
            ri.updateResult(newVar);
        }
    }

    public abstract Instr clone(CloneInfo var1);

    public Operand[] cloneOperands(CloneInfo info) {
        Operand[] newOperands = new Operand[this.operands.length];
        for (int i2 = 0; i2 < this.operands.length; ++i2) {
            newOperands[i2] = this.operands[i2].cloneForInlining(info);
        }
        return newOperands;
    }

    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        for (int i2 = 0; i2 < this.operands.length; ++i2) {
            this.operands[i2] = this.operands[i2].getSimplifiedOperand(valueMap, force);
        }
    }

    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        return null;
    }

    @Interp
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    @Interp
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    public void visit(IRVisitor visitor) {
        throw new RuntimeException(this.getClass().getSimpleName() + " has no compile logic");
    }
}

