/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jcodings.specific.USASCIIEncoding;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ConstMissingInstr
extends CallInstr
implements FixedArityInstr {
    private final String missingConst;

    public ConstMissingInstr(Variable result2, Operand currentModule, String missingConst) {
        super(Operation.CONST_MISSING, CallType.FUNCTIONAL, result2, "const_missing", currentModule, new Operand[]{new Symbol(missingConst, USASCIIEncoding.INSTANCE)}, null);
        this.missingConst = missingConst;
    }

    public String getMissingConst() {
        return this.missingConst;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ConstMissingInstr(ii.getRenamedVariable(this.result), this.getReceiver().cloneForInlining(ii), this.missingConst);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.getReceiver() + "," + this.missingConst + ")";
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyModule module = (RubyModule)this.getReceiver().retrieve(context, self2, currScope, currDynScope, temp);
        return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(this.missingConst));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ConstMissingInstr(this);
    }
}

