/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneFloatArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.CallType;

public class CallInstr
extends CallBase
implements ResultInstr {
    protected Variable result;

    public static CallInstr create(Variable result2, String name2, Operand receiver2, Operand[] args2, Operand closure) {
        if (!CallInstr.containsArgSplat(args2)) {
            boolean hasClosure;
            boolean bl = hasClosure = closure != null;
            if (args2.length == 0 && !hasClosure) {
                return new ZeroOperandArgNoBlockCallInstr(result2, name2, receiver2, args2);
            }
            if (args2.length == 1) {
                if (hasClosure) {
                    return new OneOperandArgBlockCallInstr(result2, name2, receiver2, args2, closure);
                }
                if (CallInstr.isAllFixnums(args2)) {
                    return new OneFixnumArgNoBlockCallInstr(result2, name2, receiver2, args2);
                }
                if (CallInstr.isAllFloats(args2)) {
                    return new OneFloatArgNoBlockCallInstr(result2, name2, receiver2, args2);
                }
                return new OneOperandArgNoBlockCallInstr(result2, name2, receiver2, args2);
            }
        }
        return new CallInstr(CallType.NORMAL, result2, name2, receiver2, args2, closure);
    }

    public static CallInstr create(CallType callType, Variable result2, String name2, Operand receiver2, Operand[] args2, Operand closure) {
        return new CallInstr(callType, result2, name2, receiver2, args2, closure);
    }

    public CallInstr(CallType callType, Variable result2, String name2, Operand receiver2, Operand[] args2, Operand closure) {
        this(Operation.CALL, callType, result2, name2, receiver2, args2, closure);
    }

    protected CallInstr(Operation op, CallType callType, Variable result2, String name2, Operand receiver2, Operand[] args2, Operand closure) {
        super(op, callType, name2, receiver2, args2, closure);
        assert (result2 != null);
        this.result = result2;
    }

    public CallInstr(Operation op, CallInstr ordinary) {
        this(op, ordinary.getCallType(), ordinary.getResult(), ordinary.getName(), ordinary.getReceiver(), ordinary.getCallArgs(), ordinary.getClosureArg(null));
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    public Instr discardResult() {
        return NoResultCallInstr.create(this.getCallType(), this.getName(), this.getReceiver(), this.getCallArgs(), this.getClosureArg());
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new CallInstr(this.getCallType(), ii.getRenamedVariable(this.result), this.getName(), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.getClosureArg() == null ? null : this.getClosureArg().cloneForInlining(ii));
    }

    @Override
    public String toString() {
        return "" + this.result + " = " + super.toString();
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CallInstr(this);
    }
}

