/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuildCompoundArrayInstr
extends ResultBaseInstr {
    private boolean isArgsPush;

    public BuildCompoundArrayInstr(Variable result2, Operand a1, Operand a2, boolean isArgsPush) {
        super(Operation.BUILD_COMPOUND_ARRAY, result2, new Operand[]{a1, a2});
        this.isArgsPush = isArgsPush;
    }

    public Operand getAppendingArg() {
        return this.operands[0];
    }

    public Operand getAppendedArg() {
        return this.operands[1];
    }

    public boolean isArgsPush() {
        return this.isArgsPush;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildCompoundArrayInstr(ii.getRenamedVariable(this.result), this.getAppendingArg().cloneForInlining(ii), this.getAppendedArg().cloneForInlining(ii), this.isArgsPush);
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject v1 = (IRubyObject)this.getAppendingArg().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject v2 = (IRubyObject)this.getAppendedArg().retrieve(context, self2, currScope, currDynScope, temp);
        return this.isArgsPush ? Helpers.argsPush((RubyArray)v1, v2) : Helpers.argsCat(v1, v2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildCompoundArrayInstr(this);
    }

    @Override
    public String toString() {
        return this.result + " = " + (this.isArgsPush ? "ArgsPush[" : "ArgsCat:[") + this.getAppendingArg() + ", " + this.getAppendedArg() + "]";
    }
}

