/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class CompiledIRMethod
extends JavaMethod
implements MethodArgs2,
PositionAware {
    private static final Logger LOG = LoggerFactory.getLogger("CompiledIRMethod");
    protected final MethodHandle variable;
    protected final MethodHandle specific;
    protected final int specificArity;
    protected final IRScope method;
    private final Arity arity;
    private String[] parameterList;

    public CompiledIRMethod(MethodHandle variable, IRScope method, Visibility visibility, RubyModule implementationClass) {
        this(variable, null, -1, method, visibility, implementationClass);
    }

    public CompiledIRMethod(MethodHandle variable, MethodHandle specific, int specificArity, IRScope method, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, CallConfiguration.FrameNoneScopeNone, method.getName());
        this.variable = variable;
        this.specific = specific;
        this.specificArity = specificArity;
        this.method = method;
        this.method.getStaticScope().determineModule();
        this.arity = this.calculateArity();
        this.setHandle(variable);
    }

    public IRScope getIRMethod() {
        return this.method;
    }

    @Override
    public StaticScope getStaticScope() {
        return this.method.getStaticScope();
    }

    public MethodHandle getHandleFor(int arity2) {
        if (this.specificArity != -1 && arity2 == this.specificArity) {
            return this.specific;
        }
        return null;
    }

    @Override
    public String[] getParameterList() {
        if (this.parameterList != null) {
            return this.parameterList;
        }
        this.parameterList = Helpers.irMethodArgsToParameters(((IRMethod)this.method).getArgDesc());
        return this.parameterList;
    }

    private Arity calculateArity() {
        StaticScope s2 = this.getStaticScope();
        if (s2.getOptionalArgs() > 0 || s2.getRestArg() >= 0) {
            return Arity.required(s2.getRequiredArgs());
        }
        return Arity.createArity(s2.getRequiredArgs());
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    protected void post(ThreadContext context) {
        if (!this.method.hasExplicitCallProtocol()) {
            context.popFrame();
            context.postMethodScopeOnly();
        }
    }

    protected void pre(ThreadContext context, IRubyObject self2, String name2, Block block) {
        if (!this.method.hasExplicitCallProtocol()) {
            RubyModule implementationClass = this.getImplementationClass();
            context.preMethodFrameAndScope(implementationClass, name2, self2, block, this.method.getStaticScope());
            context.setCurrentVisibility(Visibility.PUBLIC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        this.pre(context, self2, name2, block);
        try {
            IRubyObject iRubyObject = this.variable.invokeExact(context, this.method.getStaticScope(), self2, args2, block, this.implementationClass);
            return iRubyObject;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        this.pre(context, self2, name2, block);
        try {
            IRubyObject iRubyObject = this.specific.invokeExact(context, this.method.getStaticScope(), self2, block, this.implementationClass);
            return iRubyObject;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, Helpers.arrayOf(arg0), block);
        }
        this.pre(context, self2, name2, block);
        try {
            IRubyObject iRubyObject = this.specific.invokeExact(context, this.method.getStaticScope(), self2, arg0, block, this.implementationClass);
            return iRubyObject;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, Helpers.arrayOf(arg0, arg1), block);
        }
        this.pre(context, self2, name2, block);
        try {
            IRubyObject iRubyObject = this.specific.invokeExact(context, this.method.getStaticScope(), self2, arg0, arg1, block, this.implementationClass);
            return iRubyObject;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, Helpers.arrayOf(arg0, arg1, arg2), block);
        }
        this.pre(context, self2, name2, block);
        try {
            IRubyObject iRubyObject = this.specific.invokeExact(context, this.method.getStaticScope(), self2, arg0, arg1, arg2, block, this.implementationClass);
            return iRubyObject;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            IRubyObject iRubyObject = null;
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    public boolean hasExplicitCallProtocol() {
        return this.method.hasExplicitCallProtocol();
    }

    @Override
    public DynamicMethod dup() {
        return new CompiledIRMethod(this.variable, this.specific, this.specificArity, this.method, this.visibility, this.implementationClass);
    }

    @Override
    public String getFile() {
        return this.method.getFileName();
    }

    @Override
    public int getLine() {
        return this.method.getLineNumber();
    }
}

