/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;

public class MultipleAsgn19Node
extends AssignableNode {
    private final ListNode pre;
    private final Node rest;
    private final ListNode post;
    private final Arity arity;

    public MultipleAsgn19Node(ISourcePosition position, ListNode pre, Node rest2, ListNode post) {
        super(position);
        this.pre = pre;
        this.rest = rest2;
        this.post = post;
        this.arity = this.getRest() != null ? Arity.required(this.getPreCount() + this.getPostCount()) : Arity.fixed(this.getPreCount() + this.getPostCount());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGN19NODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getRest() {
        return this.rest;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.pre, this.rest, this.getValueNode());
    }
}

