/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes.serial;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.serial.SerializerConstantPool;
import com.oracle.truffle.api.nodes.serial.UnsupportedConstantPoolTypeException;
import com.oracle.truffle.api.nodes.serial.VariableLengthIntBuffer;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public final class PostOrderSerializer {
    private static final Unsafe unsafe = PostOrderSerializer.loadUnsafe();
    private final SerializerConstantPool cp;

    public PostOrderSerializer(SerializerConstantPool cp) {
        this.cp = cp;
    }

    public byte[] serialize(Node node) throws UnsupportedConstantPoolTypeException {
        VariableLengthIntBuffer buffer = new VariableLengthIntBuffer(ByteBuffer.allocate(512));
        this.serialize(buffer, node);
        return buffer.getBytes();
    }

    private void serialize(VariableLengthIntBuffer buffer, Node node) throws UnsupportedConstantPoolTypeException {
        if (node == null) {
            buffer.put(-1);
            return;
        }
        Class<?> nodeClass = node.getClass();
        NodeUtil.NodeField[] nodeFields = NodeUtil.NodeClass.get(nodeClass).getFields();
        this.serializeChildFields(buffer, node, nodeFields);
        this.serializeChildrenFields(buffer, node, nodeFields);
        buffer.put(this.cp.putClass(node.getClass()));
        this.serializeDataFields(buffer, node, nodeFields);
    }

    private void serializeDataFields(VariableLengthIntBuffer buffer, Node node, NodeUtil.NodeField[] nodeFields) throws UnsupportedConstantPoolTypeException {
        int i2 = 0;
        while (i2 < nodeFields.length) {
            NodeUtil.NodeField field2 = nodeFields[i2];
            if (field2.getKind() == NodeUtil.NodeFieldKind.DATA) {
                Class<?> fieldClass = field2.getType();
                long offset2 = field2.getOffset();
                if (!field2.getType().isAssignableFrom(SourceSection.class)) {
                    int cpi = fieldClass == Integer.TYPE ? this.cp.putInt(unsafe.getInt(node, offset2)) : (fieldClass == Long.TYPE ? this.cp.putLong(unsafe.getLong(node, offset2)) : (fieldClass == Float.TYPE ? this.cp.putFloat(unsafe.getFloat(node, offset2)) : (fieldClass == Double.TYPE ? this.cp.putDouble(unsafe.getDouble(node, offset2)) : (fieldClass == Byte.TYPE ? this.cp.putInt(unsafe.getByte(node, offset2)) : (fieldClass == Short.TYPE ? this.cp.putInt(unsafe.getShort(node, offset2)) : (fieldClass == Character.TYPE ? this.cp.putInt(unsafe.getChar(node, offset2)) : (fieldClass == Boolean.TYPE ? this.cp.putInt(unsafe.getBoolean(node, offset2) ? 1 : 0) : this.serializeDataFieldsObject(node, fieldClass, offset2))))))));
                    buffer.put(cpi);
                }
            }
            ++i2;
        }
    }

    private int serializeDataFieldsObject(Node node, Class<?> fieldClass, long offset2) {
        Object value2 = unsafe.getObject(node, offset2);
        if (value2 == null) {
            return -1;
        }
        if (fieldClass == Integer.class) {
            return this.cp.putInt((Integer)value2);
        }
        if (fieldClass == Long.class) {
            return this.cp.putLong((Long)value2);
        }
        if (fieldClass == Float.class) {
            return this.cp.putFloat(((Float)value2).floatValue());
        }
        if (fieldClass == Double.class) {
            return this.cp.putDouble((Double)value2);
        }
        if (fieldClass == Byte.class) {
            return this.cp.putInt(((Byte)value2).byteValue());
        }
        if (fieldClass == Short.class) {
            return this.cp.putInt(((Short)value2).shortValue());
        }
        if (fieldClass == Character.class) {
            return this.cp.putInt(((Character)value2).charValue());
        }
        if (fieldClass == Boolean.class) {
            return this.cp.putInt((Boolean)value2 != false ? 1 : 0);
        }
        return this.cp.putObject(fieldClass, value2);
    }

    private void serializeChildrenFields(VariableLengthIntBuffer buffer, Node nodeInstance, NodeUtil.NodeField[] nodeFields) throws UnsupportedConstantPoolTypeException {
        int i2 = 0;
        while (i2 < nodeFields.length) {
            NodeUtil.NodeField field2 = nodeFields[i2];
            if (field2.getKind() == NodeUtil.NodeFieldKind.CHILDREN) {
                Object childArrayObject = unsafe.getObject(nodeInstance, field2.getOffset());
                if (childArrayObject != null && !(childArrayObject instanceof Node[])) {
                    throw new AssertionError((Object)"Node children must be instanceof Node[]");
                }
                buffer.put(this.cp.putClass(field2.getType()));
                Node[] childArray = (Node[])childArrayObject;
                if (childArray == null) {
                    buffer.put(-1);
                } else {
                    buffer.put(this.cp.putInt(childArray.length));
                    int j = 0;
                    while (j < childArray.length) {
                        this.serialize(buffer, childArray[j]);
                        ++j;
                    }
                }
            }
            ++i2;
        }
    }

    private void serializeChildFields(VariableLengthIntBuffer buffer, Node nodeInstance, NodeUtil.NodeField[] nodeFields) throws UnsupportedConstantPoolTypeException {
        int i2 = 0;
        while (i2 < nodeFields.length) {
            NodeUtil.NodeField field2 = nodeFields[i2];
            if (field2.getKind() == NodeUtil.NodeFieldKind.CHILD) {
                Object childObject = unsafe.getObject(nodeInstance, field2.getOffset());
                if (childObject != null && !(childObject instanceof Node)) {
                    throw new AssertionError((Object)"Node children must be instanceof Node");
                }
                this.serialize(buffer, (Node)childObject);
            }
            ++i2;
        }
    }

    private static Unsafe loadUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }
}

