/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.instrument.ASTPrinter;
import com.oracle.truffle.api.instrument.Visualizer;
import com.oracle.truffle.api.instrument.impl.DefaultASTPrinter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;

public class DefaultVisualizer
implements Visualizer {
    private final ASTPrinter astPrinter = new DefaultASTPrinter();

    @Override
    public ASTPrinter getASTPrinter() {
        return this.astPrinter;
    }

    @Override
    public String displaySourceLocation(Node node) {
        if (node == null) {
            return "<unknown>";
        }
        SourceSection section = node.getSourceSection();
        boolean estimated = false;
        if (section == null) {
            section = node.getEncapsulatingSourceSection();
            estimated = true;
        }
        return String.valueOf(section.getShortDescription()) + (estimated ? "~" : "");
    }

    @Override
    public String displayMethodName(Node node) {
        if (node == null) {
            return null;
        }
        RootNode root = node.getRootNode();
        if (root == null) {
            return "unknown";
        }
        return root.getCallTarget().toString();
    }

    @Override
    public String displayCallTargetName(CallTarget callTarget) {
        return callTarget.toString();
    }

    @Override
    public String displayValue(ExecutionContext context, Object value2) {
        return value2.toString();
    }

    @Override
    public String displayIdentifier(FrameSlot slot) {
        return slot.getIdentifier().toString();
    }
}

