/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.impl.DefaultVirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

public class DefaultCallTarget
implements RootCallTarget {
    private final RootNode rootNode;

    public DefaultCallTarget(RootNode function) {
        this.rootNode = function;
        this.rootNode.adoptChildren();
        this.rootNode.applyInstrumentation();
        this.rootNode.setCallTarget(this);
    }

    public String toString() {
        return this.rootNode.toString();
    }

    @Override
    public final RootNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Object call(Object ... args2) {
        final DefaultVirtualFrame frame = new DefaultVirtualFrame(this.getRootNode().getFrameDescriptor(), args2);
        FrameInstance oldCurrentFrame = DefaultCallTarget.defaultTruffleRuntime().setCurrentFrame(new FrameInstance(){

            @Override
            public Frame getFrame(FrameInstance.FrameAccess access, boolean slowPath) {
                return frame;
            }

            @Override
            public boolean isVirtualFrame() {
                return false;
            }

            @Override
            public Node getCallNode() {
                return null;
            }

            @Override
            public CallTarget getCallTarget() {
                return DefaultCallTarget.this;
            }
        });
        try {
            Object object = this.getRootNode().execute(frame);
            return object;
        }
        finally {
            DefaultCallTarget.defaultTruffleRuntime().setCurrentFrame(oldCurrentFrame);
        }
    }

    private static DefaultTruffleRuntime defaultTruffleRuntime() {
        return (DefaultTruffleRuntime)Truffle.getRuntime();
    }
}

