/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MathLinker {
    private static final Logger LOG = LoggerFactory.getLogger("MathLinker");

    public static CallSite fixnumOperatorBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, long value2, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        String[] names2 = name2.split(":");
        String operator = JavaNameMangler.demangleMethodName(names2[1]);
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CallType.NORMAL, file2, line, operator, false, false, true);
        MethodHandle target = lookup.findStatic(MathLinker.class, "fixnumOperator", MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Long.TYPE));
        target = MethodHandles.insertArguments(target, 3, site, value2);
        site.setTarget(target);
        return site;
    }

    public static CallSite fixnumBooleanBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, long value2, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        String[] names2 = name2.split(":");
        String operator = JavaNameMangler.demangleMethodName(names2[1]);
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CallType.NORMAL, file2, line, operator, false, false, true);
        MethodHandle target = lookup.findStatic(MathLinker.class, "fixnumBoolean", MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Long.TYPE));
        target = MethodHandles.insertArguments(target, 3, site, value2);
        site.setTarget(target);
        return site;
    }

    public static CallSite floatOperatorBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, double value2, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        String[] names2 = name2.split(":");
        String operator = JavaNameMangler.demangleMethodName(names2[1]);
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CallType.NORMAL, file2, line, operator, false, false, true);
        MethodHandle target = lookup.findStatic(MathLinker.class, "floatOperator", MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Double.TYPE));
        target = MethodHandles.insertArguments(target, 3, site, value2);
        site.setTarget(target);
        return site;
    }

    public static IRubyObject fixnumOperator(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, long value2) throws Throwable {
        String operator = site.name();
        String opMethod = MethodIndex.getFastFixnumOpsMethod(operator);
        String name2 = "fixnum_" + opMethod;
        MethodType type2 = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        MethodHandle target = null;
        if (operator.equals("+") || operator.equals("-")) {
            if (value2 == 1L) {
                name2 = name2 + "_one";
                target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
            } else if (value2 == 2L) {
                name2 = name2 + "_two";
                target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
            }
        }
        if (target == null) {
            type2 = type2.insertParameterTypes(3, Long.TYPE);
            target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
            target = MethodHandles.insertArguments(target, 3, value2);
        }
        MethodHandle fallback = MethodHandles.lookup().findStatic(MathLinker.class, "fixnumOperatorFail", MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, RubyFixnum.class));
        fallback = MethodHandles.insertArguments(fallback, 3, site, context.runtime.newFixnum(value2));
        MethodHandle test2 = MethodHandles.lookup().findStatic(MathLinker.class, "fixnumTest", MethodType.methodType(Boolean.TYPE, IRubyObject.class));
        test2 = MethodHandles.permuteArguments(test2, MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class), 2);
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(name2 + "\tFixnum operation at site #" + site.siteID() + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
        }
        target = MethodHandles.guardWithTest(test2, target, fallback);
        target = ((SwitchPoint)context.runtime.getFixnumInvalidator().getData()).guardWithTest(target, fallback);
        site.setTarget(target);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self2);
    }

    public static boolean fixnumBoolean(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, long value2) throws Throwable {
        String operator = site.name();
        String opMethod = MethodIndex.getFastFixnumOpsMethod(operator);
        String name2 = "fixnum_boolean_" + opMethod;
        MethodType type2 = MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        MethodHandle target = null;
        if (target == null) {
            type2 = type2.insertParameterTypes(3, Long.TYPE);
            target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
            target = MethodHandles.insertArguments(target, 3, value2);
        }
        MethodHandle fallback = MethodHandles.lookup().findStatic(MathLinker.class, "fixnumBooleanFail", MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, RubyFixnum.class));
        fallback = MethodHandles.insertArguments(fallback, 3, site, context.runtime.newFixnum(value2));
        MethodHandle test2 = MethodHandles.lookup().findStatic(MathLinker.class, "fixnumTest", MethodType.methodType(Boolean.TYPE, IRubyObject.class));
        test2 = MethodHandles.permuteArguments(test2, MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class), 2);
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(name2 + "\tFixnum boolean operation at site #" + site.siteID() + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
        }
        target = MethodHandles.guardWithTest(test2, target, fallback);
        target = ((SwitchPoint)context.runtime.getFixnumInvalidator().getData()).guardWithTest(target, fallback);
        site.setTarget(target);
        return (Boolean)target.invokeWithArguments(context, caller2, self2);
    }

    public static boolean fixnumTest(IRubyObject self2) {
        return self2 instanceof RubyFixnum;
    }

    public static IRubyObject fixnumOperatorFail(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyFixnum value2) throws Throwable {
        String operator = site.name();
        CacheEntry entry = site.entry;
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, operator, value2);
        }
        entry = selfClass.searchWithCache(operator);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), operator, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, operator, value2);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, operator, value2);
    }

    public static boolean fixnumBooleanFail(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyFixnum value2) throws Throwable {
        return MathLinker.fixnumOperatorFail(context, caller2, self2, site, value2).isTrue();
    }

    public static IRubyObject fixnum_op_plus(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_plus(context, value2);
    }

    public static IRubyObject fixnum_op_minus(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_minus(context, value2);
    }

    public static IRubyObject fixnum_op_mul(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_mul(context, value2);
    }

    public static IRubyObject fixnum_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_equal(context, value2);
    }

    public static IRubyObject fixnum_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lt(context, value2);
    }

    public static IRubyObject fixnum_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_le(context, value2);
    }

    public static IRubyObject fixnum_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_gt(context, value2);
    }

    public static IRubyObject fixnum_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_ge(context, value2);
    }

    public static boolean fixnum_boolean_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_equal_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lt_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_le_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_gt_boolean(context, value2);
    }

    public static boolean fixnum_boolean_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_ge_boolean(context, value2);
    }

    public static IRubyObject fixnum_op_cmp(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_cmp(context, value2);
    }

    public static IRubyObject fixnum_op_and(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_and(context, value2);
    }

    public static IRubyObject fixnum_op_or(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_or(context, value2);
    }

    public static IRubyObject fixnum_op_xor(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_xor(context, value2);
    }

    public static IRubyObject fixnum_op_rshift(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_rshift(value2);
    }

    public static IRubyObject fixnum_op_lshift(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lshift(value2);
    }

    public static IRubyObject fixnum_op_plus_one(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_plus_one(context);
    }

    public static IRubyObject fixnum_op_minus_one(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_minus_one(context);
    }

    public static IRubyObject fixnum_op_plus_two(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_plus_two(context);
    }

    public static IRubyObject fixnum_op_minus_two(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_minus_two(context);
    }

    public static IRubyObject floatOperator(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, double value2) throws Throwable {
        String operator = site.name();
        String opMethod = MethodIndex.getFastFloatOpsMethod(operator);
        String name2 = "float_" + opMethod;
        MethodType type2 = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        MethodHandle target = null;
        if (target == null) {
            type2 = type2.insertParameterTypes(3, Double.TYPE);
            target = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
            target = MethodHandles.insertArguments(target, 3, value2);
        }
        MethodHandle fallback = MethodHandles.lookup().findStatic(MathLinker.class, "floatOperatorFail", MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, RubyFloat.class));
        fallback = MethodHandles.insertArguments(fallback, 3, site, context.runtime.newFloat(value2));
        MethodHandle test2 = MethodHandles.lookup().findStatic(MathLinker.class, "floatTest", MethodType.methodType(Boolean.TYPE, IRubyObject.class));
        test2 = MethodHandles.permuteArguments(test2, MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class), 2);
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(name2 + "\tFloat operation at site #" + site.siteID() + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
        }
        site.setTarget(MethodHandles.guardWithTest(test2, target, fallback));
        target = MethodHandles.guardWithTest(test2, target, fallback);
        target = ((SwitchPoint)context.runtime.getFloatInvalidator().getData()).guardWithTest(target, fallback);
        site.setTarget(target);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self2);
    }

    public static boolean floatTest(IRubyObject self2) {
        return self2 instanceof RubyFloat;
    }

    public static IRubyObject floatOperatorFail(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyFloat value2) throws Throwable {
        String operator = site.name();
        CacheEntry entry = site.entry;
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, operator, value2);
        }
        entry = selfClass.searchWithCache(operator);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), operator, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, operator, value2);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, operator, value2);
    }

    public static IRubyObject float_op_plus(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_plus(context, value2);
    }

    public static IRubyObject float_op_minus(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_minus(context, value2);
    }

    public static IRubyObject float_op_mul(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_mul(context, value2);
    }

    public static IRubyObject float_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_equal(context, value2);
    }

    public static IRubyObject float_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_lt(context, value2);
    }

    public static IRubyObject float_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_le(context, value2);
    }

    public static IRubyObject float_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_gt(context, value2);
    }

    public static IRubyObject float_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_ge(context, value2);
    }

    public static IRubyObject float_op_cmp(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_cmp(context, value2);
    }
}

