/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ByteList;

public class TypeConverter {
    @Deprecated
    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod, boolean raise2) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise2, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        if (!obj.respondsTo(convertMethod)) {
            return TypeConverter.handleUncoercibleObject(raise2, obj, target);
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethod);
    }

    public static final IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod, boolean raise2) {
        IRubyObject r = obj.checkCallMethod(obj.getRuntime().getCurrentContext(), convertMethod);
        return r == null ? TypeConverter.handleUncoercibleObject(raise2, obj, target) : r;
    }

    @Deprecated
    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToType19(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(obj, target, convertMethod, true);
        if (!target.isInstance(val)) {
            String cname = obj.getMetaClass().toString();
            throw obj.getRuntime().newTypeError("can't convert " + cname + " to " + target.getName() + " (" + cname + "#" + convertMethod + " gives " + val.getMetaClass() + ")");
        }
        return val;
    }

    public static RubyNumeric toFloat(Ruby runtime, IRubyObject obj) {
        RubyClass floatClass = runtime.getFloat();
        if (floatClass.isInstance(obj)) {
            return (RubyNumeric)obj;
        }
        if (!runtime.getNumeric().isInstance(obj)) {
            throw runtime.newTypeError(obj, "Float");
        }
        return (RubyNumeric)TypeConverter.convertToType19(obj, floatClass, "to_f", true);
    }

    public static final IRubyObject checkData(IRubyObject obj) {
        if (obj instanceof DataType) {
            return obj;
        }
        throw obj.getRuntime().newTypeError("wrong argument type " + TypeConverter.typeAsString(obj) + " (expected Data)");
    }

    private static String typeAsString(IRubyObject obj) {
        if (obj.isNil()) {
            return "nil";
        }
        if (obj instanceof RubyBoolean) {
            return obj.isTrue() ? "true" : "false";
        }
        return obj.getMetaClass().getRealClass().getName();
    }

    public static String convertToIdentifier(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return new String(ByteList.plain(((RubyString)obj).getByteList()), RubyEncoding.ISO).intern();
        }
        return obj.asJavaString().intern();
    }

    @Deprecated
    public static final IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToTypeWithCheck19(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType19(obj, target, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToTypeOrRaise(IRubyObject obj, RubyClass target, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethod, true);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static IRubyObject checkIntegerType(Ruby runtime, IRubyObject obj, String method2) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        IRubyObject conv2 = TypeConverter.convertToType(obj, runtime.getInteger(), method2, false);
        return conv2 instanceof RubyInteger ? conv2 : runtime.getNil();
    }

    public static IRubyObject checkFloatType(Ruby runtime, IRubyObject obj) {
        if (obj instanceof RubyFloat) {
            return obj;
        }
        if (!(obj instanceof RubyNumeric)) {
            return runtime.getNil();
        }
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getFloat(), "to_f");
    }

    public static IRubyObject checkHashType(Ruby runtime, IRubyObject obj) {
        return TypeConverter.convertToTypeWithCheck(obj, runtime.getHash(), "to_hash");
    }

    public static IRubyObject handleUncoercibleObject(boolean raise2, IRubyObject obj, RubyClass target) throws RaiseException {
        if (raise2) {
            throw obj.getRuntime().newTypeError("can't convert " + TypeConverter.typeAsString(obj) + " into " + target);
        }
        return obj.getRuntime().getNil();
    }
}

