/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyRegexp;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Match2Instr
extends Instr
implements ResultInstr {
    private Variable result;
    private Operand receiver;
    private Operand arg;

    public Match2Instr(Variable result2, Operand receiver2, Operand arg2) {
        super(Operation.MATCH2);
        assert (result2 != null) : "Match2Instr result is null";
        this.result = result2;
        this.receiver = receiver2;
        this.arg = arg2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.receiver, this.arg};
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.receiver + ", " + this.arg + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.receiver = this.receiver.getSimplifiedOperand(valueMap, force);
        this.arg = this.arg.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new Match2Instr((Variable)this.result.cloneForInlining(ii), this.receiver.cloneForInlining(ii), this.arg.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        RubyRegexp regexp2 = (RubyRegexp)this.receiver.retrieve(context, self, currDynScope, temp);
        IRubyObject argValue = (IRubyObject)this.arg.retrieve(context, self, currDynScope, temp);
        return context.runtime.is1_9() ? regexp2.op_match19(context, argValue) : regexp2.op_match(context, argValue);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Match2Instr(this);
    }
}

