/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"Enumerable"})
public class RubyEnumerable {
    public static RubyModule createEnumerableModule(Ruby runtime) {
        RubyModule enumModule = runtime.defineModule("Enumerable");
        runtime.setEnumerable(enumModule);
        enumModule.defineAnnotatedMethods(RubyEnumerable.class);
        return enumModule;
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock.newCallClosure(self, runtime.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime, ThreadContext context, IRubyObject self, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock19.newCallClosure(self, runtime.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    @Deprecated
    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject[] args2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self, Arity arity2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock.newCallClosure(self, runtime.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime, ThreadContext context, IRubyObject self, Arity arity2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock19.newCallClosure(self, runtime.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject each(ThreadContext context, IRubyObject self, BlockBody body) {
        Block block = new Block(body, context.currentBinding(self, Visibility.PUBLIC));
        return RuntimeHelpers.invoke(context, self, "each", block);
    }

    @Deprecated
    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject[] args2, Arity arity2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime.getEnumerable(), arity2, callback, context));
    }

    private static void checkContext(ThreadContext firstContext, ThreadContext secondContext, String name2) {
        if (firstContext != secondContext) {
            throw secondContext.runtime.newThreadError("Enumerable#" + name2 + " cannot be parallelized");
        }
    }

    public static IRubyObject checkArgs(Ruby runtime, IRubyObject[] largs) {
        return largs.length == 0 ? runtime.getNil() : largs[0];
    }

    @JRubyMethod
    public static IRubyObject count(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final int[] result2 = new int[]{0};
        if (block.isGiven()) {
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, "Enumerable#count", block.arity()){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    if (block.yield(context, arg2).isTrue()) {
                        result2[0] = result2[0] + 1;
                    }
                    return runtime.getNil();
                }
            });
        } else {
            if (self.respondsTo("size")) {
                return self.callMethod(context, "size");
            }
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, "Enumerable#count", Arity.NO_ARGUMENTS){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject unusedValue) {
                    result2[0] = result2[0] + 1;
                    return runtime.getNil();
                }
            });
        }
        return RubyFixnum.newFixnum(runtime, result2[0]);
    }

    @JRubyMethod
    public static IRubyObject count(ThreadContext context, IRubyObject self, final IRubyObject methodArg, Block block) {
        final Ruby runtime = context.runtime;
        final int[] result2 = new int[]{0};
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, "Enumerable#count", Arity.ONE_REQUIRED){

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject blockArg) {
                if (blockArg.equals(methodArg)) {
                    result2[0] = result2[0] + 1;
                }
                return runtime.getNil();
            }
        });
        return RubyFixnum.newFixnum(runtime, result2[0]);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self, "cycle");
        }
        return RubyEnumerable.cycleCommon(context, self, -1L, block);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return RubyEnumerable.cycle(context, self, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self, "cycle", arg2);
        }
        long times2 = RubyNumeric.num2long(arg2);
        if (times2 <= 0L) {
            return context.runtime.getNil();
        }
        return RubyEnumerable.cycleCommon(context, self, times2, block);
    }

    private static IRubyObject cycleCommon(ThreadContext context, IRubyObject self, long nv, final Block block) {
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        RubyEnumerable.each(context, self, new JavaInternalBlockBody(block.arity()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                RubyArray rubyArray = result2;
                synchronized (rubyArray) {
                    result2.append(arg2);
                }
                block.yield(context, arg2);
                return runtime.getNil();
            }
        });
        int length2 = result2.size();
        if (length2 == 0) {
            return runtime.getNil();
        }
        while (nv < 0L || 0L < --nv) {
            for (int i2 = 0; i2 < length2; ++i2) {
                block.yield(context, result2.eltInternal(i2));
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"take"})
    public static IRubyObject take(ThreadContext context, IRubyObject self, IRubyObject n, Block block) {
        final Ruby runtime = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime.newArgumentError("attempt to take negative size");
        }
        if (len == 0L) {
            return runtime.newEmptyArray();
        }
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(Arity.ONE_REQUIRED){
                long i;
                {
                    super(x0);
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(arg2);
                        if (--this.i == 0L) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump e) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public static IRubyObject take_while(ThreadContext context, IRubyObject self, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self, "take_while");
        }
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(block.arity()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    if (!block.yield(context, arg2).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(arg2);
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"drop"})
    public static IRubyObject drop(ThreadContext context, IRubyObject self, IRubyObject n, Block block) {
        final Ruby runtime = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime.newArgumentError("attempt to drop negative size");
        }
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(Arity.NO_ARGUMENTS){
                long i;
                {
                    super(x0);
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        if (this.i == 0L) {
                            result2.append(arg2.isImmediate() ? arg2 : arg2.dup());
                        } else {
                            --this.i;
                        }
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump e) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public static IRubyObject drop_while(ThreadContext context, IRubyObject self, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self, "drop_while");
        }
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, "Enumerable#drop_while", block.arity()){
                boolean memo;
                {
                    super(x0, x1, x2);
                    this.memo = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    if (!this.memo && !block.yield(context, arg2).isTrue()) {
                        this.memo = true;
                    }
                    if (this.memo) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(arg2);
                        }
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self) {
        final IRubyObject[] holder = new IRubyObject[]{context.runtime.getNil()};
        try {
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, null, Arity.ONE_REQUIRED){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    holder[0] = arg2;
                    throw JumpException.SPECIAL_JUMP;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return holder[0];
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self, final IRubyObject num) {
        int firstCount = RubyNumeric.fix2int(num);
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (firstCount < 0) {
            throw runtime.newArgumentError("negative index");
        }
        if (firstCount == 0) {
            return result2;
        }
        try {
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, null, Arity.ONE_REQUIRED){
                private int iter;
                {
                    super(x0, x1, x2);
                    this.iter = RubyNumeric.fix2int(num);
                }

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    result2.append(arg2);
                    if (this.iter-- == 1) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime, result2));
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime.getEnumerable(), Arity.OPTIONAL, new AppendBlockCallback(runtime, result2), context));
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime, result2));
        result2.infectBy(self);
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime.getEnumerable(), Arity.OPTIONAL, new AppendBlockCallback(runtime, result2), context));
        result2.infectBy(self);
        return result2;
    }

    @JRubyMethod
    public static IRubyObject sort(ThreadContext context, IRubyObject self, Block block) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime, result2));
        result2.sort_bang(context, block);
        return result2;
    }

    public static IRubyObject sort_byCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        if (self instanceof RubyArray) {
            RubyArray selfArray = (RubyArray)self;
            final IRubyObject[][] valuesAndCriteria = new IRubyObject[selfArray.size()][2];
            RubyEnumerable.each(context, self, new JavaInternalBlockBody(Arity.OPTIONAL){
                AtomicInteger i;
                {
                    super(x0);
                    this.i = new AtomicInteger(0);
                }

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    IRubyObject[] myVandC = valuesAndCriteria[this.i.getAndIncrement()];
                    myVandC[0] = arg2;
                    myVandC[1] = block.yield(context, arg2);
                    return runtime.getNil();
                }
            });
            Arrays.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

                @Override
                public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                    return RubyFixnum.fix2int(RuntimeHelpers.invokedynamic(localContext, o1[1], MethodNames.OP_CMP, o2[1]));
                }
            });
            IRubyObject[] dstArray = new IRubyObject[selfArray.size()];
            for (int i2 = 0; i2 < dstArray.length; ++i2) {
                dstArray[i2] = valuesAndCriteria[i2][0];
            }
            return runtime.newArrayNoCopy(dstArray);
        }
        final ArrayList valuesAndCriteria = new ArrayList();
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                IRubyObject[] myVandC = new IRubyObject[]{larg, block.yield(ctx, larg)};
                valuesAndCriteria.add(myVandC);
                return runtime.getNil();
            }
        });
        Collections.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

            @Override
            public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                return RubyFixnum.fix2int(RuntimeHelpers.invokedynamic(localContext, o1[1], MethodNames.OP_CMP, o2[1]));
            }
        });
        IRubyObject[] dstArray = new IRubyObject[valuesAndCriteria.size()];
        for (int i3 = 0; i3 < dstArray.length; ++i3) {
            dstArray[i3] = ((IRubyObject[])valuesAndCriteria.get(i3))[0];
        }
        return runtime.newArrayNoCopy(dstArray);
    }

    @JRubyMethod
    public static IRubyObject sort_by(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.sort_byCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "sort_by");
    }

    @JRubyMethod
    public static IRubyObject grep(ThreadContext context, IRubyObject self, final IRubyObject pattern, final Block block) {
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    ctx.setRubyFrameDelta(ctx.getRubyFrameDelta() + 2);
                    if (pattern.callMethod(ctx, "===", larg).isTrue()) {
                        IRubyObject value2 = block.yield(ctx, larg);
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(value2);
                        }
                    }
                    ctx.setRubyFrameDelta(ctx.getRubyFrameDelta() - 2);
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    if (pattern.callMethod(ctx, "===", larg).isTrue()) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(larg);
                        }
                    }
                    return runtime.getNil();
                }
            });
        }
        return result2;
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.detectCommon(context, self, null, block);
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self, IRubyObject ifnone, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        final ThreadContext localContext = context;
        try {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "detect/find");
                    if (block.yield(ctx, larg).isTrue()) {
                        result2[0] = larg;
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return result2[0];
        }
        return ifnone != null ? ifnone.callMethod(context, "call") : runtime.getNil();
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, null, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "detect");
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, ifnone, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self, "detect", ifnone);
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, null, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "find");
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, ifnone, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self, "find", ifnone);
    }

    @JRubyMethod
    public static IRubyObject find_index(ThreadContext context, IRubyObject self, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find_index(context, block);
        }
        return blockGiven ? RubyEnumerable.find_indexCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "find_index");
    }

    @JRubyMethod
    public static IRubyObject find_index(ThreadContext context, IRubyObject self, IRubyObject cond, Block block) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        if (self instanceof RubyArray) {
            return ((RubyArray)self).find_index(context, cond);
        }
        return RubyEnumerable.find_indexCommon(context, self, cond);
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final long[] result2 = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime, context, self, Arity.NO_ARGUMENTS, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    if (block.yield(ctx, larg).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2[0] = result2[0] + 1L;
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime, result2[0]);
        }
        return runtime.getNil();
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self, final IRubyObject cond) {
        final Ruby runtime = context.runtime;
        final long[] result2 = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    if (larg.equals(cond)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2[0] = result2[0] + 1L;
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime, result2[0]);
        }
        return runtime.getNil();
    }

    public static IRubyObject selectCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return runtime.getNil();
            }
        });
        return result2;
    }

    @JRubyMethod
    public static IRubyObject select(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.selectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "select");
    }

    @JRubyMethod
    public static IRubyObject find_all(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.selectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "find_all");
    }

    public static IRubyObject rejectCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                if (!block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return runtime.getNil();
            }
        });
        return result2;
    }

    @JRubyMethod
    public static IRubyObject reject(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.rejectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "reject");
    }

    @JRubyMethod(name={"collect", "map"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject collect(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    IRubyObject value2 = block.yield(ctx, larg);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(value2);
                    }
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime, result2));
        }
        return result2;
    }

    @JRubyMethod(name={"collect"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject collect19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.collectCommon19(context, self, block, "collect");
    }

    @JRubyMethod(name={"map"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject map19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.collectCommon19(context, self, block, "map");
    }

    private static IRubyObject collectCommon19(ThreadContext context, IRubyObject self, final Block block, String methodName) {
        final Ruby runtime = context.runtime;
        if (block.isGiven()) {
            final RubyArray result2 = runtime.newArray();
            RubyEnumerable.callEach19(runtime, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg;
                    boolean newAry = false;
                    if (largs.length == 0) {
                        larg = ctx.nil;
                    } else if (largs.length == 1) {
                        larg = largs[0];
                    } else {
                        newAry = true;
                        larg = RubyArray.newArrayNoCopy(ctx.runtime, largs);
                    }
                    IRubyObject value2 = newAry ? block.yieldArray(ctx, larg, null, null) : block.yield(ctx, larg);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(value2);
                    }
                    return runtime.getNil();
                }
            });
            return result2;
        }
        return RubyEnumerator.enumeratorize(runtime, self, methodName);
    }

    public static IRubyObject collectCommon(ThreadContext context, Ruby runtime, IRubyObject self, RubyArray result2, Block block, BlockCallback blockCallback) {
        RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, blockCallback);
        return result2;
    }

    @JRubyMethod(name={"flat_map"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject flat_map19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self, block, "flat_map");
    }

    @JRubyMethod(name={"collect_concat"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject collect_concat19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self, block, "collect_concat");
    }

    private static IRubyObject flatMapCommon19(ThreadContext context, IRubyObject self, final Block block, String methodName) {
        final Ruby runtime = context.runtime;
        if (block.isGiven()) {
            final RubyArray ary = runtime.newArray();
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    IRubyObject i2 = block.yield(ctx, larg);
                    IRubyObject tmp = i2.checkArrayType();
                    RubyArray rubyArray = ary;
                    synchronized (rubyArray) {
                        if (tmp.isNil()) {
                            ary.append(i2);
                        } else {
                            ary.concat(tmp);
                        }
                    }
                    return runtime.getNil();
                }
            });
            return ary;
        }
        return RubyEnumerator.enumeratorize(runtime, self, methodName);
    }

    public static IRubyObject injectCommon(ThreadContext context, IRubyObject self, IRubyObject init, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{init};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                RubyEnumerable.checkContext(localContext, ctx, "inject");
                result2[0] = result2[0] == null ? larg : block.yieldArray(ctx, runtime.newArray(result2[0], larg), null, null);
                return runtime.getNil();
            }
        });
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.injectCommon(context, self, null, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.injectCommon(context, self, arg2, block) : RubyEnumerable.inject(context, self, null, arg2, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self, IRubyObject init, IRubyObject method2, Block block) {
        final Ruby runtime = context.runtime;
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        final String methodId = method2.asJavaString();
        final IRubyObject[] result2 = new IRubyObject[]{init};
        RubyEnumerable.callEach(runtime, context, self, Arity.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                result2[0] = result2[0] == null ? larg : result2[0].callMethod(ctx, methodId, larg);
                return runtime.getNil();
            }
        });
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    public static IRubyObject partitionCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final RubyArray arr_true = runtime.newArray();
        final RubyArray arr_false = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = arr_true;
                    synchronized (rubyArray) {
                        arr_true.append(larg);
                    }
                }
                RubyArray rubyArray = arr_false;
                synchronized (rubyArray) {
                    arr_false.append(larg);
                }
                return runtime.getNil();
            }
        });
        return runtime.newArray((IRubyObject)arr_true, (IRubyObject)arr_false);
    }

    @JRubyMethod(name={"partition"})
    public static IRubyObject partition(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.partitionCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "partition");
    }

    public static IRubyObject each_with_indexCommon(ThreadContext context, IRubyObject self, Block block) {
        RubyEnumerable.callEach(context.runtime, context, self, Arity.TWO_ARGUMENTS, (BlockCallback)new EachWithIndex(context, block));
        return self;
    }

    public static IRubyObject each_with_indexCommon19(ThreadContext context, IRubyObject self, Block block, IRubyObject[] args2) {
        RubyEnumerable.callEach(context.runtime, context, self, args2, Arity.TWO_ARGUMENTS, new EachWithIndex(context, block));
        return self;
    }

    public static IRubyObject each_with_objectCommon19(ThreadContext context, IRubyObject self, Block block, IRubyObject arg2) {
        RubyEnumerable.callEach(context.runtime, context, self, Arity.TWO_ARGUMENTS, (BlockCallback)new EachWithObject(context, block, arg2));
        return self;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "each_with_index");
    }

    @JRubyMethod(name={"each_with_index"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_with_index19(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon19(context, self, block, args2) : RubyEnumerator.enumeratorize(context.runtime, self, "each_with_index", args2);
    }

    @JRubyMethod
    public static IRubyObject enum_with_index(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self, block) : RubyEnumerator.enumeratorize(context.runtime, self, "enum_with_index");
    }

    @JRubyMethod(name={"each_with_object"}, required=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_with(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon19(context, self, block, arg2) : RubyEnumerator.enumeratorize(context.runtime, self, "each_with_index", arg2);
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_entry(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, self, args2, block) : RubyEnumerator.enumeratorize(context.runtime, self, "each_entry", args2);
    }

    private static IRubyObject each_entryCommon(ThreadContext context, IRubyObject self, IRubyObject[] args2, final Block block) {
        RubyEnumerable.callEach(context.runtime, context, self, args2, block.arity(), new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.yieldSpecific(ctx, RubyEnumerable.checkArgs(ctx.runtime, largs));
            }
        });
        return self;
    }

    @JRubyMethod
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self, RubyEnumerable.to_a(context, self), block) : RubyEnumerator.enumeratorize(context.runtime, self, "reverse_each");
    }

    @JRubyMethod(rest=true)
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self, RubyEnumerable.to_a(context, self, args2), block) : RubyEnumerator.enumeratorize(context.runtime, self, "reverse_each", args2);
    }

    private static IRubyObject reverse_eachInternal(ThreadContext context, IRubyObject self, IRubyObject obj, Block block) {
        ((RubyArray)obj).reverse_each(context, block);
        return self;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1)
    public static IRubyObject include_p(ThreadContext context, IRubyObject self, final IRubyObject arg2) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        try {
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "include?/member?");
                    if (RubyObject.equalInternal(ctx, larg, arg2)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod
    public static IRubyObject max(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        final ThreadContext localContext = context;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "max{}");
                    if (result2[0] == null || RubyComparable.cmpint(ctx, block.yieldArray(ctx, runtime.newArray(larg, result2[0]), null, null), larg, result2[0]) > 0) {
                        result2[0] = larg;
                    }
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    IRubyObject[] iRubyObjectArray = result2;
                    synchronized (result2) {
                        if (result2[0] == null || RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, larg, MethodNames.OP_CMP, result2[0]), larg, result2[0]) > 0) {
                            result2[0] = larg;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return runtime.getNil();
                    }
                }
            });
        }
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod
    public static IRubyObject max_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self, "max_by");
        }
        final IRubyObject[] result2 = new IRubyObject[]{runtime.getNil()};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){
            IRubyObject memo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                RubyEnumerable.checkContext(localContext, ctx, "max_by");
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.memo), v, this.memo) > 0) {
                    this.memo = v;
                    result2[0] = larg;
                }
                return runtime.getNil();
            }
        });
        return result2[0];
    }

    @JRubyMethod
    public static IRubyObject min(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        final ThreadContext localContext = context;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "min{}");
                    if (result2[0] == null || RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(larg, result2[0])), larg, result2[0]) < 0) {
                        result2[0] = larg;
                    }
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    IRubyObject[] iRubyObjectArray = result2;
                    synchronized (result2) {
                        if (result2[0] == null || RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, larg, MethodNames.OP_CMP, result2[0]), larg, result2[0]) < 0) {
                            result2[0] = larg;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return runtime.getNil();
                    }
                }
            });
        }
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod
    public static IRubyObject min_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self, "min_by");
        }
        final IRubyObject[] result2 = new IRubyObject[]{runtime.getNil()};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){
            IRubyObject memo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                RubyEnumerable.checkContext(localContext, ctx, "min_by");
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.memo), v, this.memo) < 0) {
                    this.memo = v;
                    result2[0] = larg;
                }
                return runtime.getNil();
            }
        });
        return result2[0];
    }

    @JRubyMethod
    public static IRubyObject minmax(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null, null};
        final ThreadContext localContext = context;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    RubyEnumerable.checkContext(localContext, ctx, "minmax");
                    IRubyObject arg2 = RubyEnumerable.checkArgs(runtime, largs);
                    if (result2[0] == null) {
                        result2[0] = result2[1] = arg2;
                    } else {
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(arg2, result2[0])), arg2, result2[0]) < 0) {
                            result2[0] = arg2;
                        }
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(arg2, result2[1])), arg2, result2[1]) > 0) {
                            result2[1] = arg2;
                        }
                    }
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject arg2 = RubyEnumerable.checkArgs(runtime, largs);
                    IRubyObject[] iRubyObjectArray = result2;
                    synchronized (result2) {
                        if (result2[0] == null) {
                            result2[0] = result2[1] = arg2;
                        } else {
                            if (RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, result2[0]), arg2, result2[0]) < 0) {
                                result2[0] = arg2;
                            }
                            if (RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, result2[1]), arg2, result2[1]) > 0) {
                                result2[1] = arg2;
                            }
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return runtime.getNil();
                    }
                }
            });
        }
        if (result2[0] == null) {
            result2[0] = result2[1] = runtime.getNil();
        }
        return runtime.newArrayNoCopy(result2);
    }

    @JRubyMethod
    public static IRubyObject minmax_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self, "minmax_by");
        }
        final IRubyObject[] result2 = new IRubyObject[]{runtime.getNil(), runtime.getNil()};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){
            IRubyObject minMemo = null;
            IRubyObject maxMemo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                RubyEnumerable.checkContext(localContext, ctx, "minmax_by");
                IRubyObject arg2 = RubyEnumerable.checkArgs(runtime, largs);
                IRubyObject v = block.yield(ctx, arg2);
                if (this.minMemo == null) {
                    this.minMemo = this.maxMemo = v;
                    result2[0] = result2[1] = arg2;
                } else {
                    if (RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.minMemo), v, this.minMemo) < 0) {
                        this.minMemo = v;
                        result2[0] = arg2;
                    }
                    if (RubyComparable.cmpint(ctx, RuntimeHelpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.maxMemo), v, this.maxMemo) > 0) {
                        this.maxMemo = v;
                        result2[1] = arg2;
                    }
                }
                return runtime.getNil();
            }
        });
        return runtime.newArrayNoCopy(result2);
    }

    @JRubyMethod(name={"none?"})
    public static IRubyObject none_p(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"one?"})
    public static IRubyObject one_p(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        final boolean[] result2 = new boolean[]{false};
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                        if (larg.isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return result2[0] ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"all?"})
    public static IRubyObject all_p(ThreadContext context, IRubyObject self, Block block) {
        if (self instanceof RubyArray) {
            return ((RubyArray)self).all_p(context, block);
        }
        return RubyEnumerable.all_pCommon(context, self, block);
    }

    public static IRubyObject all_pCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        final ThreadContext localContext = context;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                        if (!block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                        if (!larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"any?"})
    public static IRubyObject any_p(ThreadContext context, IRubyObject self, Block block) {
        if (self instanceof RubyArray) {
            return ((RubyArray)self).any_p(context, block);
        }
        return RubyEnumerable.any_pCommon(context, self, block);
    }

    public static IRubyObject any_pCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        try {
            if (block.isGiven()) {
                RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, "Enumerable#any?", block.arity()){

                    @Override
                    public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                        if (block.yield(context, arg2).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.each(context, self, new JavaInternalBlockBody(context, "Enumerable#any?", Arity.ONE_REQUIRED){

                    @Override
                    public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                        if (arg2.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject zip(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon(context, self, args2, block);
    }

    @JRubyMethod(name={"zip"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject zip19(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon19(context, self, args2, block);
    }

    public static IRubyObject[] zipCommonConvert(Ruby runtime, IRubyObject[] args2) {
        return RubyEnumerable.zipCommonConvert(runtime, args2, "to_a");
    }

    public static IRubyObject[] zipCommonConvert(Ruby runtime, IRubyObject[] args2, String method2) {
        RubyClass array = runtime.getArray();
        ThreadContext context = runtime.getCurrentContext();
        if (runtime.is1_9()) {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                IRubyObject result2 = TypeConverter.convertToTypeWithCheck19(args2[i2], array, method2);
                if (result2.isNil()) {
                    result2 = RubyEnumerable.takeItems(context, args2[i2]);
                }
                args2[i2] = result2;
            }
        } else {
            for (int i3 = 0; i3 < args2.length; ++i3) {
                args2[i3] = TypeConverter.convertToType(args2[i3], array, method2);
            }
        }
        return args2;
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self, IRubyObject[] aArgs, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject[] args2 = RubyEnumerable.zipCommonConvert(runtime, aArgs);
        return RubyEnumerable.zipCommonAry(context, self, args2, block);
    }

    public static IRubyObject zipCommon19(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        int aLen = args2.length + 1;
        RubyClass array = runtime.getArray();
        IRubyObject[] newArgs = new IRubyObject[args2.length];
        boolean hasUncoercible = false;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = TypeConverter.convertToType(args2[i2], array, "to_ary", false);
            if (!newArgs[i2].isNil()) continue;
            hasUncoercible = true;
        }
        if (hasUncoercible) {
            RubySymbol each2 = runtime.newSymbol("each");
            for (int i3 = 0; i3 < args2.length; ++i3) {
                newArgs[i3] = args2[i3].callMethod(context, "to_enum", each2);
            }
        }
        if (hasUncoercible) {
            return RubyEnumerable.zipCommonEnum(context, self, newArgs, block);
        }
        return RubyEnumerable.zipCommonAry(context, self, newArgs, block);
    }

    public static IRubyObject zipCommonAry(ThreadContext context, IRubyObject self, final IRubyObject[] args2, final Block block) {
        final Ruby runtime = context.runtime;
        final int len = args2.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    RubyArray array = runtime.newArray(len);
                    int myIx = this.ix.getAndIncrement();
                    array.append(larg);
                    int j = args2.length;
                    for (int i2 = 0; i2 < j; ++i2) {
                        array.append(((RubyArray)args2[i2]).entry(myIx));
                    }
                    block.yield(ctx, array);
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }
        final RubyArray zip2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                RubyArray array = runtime.newArray(len);
                array.append(larg);
                int myIx = this.ix.getAndIncrement();
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    array.append(((RubyArray)args2[i2]).entry(myIx));
                }
                RubyArray rubyArray = zip2;
                synchronized (rubyArray) {
                    zip2.append(array);
                }
                return runtime.getNil();
            }
        });
        return zip2;
    }

    public static IRubyObject zipCommonEnum(ThreadContext context, IRubyObject self, final IRubyObject[] args2, final Block block) {
        final Ruby runtime = context.runtime;
        final int len = args2.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                    RubyArray array = runtime.newArray(len);
                    int myIx = this.ix.getAndIncrement();
                    array.append(larg);
                    int j = args2.length;
                    for (int i2 = 0; i2 < j; ++i2) {
                        array.append(RubyEnumerable.zipEnumNext(ctx, args2[i2]));
                    }
                    block.yield(ctx, array);
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }
        final RubyArray zip2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, Arity.ONE_REQUIRED, new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                RubyArray array = runtime.newArray(len);
                array.append(larg);
                int myIx = this.ix.getAndIncrement();
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    array.append(RubyEnumerable.zipEnumNext(ctx, args2[i2]));
                }
                RubyArray rubyArray = zip2;
                synchronized (rubyArray) {
                    zip2.append(array);
                }
                return runtime.getNil();
            }
        });
        return zip2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject takeItems(ThreadContext context, IRubyObject enumerable) {
        RubyArray array;
        RubyArray rubyArray = array = context.runtime.newArray();
        synchronized (rubyArray) {
            RubyEnumerable.callEach(context.runtime, context, enumerable, Arity.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(ctx.runtime, largs);
                    array.append(larg);
                    return larg;
                }
            });
        }
        return array;
    }

    private static IRubyObject zipEnumNext(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2.isNil()) {
            return context.nil;
        }
        try {
            return arg2.callMethod(context, "next");
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == runtime.getStopIteration()) {
                return context.nil;
            }
            throw re;
        }
    }

    @JRubyMethod
    public static IRubyObject group_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self, "group_by");
        }
        final RubyHash result2 = new RubyHash(runtime);
        RubyEnumerable.callEach(runtime, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime, largs);
                IRubyObject key2 = block.yield(ctx, larg);
                RubyHash rubyHash = result2;
                synchronized (rubyHash) {
                    RubyArray curr = (RubyArray)result2.fastARef(key2);
                    if (curr == null) {
                        curr = runtime.newArray();
                        result2.fastASet(key2, curr);
                    }
                    curr.append(larg);
                }
                return runtime.getNil();
            }
        });
        return result2;
    }

    @Deprecated
    public static IRubyObject chunk(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        switch (Arity.checkArgumentCount(context.runtime, args2, 0, 1)) {
            case 0: {
                return RubyEnumerable.chunk(context, self, block);
            }
            case 1: {
                return RubyEnumerable.chunk(context, self, args2[0], block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject chunk(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.chunk(context, self, context.nil, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject chunk(ThreadContext context, IRubyObject self, IRubyObject initialState, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("no block given");
        }
        IRubyObject enumerator = context.runtime.getEnumerator().allocate();
        enumerator.getInternalVariables().setInternalVariable("chunk_enumerable", self);
        enumerator.getInternalVariables().setInternalVariable("chunk_categorize", RubyProc.newProc(context.runtime, block, block.type));
        enumerator.getInternalVariables().setInternalVariable("chunk_initial_state", initialState);
        RuntimeHelpers.invoke(context, enumerator, "initialize", CallBlock.newCallClosure(self, context.runtime.getEnumerable(), Arity.ONE_ARGUMENT, new ChunkedBlockCallback(context.runtime, enumerator), context));
        return enumerator;
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private Ruby runtime;
        private RubyArray result;

        public AppendBlockCallback(Ruby runtime, RubyArray result2) {
            this.runtime = runtime;
            this.result = result2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            this.result.append(RubyEnumerable.checkArgs(this.runtime, largs));
            return this.runtime.getNil();
        }
    }

    public static final class ChunkedBlockCallback
    implements BlockCallback {
        private final Ruby runtime;
        private final IRubyObject enumerator;

        public ChunkedBlockCallback(Ruby runtime, IRubyObject enumerator) {
            this.runtime = runtime;
            this.enumerator = enumerator;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            IRubyObject args2 = RubyEnumerable.checkArgs(this.runtime, largs);
            final ChunkArg arg2 = new ChunkArg();
            IRubyObject enumerable = (IRubyObject)this.enumerator.getInternalVariables().getInternalVariable("chunk_enumerable");
            arg2.categorize = (IRubyObject)this.enumerator.getInternalVariables().getInternalVariable("chunk_categorize");
            arg2.state = (IRubyObject)this.enumerator.getInternalVariables().getInternalVariable("chunk_initial_state");
            arg2.prev_value = this.runtime.getNil();
            arg2.prev_elts = this.runtime.getNil();
            arg2.yielder = args2;
            if (!arg2.state.isNil()) {
                arg2.state = arg2.state.dup();
            }
            final RubySymbol alone = this.runtime.newSymbol("_alone");
            final RubySymbol separator = this.runtime.newSymbol("_separator");
            RubyEnumerable.callEach(this.runtime, context, enumerable, Arity.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject i2 = RubyEnumerable.checkArgs(ChunkedBlockCallback.this.runtime, largs);
                    IRubyObject v = arg2.state.isNil() ? arg2.categorize.callMethod(ctx, "call", i2) : arg2.categorize.callMethod(ctx, "call", new IRubyObject[]{i2, arg2.state});
                    if (v == alone) {
                        if (!arg2.prev_value.isNil()) {
                            arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ChunkedBlockCallback.this.runtime.getNil();
                        }
                        arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(v, (IRubyObject)ChunkedBlockCallback.this.runtime.newArray(i2)));
                    } else if (v.isNil() || v == separator) {
                        if (!arg2.prev_value.isNil()) {
                            arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ChunkedBlockCallback.this.runtime.getNil();
                        }
                    } else {
                        if (v instanceof RubySymbol && v.toString().charAt(0) == '_') {
                            throw ChunkedBlockCallback.this.runtime.newRuntimeError("symbol begins with an underscore is reserved");
                        }
                        if (arg2.prev_value.isNil()) {
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(i2);
                        } else if (arg2.prev_value.equals(v)) {
                            ((RubyArray)arg2.prev_elts).append(i2);
                        } else {
                            arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(i2);
                        }
                    }
                    return ChunkedBlockCallback.this.runtime.getNil();
                }
            });
            if (!arg2.prev_elts.isNil()) {
                arg2.yielder.callMethod(context, "<<", this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
            }
            return this.runtime.getNil();
        }
    }

    static class ChunkArg {
        public IRubyObject categorize;
        public IRubyObject state;
        public IRubyObject prev_value;
        public IRubyObject prev_elts;
        public IRubyObject yielder;

        ChunkArg() {
        }
    }

    private static class EachWithObject
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final IRubyObject arg;
        private final Ruby runtime;

        public EachWithObject(ThreadContext ctx, Block block, IRubyObject arg2) {
            this.block = block;
            this.arg = arg2;
            this.runtime = ctx.runtime;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            switch (iargs.length) {
                case 0: 
                case 1: {
                    this.block.call(context, RubyEnumerable.checkArgs(this.runtime, iargs), this.arg);
                    break;
                }
                case 2: {
                    this.block.call(context, (IRubyObject)this.runtime.newArrayNoCopy(iargs), this.arg);
                }
            }
            return this.runtime.getNil();
        }
    }

    private static class EachWithIndex
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final Ruby runtime;

        public EachWithIndex(ThreadContext ctx, Block block) {
            this.block = block;
            this.runtime = ctx.runtime;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            switch (iargs.length) {
                case 0: 
                case 1: {
                    this.block.call(context, RubyEnumerable.checkArgs(this.runtime, iargs), this.runtime.newFixnum(this.index++));
                    break;
                }
                case 2: {
                    this.block.call(context, (IRubyObject)this.runtime.newArrayNoCopy(iargs), this.runtime.newFixnum(this.index++));
                }
            }
            return this.runtime.getNil();
        }
    }
}

