/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.CompatVersion;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

@JRubyClass(name={"Struct"})
public class RubyStruct
extends RubyObject {
    private final IRubyObject[] values;
    private static ObjectAllocator STRUCT_INSTANCE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyStruct instance = new RubyStruct(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    private RubyStruct(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
        int size2 = RubyNumeric.fix2int(RubyStruct.getInternalVariable(rubyClass, "__size__"));
        this.values = new IRubyObject[size2];
        Helpers.fillNil(this.values, runtime);
    }

    public static RubyClass createStructClass(Ruby runtime) {
        RubyClass structClass = runtime.defineClass("Struct", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setStructClass(structClass);
        structClass.index = 15;
        structClass.includeModule(runtime.getEnumerable());
        structClass.defineAnnotatedMethods(RubyStruct.class);
        return structClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 15;
    }

    private static IRubyObject getInternalVariable(RubyClass type2, String internedName) {
        RubyClass structClass = type2.getRuntime().getStructClass();
        while (type2 != null && type2 != structClass) {
            IRubyObject variable = (IRubyObject)type2.getInternalVariable(internedName);
            if (variable != null) {
                return variable;
            }
            type2 = type2.getSuperClass();
        }
        return type2.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        this.testFrozen();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        int h = this.getMetaClass().getRealClass().hashCode();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            h = h << 1 | (h < 0 ? 1 : 0);
            h = (int)((long)h ^ RubyNumeric.num2long(Helpers.invokedynamic(context, this.values[i2], MethodNames.HASH)));
        }
        return context.runtime.newFixnum(h);
    }

    private IRubyObject setByName(String name2, IRubyObject value2) {
        RubyArray member = this.__member__();
        this.modify();
        int k = member.getLength();
        for (int i2 = 0; i2 < k; ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            this.values[i2] = value2;
            return this.values[i2];
        }
        throw this.notStructMemberError(name2);
    }

    private IRubyObject getByName(String name2) {
        RubyArray member = this.__member__();
        int k = member.getLength();
        for (int i2 = 0; i2 < k; ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            return this.values[i2];
        }
        throw this.notStructMemberError(name2);
    }

    @JRubyMethod(name={"new"}, required=1, rest=true, meta=true)
    public static RubyClass newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        int i2;
        RubyClass newStruct2;
        int i3;
        String name2 = null;
        boolean nilName = false;
        Ruby runtime = recv2.getRuntime();
        if (args2.length > 0) {
            IRubyObject firstArgAsString = args2[0].checkStringType();
            if (!firstArgAsString.isNil()) {
                name2 = ((RubyString)firstArgAsString).getByteList().toString();
            } else if (args2[0].isNil()) {
                nilName = true;
            }
        }
        RubyArray member = runtime.newArray();
        int n = i3 = name2 == null && !nilName ? 0 : 1;
        while (i3 < args2.length) {
            member.append(runtime.newSymbol(args2[i3].asJavaString()));
            ++i3;
        }
        RubyClass superClass = (RubyClass)recv2;
        if (name2 == null || nilName) {
            newStruct2 = RubyClass.newClass(runtime, superClass);
            newStruct2.setAllocator(STRUCT_INSTANCE_ALLOCATOR);
            newStruct2.makeMetaClass(superClass.getMetaClass());
            newStruct2.inherit(superClass);
        } else {
            if (!IdUtil.isConstant(name2)) {
                throw runtime.newNameError("identifier " + name2 + " needs to be constant", name2);
            }
            IRubyObject type2 = superClass.getConstantAt(name2);
            if (type2 != null) {
                ThreadContext context = runtime.getCurrentContext();
                runtime.getWarnings().warn(IRubyWarnings.ID.STRUCT_CONSTANT_REDEFINED, context.getFile(), context.getLine(), "redefining constant Struct::" + name2);
                superClass.remove_const(context, runtime.newString(name2));
            }
            newStruct2 = superClass.defineClassUnder(name2, superClass, STRUCT_INSTANCE_ALLOCATOR);
        }
        newStruct2.setReifiedClass(RubyStruct.class);
        newStruct2.index = 15;
        newStruct2.setInternalVariable("__size__", member.length());
        newStruct2.setInternalVariable("__member__", member);
        newStruct2.getSingletonClass().defineAnnotatedMethods(StructMethods.class);
        int n2 = i2 = name2 == null && !nilName ? 0 : 1;
        while (i2 < args2.length) {
            String memberName = args2[i2].asJavaString();
            final int index2 = name2 == null && !nilName ? i2 : i2 - 1;
            newStruct2.addMethod(memberName, new DynamicMethod((RubyModule)newStruct2, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    Arity.checkArgumentCount(context.runtime, name2, args2, 0, 0);
                    return ((RubyStruct)self2).get(index2);
                }

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                    return ((RubyStruct)self2).get(index2);
                }

                @Override
                public DynamicMethod dup() {
                    return this;
                }
            });
            newStruct2.addMethod(memberName + "=", new DynamicMethod((RubyModule)newStruct2, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    Arity.checkArgumentCount(context.runtime, name2, args2, 1, 1);
                    return ((RubyStruct)self2).set(args2[0], index2);
                }

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                    return ((RubyStruct)self2).set(arg2, index2);
                }

                @Override
                public DynamicMethod dup() {
                    return this;
                }
            });
            ++i2;
        }
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yieldNonArray(runtime.getCurrentContext(), null, newStruct2, newStruct2);
        }
        return newStruct2;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(args2, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, arg1, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, arg1, arg2, block);
        return struct;
    }

    private void checkSize(int length2) {
        if (length2 > this.values.length) {
            throw this.getRuntime().newArgumentError("struct size differs (" + length2 + " for " + this.values.length + ")");
        }
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.modify();
        this.checkSize(args2.length);
        System.arraycopy(args2, 0, this.values, 0, args2.length);
        Helpers.fillNil(this.values, args2.length, this.values.length, context.runtime);
        return context.nil;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 0, nil, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 1, arg0, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.initializeInternal(context, 2, arg0, arg1, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.initializeInternal(context, 3, arg0, arg1, arg2);
    }

    public IRubyObject initializeInternal(ThreadContext context, int provided, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modify();
        this.checkSize(provided);
        switch (provided) {
            case 3: {
                this.values[2] = arg2;
            }
            case 2: {
                this.values[1] = arg1;
            }
            case 1: {
                this.values[0] = arg0;
            }
        }
        if (provided < this.values.length) {
            Helpers.fillNil(this.values, provided, this.values.length, context.runtime);
        }
        return this.getRuntime().getNil();
    }

    public static RubyArray members(IRubyObject recv2, Block block) {
        RubyArray member = RubyStruct.__member__((RubyClass)recv2);
        RubyArray result2 = recv2.getRuntime().newArray(member.getLength());
        int k = member.getLength();
        for (int i2 = 0; i2 < k; ++i2) {
            result2.append(recv2.getRuntime().newString(member.eltInternal(i2).asJavaString()));
        }
        return result2;
    }

    public static RubyArray members19(IRubyObject recv2, Block block) {
        RubyArray member = RubyStruct.__member__((RubyClass)recv2);
        RubyArray result2 = recv2.getRuntime().newArray(member.getLength());
        int k = member.getLength();
        for (int i2 = 0; i2 < k; ++i2) {
            result2.append(member.eltInternal(i2));
        }
        return result2;
    }

    private static RubyArray __member__(RubyClass clazz) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(clazz, "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        return member;
    }

    private RubyArray __member__() {
        return RubyStruct.__member__(this.classOf());
    }

    @JRubyMethod(name={"members"}, compat=CompatVersion.RUBY1_8)
    public RubyArray members() {
        return RubyStruct.members(this.classOf(), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"members"}, compat=CompatVersion.RUBY1_9)
    public RubyArray members19() {
        return RubyStruct.members19(this.classOf(), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"select"}, compat=CompatVersion.RUBY1_8)
    public RubyArray select18(ThreadContext context, Block block) {
        return this.selectCommon(context, block);
    }

    @JRubyMethod(name={"select"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject select(ThreadContext context, Block block) {
        return block.isGiven() ? this.selectCommon(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "select");
    }

    public RubyArray selectCommon(ThreadContext context, Block block) {
        RubyArray array = RubyArray.newArray(context.runtime);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (!block.yield(context, this.values[i2]).isTrue()) continue;
            array.append(this.values[i2]);
        }
        return array;
    }

    public IRubyObject set(IRubyObject value2, int index2) {
        this.modify();
        this.values[index2] = value2;
        return this.values[index2];
    }

    private RaiseException notStructMemberError(String name2) {
        return this.getRuntime().newNameError("no member '" + name2 + "' in struct", name2);
    }

    public IRubyObject get(int index2) {
        return this.values[index2];
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
        RubyStruct struct = (RubyStruct)clone;
        System.arraycopy(this.values, 0, struct.values, 0, this.values.length);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(final ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass().getRealClass() != other.getMetaClass().getRealClass()) {
            return this.getRuntime().getFalse();
        }
        if (other == this) {
            return context.runtime.getTrue();
        }
        final Ruby runtime = context.runtime;
        final RubyStruct otherStruct = (RubyStruct)other;
        return runtime.execRecursiveOuter(new Ruby.RecursiveFunction(){

            @Override
            public IRubyObject call(IRubyObject obj, boolean recur) {
                if (recur) {
                    return runtime.getTrue();
                }
                for (int i2 = 0; i2 < RubyStruct.this.values.length; ++i2) {
                    if (RubyObject.equalInternal(context, RubyStruct.this.values[i2], otherStruct.values[i2])) continue;
                    return runtime.getFalse();
                }
                return runtime.getTrue();
            }
        }, this);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(final ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        if (other == this) {
            return context.runtime.getTrue();
        }
        final Ruby runtime = context.runtime;
        final RubyStruct otherStruct = (RubyStruct)other;
        return runtime.execRecursiveOuter(new Ruby.RecursiveFunction(){

            @Override
            public IRubyObject call(IRubyObject obj, boolean recur) {
                if (recur) {
                    return runtime.getTrue();
                }
                for (int i2 = 0; i2 < RubyStruct.this.values.length; ++i2) {
                    if (RubyObject.eqlInternal(context, RubyStruct.this.values[i2], otherStruct.values[i2])) continue;
                    return runtime.getFalse();
                }
                return runtime.getTrue();
            }
        }, this);
    }

    private IRubyObject inspectStruct(ThreadContext context) {
        RubyArray member = this.__member__();
        ByteList buffer = new ByteList("#<struct ".getBytes());
        if (this.is1_8() || this.getMetaClass().getRealClass().getBaseName() != null) {
            buffer.append(this.getMetaClass().getRealClass().getRealClass().getName().getBytes());
            buffer.append(32);
        }
        int k = member.getLength();
        for (int i2 = 0; i2 < k; ++i2) {
            if (i2 > 0) {
                buffer.append(44).append(32);
            }
            buffer.append(RubyString.objAsString(context, member.eltInternal(i2)).getByteList());
            buffer.append(61);
            buffer.append(RubyStruct.inspect(context, this.values[i2]).getByteList());
        }
        buffer.append(62);
        return this.getRuntime().newString(buffer);
    }

    private boolean is1_8() {
        return !this.getRuntime().is1_9() && !this.getRuntime().is2_0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect(ThreadContext context) {
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("#<struct " + this.getMetaClass().getRealClass().getName() + ":...>");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectStruct(context);
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @Override
    @JRubyMethod(name={"to_a", "values"})
    public RubyArray to_a() {
        return this.getRuntime().newArray(this.values);
    }

    @JRubyMethod(compat=CompatVersion.RUBY2_0)
    public RubyHash to_h(ThreadContext context) {
        RubyHash hash2 = RubyHash.newHash(context.runtime);
        RubyArray members2 = this.__member__();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            hash2.op_aset(context, members2.eltOk(i2), this.values[i2]);
        }
        return hash2;
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    public IRubyObject eachInternal(ThreadContext context, Block block) {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, this.values[i2]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each");
    }

    public IRubyObject each_pairInternal(ThreadContext context, Block block) {
        RubyArray member = this.__member__();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, this.getRuntime().newArrayNoCopy(member.eltInternal(i2), this.values[i2]));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_pair");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject key2) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            return this.getByName(key2.asJavaString());
        }
        int idx = RubyNumeric.fix2int(key2);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too small for struct(size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct(size:" + this.values.length + ")");
        }
        return this.values[idx];
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            return this.setByName(key2.asJavaString(), value2);
        }
        int idx = RubyNumeric.fix2int(key2);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too small for struct(size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct(size:" + this.values.length + ")");
        }
        this.modify();
        this.values[idx] = value2;
        return this.values[idx];
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        int olen = this.values.length;
        RubyArray result2 = this.getRuntime().newArray(args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2] instanceof RubyFixnum) {
                result2.append(this.aref(args2[i2]));
                continue;
            }
            if (args2[i2] instanceof RubyRange) {
                int len;
                int[] beglen = ((RubyRange)args2[i2]).begLenInt(olen, 0);
                if (beglen == null) continue;
                int beg = beglen[0];
                int end2 = len = beglen[1];
                for (int j = 0; j < end2; ++j) {
                    result2.append(this.aref(this.getRuntime().newFixnum(j + beg)));
                }
                continue;
            }
            result2.append(this.aref(this.getRuntime().newFixnum(RubyNumeric.num2long(args2[i2]))));
        }
        return result2;
    }

    public static void marshalTo(RubyStruct struct, MarshalStream output) throws IOException {
        output.registerLinkTarget(struct);
        output.dumpDefaultObjectHeader('S', struct.getMetaClass());
        RubyArray member = RubyStruct.__member__(struct.classOf());
        output.writeInt(member.size());
        for (int i2 = 0; i2 < member.size(); ++i2) {
            RubySymbol name2 = (RubySymbol)member.eltInternal(i2);
            output.dumpObject(name2);
            output.dumpObject(struct.values[i2]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        IRubyObject[] values2;
        RubySymbol className;
        Ruby runtime = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(runtime, (className = (RubySymbol)input.unmarshalObject(false)).asJavaString());
        if (rbClass == null) {
            throw runtime.newNameError("uninitialized constant " + className, className.asJavaString());
        }
        RubyArray mem = RubyStruct.members(rbClass, Block.NULL_BLOCK);
        int len = input.unmarshalInt();
        if (len == 0) {
            values2 = IRubyObject.NULL_ARRAY;
        } else {
            values2 = new IRubyObject[len];
            Helpers.fillNil(values2, runtime);
        }
        RubyStruct result2 = runtime.is1_9() ? new RubyStruct(runtime, rbClass) : RubyStruct.newStruct((IRubyObject)rbClass, values2, Block.NULL_BLOCK);
        input.registerLinkTarget(result2);
        for (int i2 = 0; i2 < len; ++i2) {
            IRubyObject slot = input.unmarshalObject(false);
            if (!mem.eltInternal(i2).toString().equals(slot.toString())) {
                throw runtime.newTypeError("struct " + rbClass.getName() + " not compatible (:" + slot + " for :" + mem.eltInternal(i2) + ")");
            }
            result2.aset(runtime.newFixnum(i2), input.unmarshalObject());
        }
        return result2;
    }

    private static RubyClass pathToClass(Ruby runtime, String path2) {
        return (RubyClass)runtime.getClassFromPath(path2);
    }

    @Override
    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg2) {
        if (this == arg2) {
            return this;
        }
        RubyStruct original = (RubyStruct)arg2;
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        return this;
    }

    public static class StructMethods {
        @JRubyMethod(name={"new", "[]"}, rest=true)
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
            return RubyStruct.newStruct(recv2, args2, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, Block block) {
            return RubyStruct.newStruct(recv2, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
            return RubyStruct.newStruct(recv2, arg0, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return RubyStruct.newStruct(recv2, arg0, arg1, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return RubyStruct.newStruct(recv2, arg0, arg1, arg2, block);
        }

        @JRubyMethod(name={"members"}, compat=CompatVersion.RUBY1_8)
        public static IRubyObject members(IRubyObject recv2, Block block) {
            return RubyStruct.members(recv2, block);
        }

        @JRubyMethod(name={"members"}, compat=CompatVersion.RUBY1_9)
        public static IRubyObject members19(IRubyObject recv2, Block block) {
            return RubyStruct.members19(recv2, block);
        }
    }
}

