/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.NormalCachingCallSite;

public class RespondToCallSite
extends NormalCachingCallSite {
    private volatile RespondToTuple respondToTuple = RespondToTuple.NULL_CACHE;

    public RespondToCallSite() {
        super("respond_to?");
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject name2) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = self.getMetaClass();
        if (tuple.cacheOk(klass) && (strName = name2.asJavaString()).equals(tuple.name) && tuple.checkVisibility) {
            return tuple.respondsTo;
        }
        return super.call(context, caller2, self, name2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject name2, IRubyObject bool2) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = self.getMetaClass();
        if (tuple.cacheOk(klass) && (strName = name2.asJavaString()).equals(tuple.name) && !bool2.isTrue() == tuple.checkVisibility) {
            return tuple.respondsTo;
        }
        return super.call(context, caller2, self, name2, bool2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg2);
        }
        if (!context.runtime.is1_9() && entry.method.equals(context.runtime.getRespondToMethod())) {
            RespondToTuple tuple;
            String name2 = arg2.asJavaString();
            this.respondToTuple = tuple = RespondToCallSite.recacheRespondsTo(entry, name2, selfType, true, context);
            return tuple.respondsTo;
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        if (this.methodMissing(method2, caller2)) {
            return this.callMethodMissing(context, self, method2, arg0, arg1);
        }
        if (!context.runtime.is1_9() && entry.method.equals(context.runtime.getRespondToMethod())) {
            RespondToTuple tuple;
            String name2 = arg0.asJavaString();
            this.respondToTuple = tuple = RespondToCallSite.recacheRespondsTo(entry, name2, selfType, !arg1.isTrue(), context);
            return tuple.respondsTo;
        }
        this.cache = entry;
        return method2.call(context, self, (RubyModule)selfType, this.methodName, arg0, arg1);
    }

    private static RespondToTuple recacheRespondsTo(CacheEntry respondToMethod, String newString, RubyClass klass, boolean checkVisibility, ThreadContext context) {
        Ruby runtime = context.runtime;
        CacheEntry respondToLookupResult = klass.searchWithCache(newString);
        IRubyObject respondsTo = !respondToLookupResult.method.isUndefined() && !respondToLookupResult.method.isNotImplemented() ? RespondToCallSite.checkVisibilityAndCache(respondToLookupResult, checkVisibility, runtime) : runtime.getFalse();
        return new RespondToTuple(newString, checkVisibility, respondToMethod, respondToLookupResult, respondsTo);
    }

    private static IRubyObject checkVisibilityAndCache(CacheEntry respondEntry, boolean checkVisibility, Ruby runtime) {
        if (!checkVisibility || respondEntry.method.getVisibility() != Visibility.PRIVATE) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    private static class RespondToTuple {
        static final RespondToTuple NULL_CACHE = new RespondToTuple("", true, CacheEntry.NULL_CACHE, CacheEntry.NULL_CACHE, null);
        public final String name;
        public final boolean checkVisibility;
        public final CacheEntry respondToMethod;
        public final CacheEntry entry;
        public final IRubyObject respondsTo;

        public RespondToTuple(String name2, boolean checkVisibility, CacheEntry respondToMethod, CacheEntry entry, IRubyObject respondsTo) {
            this.name = name2;
            this.checkVisibility = checkVisibility;
            this.respondToMethod = respondToMethod;
            this.entry = entry;
            this.respondsTo = respondsTo;
        }

        public boolean cacheOk(RubyClass klass) {
            return this.respondToMethod.typeOk(klass) && this.entry.typeOk(klass);
        }
    }
}

