/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;

final class DirectClosureBuffer
implements Closure.Buffer {
    private static final MemoryIO IO = MemoryIO.getInstance();
    private static final NativeWordIO WordIO = NativeWordIO.getInstance();
    private static final long PARAM_SIZE = Platform.getPlatform().addressSize() / 8;
    private final long retval;
    private final long parameters;
    private final CallContext callContext;

    public DirectClosureBuffer(CallContext callContext, long retval, long parameters2) {
        this.callContext = callContext;
        this.retval = retval;
        this.parameters = parameters2;
    }

    public final byte getByte(int index2) {
        return IO.getByte(IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE));
    }

    public final short getShort(int index2) {
        return IO.getShort(IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE));
    }

    public final int getInt(int index2) {
        return IO.getInt(IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE));
    }

    public final long getLong(int index2) {
        return IO.getLong(IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE));
    }

    public final float getFloat(int index2) {
        return IO.getFloat(IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE));
    }

    public final double getDouble(int index2) {
        return IO.getDouble(IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE));
    }

    public final long getAddress(int index2) {
        return IO.getAddress(IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE));
    }

    public final long getStruct(int index2) {
        return IO.getAddress(this.parameters + (long)index2 * PARAM_SIZE);
    }

    public final void setByteReturn(byte value2) {
        WordIO.put(this.retval, value2);
    }

    public final void setShortReturn(short value2) {
        WordIO.put(this.retval, value2);
    }

    public final void setIntReturn(int value2) {
        WordIO.put(this.retval, value2);
    }

    public final void setLongReturn(long value2) {
        IO.putLong(this.retval, value2);
    }

    public final void setFloatReturn(float value2) {
        IO.putFloat(this.retval, value2);
    }

    public final void setDoubleReturn(double value2) {
        IO.putDouble(this.retval, value2);
    }

    public final void setAddressReturn(long address2) {
        IO.putAddress(this.retval, address2);
    }

    public void setStructReturn(long value2) {
        IO.copyMemory(value2, this.retval, this.callContext.getReturnType().size());
    }

    public void setStructReturn(byte[] data2, int offset2) {
        IO.putByteArray(this.retval, data2, offset2, this.callContext.getReturnType().size());
    }

    private static final class NativeWordIO64
    extends NativeWordIO {
        private static final MemoryIO IO = MemoryIO.getInstance();
        static final NativeWordIO INSTANCE = new NativeWordIO64();

        private NativeWordIO64() {
        }

        void put(long address2, int value2) {
            IO.putLong(address2, value2);
        }

        int get(long address2) {
            return (int)IO.getLong(address2);
        }
    }

    private static final class NativeWordIO32
    extends NativeWordIO {
        private static final MemoryIO IO = MemoryIO.getInstance();
        static final NativeWordIO INSTANCE = new NativeWordIO32();

        private NativeWordIO32() {
        }

        void put(long address2, int value2) {
            IO.putInt(address2, value2);
        }

        int get(long address2) {
            return IO.getInt(address2);
        }
    }

    private static abstract class NativeWordIO {
        private NativeWordIO() {
        }

        public static final NativeWordIO getInstance() {
            return Platform.getPlatform().addressSize() == 32 ? NativeWordIO32.INSTANCE : NativeWordIO64.INSTANCE;
        }

        abstract void put(long var1, int var3);

        abstract int get(long var1);
    }
}

