/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jruby.ir.util.DataIterable;
import org.jruby.ir.util.DirectedGraph;
import org.jruby.ir.util.Edge;
import org.jruby.ir.util.EdgeTypeIterable;
import org.jruby.ir.util.ExplicitVertexID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex<T>
implements Comparable<Vertex<T>> {
    private DirectedGraph graph;
    private T data;
    private Set<Edge<T>> incoming = null;
    private Set<Edge<T>> outgoing = null;
    int id;

    public Vertex(DirectedGraph graph, T data2, int id2) {
        this.graph = graph;
        this.data = data2;
        this.id = id2;
    }

    public void addEdgeTo(Vertex destination) {
        this.addEdgeTo(destination, (Object)null);
    }

    public void addEdgeTo(Vertex destination, Object type2) {
        Edge edge = new Edge(this, destination, type2);
        this.getOutgoingEdges().add(edge);
        destination.getIncomingEdges().add(edge);
        this.graph.edges().add(edge);
    }

    public void addEdgeTo(T destination) {
        this.addEdgeTo(destination, null);
    }

    public void addEdgeTo(T destination, Object type2) {
        Vertex<T> destinationVertex = this.graph.vertexFor(destination);
        this.addEdgeTo(destinationVertex, type2);
    }

    public boolean removeEdgeTo(Vertex destination) {
        for (Edge<T> edge : this.getOutgoingEdges()) {
            if (edge.getDestination() != destination) continue;
            this.getOutgoingEdges().remove(edge);
            edge.getDestination().getIncomingEdges().remove(edge);
            this.graph.edges().remove(edge);
            return true;
        }
        return false;
    }

    public void removeAllIncomingEdges() {
        for (Edge<T> edge : this.getIncomingEdges()) {
            edge.getSource().getOutgoingEdges().remove(edge);
        }
        this.incoming = null;
    }

    public void removeAllOutgoingEdges() {
        for (Edge<T> edge : this.getOutgoingEdges()) {
            edge.getDestination().getIncomingEdges().remove(edge);
        }
        this.outgoing = null;
    }

    public void removeAllEdges() {
        this.removeAllIncomingEdges();
        this.removeAllOutgoingEdges();
    }

    public int inDegree() {
        return this.incoming == null ? 0 : this.incoming.size();
    }

    public int outDegree() {
        return this.outgoing == null ? 0 : this.outgoing.size();
    }

    public Iterable<Edge<T>> getIncomingEdgesOfType(Object type2) {
        return new EdgeTypeIterable<T>(this.getIncomingEdges(), type2);
    }

    public Iterable<Edge<T>> getIncomingEdgesNotOfType(Object type2) {
        return new EdgeTypeIterable<T>(this.getIncomingEdges(), type2, true);
    }

    public Iterable<Edge<T>> getOutgoingEdgesOfType(Object type2) {
        return new EdgeTypeIterable<T>(this.getOutgoingEdges(), type2);
    }

    public T getIncomingSourceData() {
        Edge<T> edge = this.getSingleEdge(this.getIncomingEdges().iterator(), "");
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public T getIncomingSourceDataOfType(Object type2) {
        Edge<T> edge = this.getSingleEdge(this.getIncomingEdgesOfType(type2).iterator(), type2);
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public Iterable<T> getIncomingSourcesData() {
        return new DataIterable<T>(this.getIncomingEdges(), null, true, true);
    }

    public Iterable<T> getIncomingSourcesDataOfType(Object type2) {
        return new DataIterable<T>(this.getIncomingEdges(), type2, true, false);
    }

    public Iterable<T> getIncomingSourcesDataNotOfType(Object type2) {
        return new DataIterable<T>(this.getIncomingEdges(), type2, true, true);
    }

    public Iterable<Edge<T>> getOutgoingEdgesNotOfType(Object type2) {
        return new EdgeTypeIterable<T>(this.getOutgoingEdges(), type2, true);
    }

    public Iterable<T> getOutgoingDestinationsData() {
        return new DataIterable<T>(this.getOutgoingEdges(), null, false, true);
    }

    public Iterable<T> getOutgoingDestinationsDataOfType(Object type2) {
        return new DataIterable<T>(this.getOutgoingEdges(), type2, false, false);
    }

    public Iterable<T> getOutgoingDestinationsDataNotOfType(Object type2) {
        return new DataIterable<T>(this.getOutgoingEdges(), type2, false, true);
    }

    public T getOutgoingDestinationData() {
        Edge<T> edge = this.getSingleEdge(this.getOutgoingEdges().iterator(), "");
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    public T getOutgoingDestinationDataOfType(Object type2) {
        Edge<T> edge = this.getSingleEdge(this.getOutgoingEdgesOfType(type2).iterator(), type2);
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    private Edge<T> getSingleEdge(Iterator<Edge<T>> iterator, Object type2) {
        if (iterator.hasNext()) {
            Edge<T> edge = iterator.next();
            assert (!iterator.hasNext()) : "Should only be one edge of type " + type2;
            return edge;
        }
        return null;
    }

    public Edge<T> getIncomingEdgeOfType(Object type2) {
        return this.getSingleEdge(this.getIncomingEdgesOfType(type2).iterator(), type2);
    }

    public Edge<T> getOutgoingEdgeOfType(Object type2) {
        return this.getSingleEdge(this.getOutgoingEdgesOfType(type2).iterator(), type2);
    }

    public Edge<T> getIncomingEdge() {
        return this.getSingleEdge(this.getIncomingEdgesNotOfType(null).iterator(), null);
    }

    public Edge<T> getOutgoingEdge() {
        return this.getSingleEdge(this.getOutgoingEdgesNotOfType(null).iterator(), null);
    }

    public Set<Edge<T>> getIncomingEdges() {
        if (this.incoming == null) {
            this.incoming = new HashSet<Edge<T>>();
        }
        return this.incoming;
    }

    public Set<Edge<T>> getOutgoingEdges() {
        if (this.outgoing == null) {
            this.outgoing = new HashSet<Edge<T>>();
        }
        return this.outgoing;
    }

    public T getData() {
        return this.data;
    }

    public int getID() {
        return this.data instanceof ExplicitVertexID ? ((ExplicitVertexID)this.data).getID() : this.id;
    }

    public String toString() {
        int i2;
        Iterator<Edge<T>> iterator;
        boolean found = false;
        StringBuilder buf = new StringBuilder(this.data.toString());
        buf.append(":");
        Set<Edge<T>> edges = this.getOutgoingEdges();
        int size2 = edges.size();
        if (size2 > 0) {
            found = true;
            buf.append(">[");
            iterator = edges.iterator();
            for (i2 = 0; i2 < size2 - 1; ++i2) {
                buf.append(iterator.next().getDestination().getID()).append(",");
            }
            buf.append(iterator.next().getDestination().getID()).append("]");
        }
        if ((size2 = (edges = this.getIncomingEdges()).size()) > 0) {
            if (found) {
                buf.append(", ");
            }
            buf.append("<[");
            iterator = edges.iterator();
            for (i2 = 0; i2 < size2 - 1; ++i2) {
                buf.append(iterator.next().getSource().getID()).append(",");
            }
            buf.append(iterator.next().getSource().getID()).append("]");
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public int compareTo(Vertex<T> that) {
        if (this.getID() == that.getID()) {
            return 0;
        }
        if (this.getID() < that.getID()) {
            return -1;
        }
        return 1;
    }
}

