/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.tempfile;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyTempfile;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;
import org.jruby.util.PhantomReferenceReaper;
import org.jruby.util.io.EncodingOption;
import org.jruby.util.io.IOOptions;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"Tempfile"}, parent="File")
public class Tempfile
extends RubyTempfile {
    private static final ConcurrentMap<Reaper, Boolean> referenceSet;
    private volatile transient Reaper reaper;
    private static ObjectAllocator TEMPFILE_ALLOCATOR;
    private static final String DEFAULT_TMP_DIR;
    private static final Object tmpFileLock;
    private static int counter;
    private static final Random RND;
    private File tmpFile = null;

    public static RubyClass createTempfileClass(Ruby runtime) {
        RubyClass tempfileClass = runtime.defineClass("Tempfile", runtime.getFile(), TEMPFILE_ALLOCATOR);
        RubyKernel.require(tempfileClass, runtime.newString("tmpdir"), Block.NULL_BLOCK);
        tempfileClass.defineAnnotatedMethods(Tempfile.class);
        return tempfileClass;
    }

    public Tempfile(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        Ruby runtime = this.getRuntime();
        IRubyObject basename2 = args2[0];
        IRubyObject dir = this.defaultTmpDir(runtime, args2);
        JRubyFile tmp = null;
        Object object = tmpFileLock;
        synchronized (object) {
            try {
                IRubyObject tmpname;
                do {
                    if (counter == -1) {
                        counter = RND.nextInt() & 0xFFFF;
                    }
                    tmpname = this.callMethod(runtime.getCurrentContext(), "make_tmpname", new IRubyObject[]{basename2, runtime.newFixnum(++counter)});
                } while (!((File)(tmp = JRubyFile.create(this.getRuntime().getCurrentDirectory(), new File(dir.convertToString().toString(), tmpname.convertToString().toString()).getPath()))).createNewFile());
                this.tmpFile = tmp;
                this.path = ((File)tmp).getPath();
                try {
                    this.tmpFile.deleteOnExit();
                }
                catch (NullPointerException npe) {
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
                this.initializeOpen();
                this.reaper = new Reaper(this, runtime, this.tmpFile, this.openFile);
                referenceSet.put(this.reaper, Boolean.TRUE);
                return this;
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
        }
    }

    @JRubyMethod(required=1, optional=2, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block block) {
        EncodingOption encodingOption;
        RubyHash options2 = null;
        if (args2.length > 1 && args2[args2.length - 1] instanceof RubyHash) {
            options2 = (RubyHash)args2[args2.length - 1];
            args2 = Arrays.copyOfRange(args2, 0, args2.length - 1);
        }
        this.initialize(args2, block);
        if (options2 != null && (encodingOption = EncodingOption.getEncodingOptionFromObject(options2)) != null) {
            this.setEncodingFromOptions(encodingOption);
        }
        return this;
    }

    private IRubyObject defaultTmpDir(Ruby runtime, IRubyObject[] args2) {
        IRubyObject dir = null;
        if (args2.length == 2) {
            dir = args2[1];
        } else {
            runtime.getLoadService().require("tmpdir");
            dir = runtime.getDir().callMethod(runtime.getCurrentContext(), "tmpdir");
        }
        return dir;
    }

    private void initializeOpen() {
        Ruby runtime = this.getRuntime();
        IOOptions ioOptions = Tempfile.newIOOptions(runtime, ModeFlags.RDWR | ModeFlags.EXCL);
        this.getRuntime().getPosix().chmod(this.path, 384);
        this.sysopenInternal(this.path, ioOptions.getModeFlags(), 384);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject make_tmpname(ThreadContext context, IRubyObject basename2, IRubyObject n, Block block) {
        IRubyObject suffix;
        IRubyObject base;
        Ruby runtime = context.runtime;
        IRubyObject[] newargs = new IRubyObject[5];
        if (basename2 instanceof RubyArray) {
            RubyArray array = (RubyArray)basename2;
            int length2 = array.getLength();
            base = length2 > 0 ? array.eltInternal(0) : runtime.getNil();
            suffix = length2 > 0 ? array.eltInternal(1) : runtime.getNil();
        } else {
            base = basename2;
            suffix = runtime.newString("");
        }
        newargs[0] = runtime.newString("%s.%d.%d%s");
        newargs[1] = base;
        newargs[2] = runtime.getGlobalVariables().get("$$");
        newargs[3] = n;
        newargs[4] = suffix;
        return this.callMethod(context, "sprintf", newargs);
    }

    @JRubyMethod(visibility=Visibility.PUBLIC)
    public IRubyObject open() {
        if (!this.isClosed()) {
            this.close();
        }
        this.openInternal(this.path, "r+");
        return this;
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public IRubyObject _close(ThreadContext context) {
        return !this.isClosed() ? super.close() : context.runtime.getNil();
    }

    @JRubyMethod(optional=1, visibility=Visibility.PUBLIC)
    public IRubyObject close(ThreadContext context, IRubyObject[] args2, Block block) {
        boolean unlink2 = args2.length == 1 ? args2[0].isTrue() : false;
        return unlink2 ? this.close_bang(context) : this._close(context);
    }

    @JRubyMethod(name={"close!"}, visibility=Visibility.PUBLIC)
    public IRubyObject close_bang(ThreadContext context) {
        referenceSet.remove(this.reaper);
        this.reaper.released = true;
        this._close(context);
        this.tmpFile.delete();
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"unlink", "delete"})
    public IRubyObject unlink(ThreadContext context) {
        if (this.isClosed()) {
            if (!this.tmpFile.exists() || this.tmpFile.delete()) {
                referenceSet.remove(this.reaper);
                this.reaper.released = true;
                this.path = null;
            }
        } else {
            context.runtime.getWarnings().warn("Tempfile#unlink or delete called on open file; ignoring");
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        if (!this.isClosed()) {
            this.flush();
            return context.runtime.newFileStat(this.path, false).size();
        }
        return RubyFixnum.zero(context.runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Tempfile tempfile2;
        block4: {
            Ruby runtime = context.runtime;
            RubyClass klass = (RubyClass)recv2;
            tempfile2 = (Tempfile)klass.newInstance(context, args2, block);
            if (!block.isGiven()) break block4;
            try {
                block.yield(context, tempfile2);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!tempfile2.isClosed()) {
                    tempfile2.close();
                }
                throw throwable;
            }
            if (!tempfile2.isClosed()) {
                tempfile2.close();
            }
            return runtime.getNil();
        }
        return tempfile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass klass = (RubyClass)recv2;
        Tempfile tempfile2 = (Tempfile)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            IRubyObject iRubyObject;
            try {
                iRubyObject = block.yield(context, tempfile2);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!tempfile2.isClosed()) {
                    tempfile2.close();
                }
                throw throwable;
            }
            if (!tempfile2.isClosed()) {
                tempfile2.close();
            }
            return iRubyObject;
        }
        return tempfile2;
    }

    static {
        String tmpDir;
        referenceSet = new ConcurrentHashMap<Reaper, Boolean>();
        TEMPFILE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                Tempfile instance = new Tempfile(runtime, klass);
                return instance;
            }
        };
        tmpFileLock = new Object();
        counter = -1;
        RND = new Random();
        if (Platform.IS_WINDOWS) {
            tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                tmpDir = System.getenv("TEMP");
            }
            if (tmpDir == null) {
                tmpDir = System.getenv("TMP");
            }
            if (tmpDir == null) {
                tmpDir = "C:\\Windows\\Temp";
            }
        } else {
            tmpDir = "/tmp";
        }
        DEFAULT_TMP_DIR = tmpDir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Reaper
    extends PhantomReferenceReaper<Tempfile>
    implements Runnable {
        private volatile boolean released = false;
        private final Ruby runtime;
        private final File tmpFile;
        private final OpenFile openFile;

        Reaper(Tempfile file2, Ruby runtime, File tmpFile, OpenFile openFile) {
            super(file2);
            this.runtime = runtime;
            this.tmpFile = tmpFile;
            this.openFile = openFile;
        }

        @Override
        public final void run() {
            referenceSet.remove(this);
            this.release();
            this.clear();
        }

        final void release() {
            if (!this.released) {
                this.released = true;
                if (this.openFile != null) {
                    this.openFile.cleanup(this.runtime, false);
                }
                if (this.tmpFile.exists()) {
                    boolean deleted = this.tmpFile.delete();
                    if (this.runtime.getDebug().isTrue()) {
                        String msg = "removing " + this.tmpFile.getPath() + " ... ";
                        if (deleted) {
                            this.runtime.getErr().println(msg + "done");
                        } else {
                            this.runtime.getErr().println(msg + "can't delete");
                        }
                    }
                }
            }
        }
    }
}

