/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.NameInfo;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.netdb.Service;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.RubySocket;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.Sockaddr;

public class SocketUtils {
    private static final Pattern STRING_IPV4_ADDRESS_PATTERN = Pattern.compile("((.*)\\/)?([\\.0-9]+)(:([0-9]+))?");
    private static final int IPV4_HOST_GROUP = 3;
    private static final int IPV4_PORT_GROUP = 5;
    private static final String BROADCAST = "<broadcast>";
    private static final byte[] INADDR_BROADCAST = new byte[]{-1, -1, -1, -1};
    private static final String ANY = "<any>";
    private static final byte[] INADDR_ANY = new byte[]{0, 0, 0, 0};

    public static IRubyObject gethostname(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            return runtime.newString(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            try {
                return runtime.newString(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException e2) {
                throw SocketUtils.sockerr(runtime, "gethostname: name or service not known");
            }
        }
    }

    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject[] ret = new IRubyObject[]{runtime.newString(Sockaddr.addressFromString(runtime, args2[0].convertToString().toString()).getCanonicalHostName()), runtime.newArray(), runtime.newFixnum(2), args2[0]};
        return runtime.newArrayNoCopy(ret);
    }

    public static IRubyObject getservbyname(ThreadContext context, IRubyObject[] args2) {
        int port;
        String proto;
        Ruby runtime = context.runtime;
        String name2 = args2[0].convertToString().toString();
        Service service = Service.getServiceByName(name2, proto = args2.length == 1 ? "tcp" : args2[1].convertToString().toString());
        if (service != null) {
            port = service.getPort();
        } else {
            try {
                port = Integer.parseInt(name2.trim());
            }
            catch (NumberFormatException nfe) {
                throw SocketUtils.sockerr(runtime, "no such service " + name2 + "/" + proto);
            }
        }
        return runtime.newFixnum(port);
    }

    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject port, IRubyObject host) {
        int portNum = port instanceof RubyString ? Integer.parseInt(port.convertToString().toString()) : RubyNumeric.fix2int(port);
        return Sockaddr.pack_sockaddr_in(context, portNum, host.isNil() ? null : host.convertToString().toString());
    }

    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_in(context, addr2);
    }

    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject filename2) {
        ByteList str = filename2.convertToString().getByteList();
        AddressFamily af = AddressFamily.AF_UNIX;
        int high = (af.intValue() & 0xFF00) >> 8;
        int low = af.intValue() & 0xFF;
        ByteList bl = new ByteList();
        bl.append((byte)high);
        bl.append((byte)low);
        bl.append(str);
        for (int i2 = str.length(); i2 < 104; ++i2) {
            bl.append((byte)0);
        }
        return context.runtime.newString(bl);
    }

    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject hostname) {
        Ruby runtime = context.runtime;
        try {
            InetAddress addr2 = SocketUtils.getRubyInetAddress(hostname.convertToString().getByteList());
            IRubyObject[] ret = new IRubyObject[]{runtime.newString(addr2.getCanonicalHostName()), runtime.newArray(), runtime.newFixnum(2), runtime.newString(new ByteList(addr2.getAddress()))};
            return runtime.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "gethostbyname: name or service not known");
        }
    }

    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject host = args2[0];
        IRubyObject port = args2[1];
        boolean emptyHost = host.isNil() || host.convertToString().isEmpty();
        try {
            int flag;
            if (port instanceof RubyString) {
                port = SocketUtils.getservbyname(context, new IRubyObject[]{port});
            }
            IRubyObject family2 = args2.length > 2 ? args2[2] : context.nil;
            IRubyObject socktype2 = args2.length > 3 ? args2[3] : context.nil;
            IRubyObject flags = args2.length > 5 ? args2[5] : context.nil;
            boolean is_ipv6 = !family2.isNil() && (RubyNumeric.fix2int(family2) & AddressFamily.AF_INET6.intValue()) == AddressFamily.AF_INET6.intValue();
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (!socktype2.isNil()) {
                int val = RubyNumeric.fix2int(socktype2);
                if (val == Sock.SOCK_STREAM.intValue()) {
                    sock_dgram = false;
                } else if (val == Sock.SOCK_DGRAM.intValue()) {
                    sock_stream = false;
                }
            }
            InetAddress[] addrs = null;
            if (!flags.isNil() && RubyFixnum.fix2int(flags) > 0 && (flag = RubyNumeric.fix2int(flags)) == 1 && emptyHost) {
                addrs = InetAddress.getAllByName(is_ipv6 ? "[::]" : "0.0.0.0");
            }
            if (addrs == null) {
                addrs = InetAddress.getAllByName(emptyHost ? (is_ipv6 ? "[::1]" : null) : host.convertToString().toString());
            }
            ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
            for (int i2 = 0; i2 < addrs.length; ++i2) {
                IRubyObject[] c;
                if (sock_dgram) {
                    c = new IRubyObject[]{runtime.newString(is_ipv6 ? "AF_INET6" : "AF_INET"), port, runtime.newString(SocketUtils.getHostAddress(context, addrs[i2])), runtime.newString(addrs[i2].getHostAddress()), runtime.newFixnum(is_ipv6 ? ProtocolFamily.PF_INET6 : ProtocolFamily.PF_INET), runtime.newFixnum(Sock.SOCK_DGRAM), runtime.newFixnum(IPProto.IPPROTO_UDP)};
                    l.add(runtime.newArrayNoCopy(c));
                }
                if (!sock_stream) continue;
                c = new IRubyObject[]{runtime.newString(is_ipv6 ? "AF_INET6" : "AF_INET"), port, runtime.newString(SocketUtils.getHostAddress(context, addrs[i2])), runtime.newString(addrs[i2].getHostAddress()), runtime.newFixnum(is_ipv6 ? ProtocolFamily.PF_INET6 : ProtocolFamily.PF_INET), runtime.newFixnum(Sock.SOCK_STREAM), runtime.newFixnum(IPProto.IPPROTO_TCP)};
                l.add(runtime.newArrayNoCopy(c));
            }
            return runtime.newArray(l);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "getaddrinfo: name or service not known");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject[] args2) {
        InetAddress addr2;
        String port;
        String host;
        Ruby runtime = context.runtime;
        int flags = args2.length == 2 ? RubyNumeric.num2int(args2[1]) : 0;
        IRubyObject arg0 = args2[0];
        if (arg0 instanceof RubyArray) {
            List list2 = ((RubyArray)arg0).getList();
            int len = list2.size();
            if (len < 3 || len > 4) {
                throw runtime.newArgumentError("array size should be 3 or 4, " + len + " given");
            }
            host = list2.size() == 3 ? list2.get(2).toString() : list2.get(3).toString();
            port = list2.get(1).toString();
        } else {
            if (!(arg0 instanceof RubyString)) throw runtime.newArgumentError("invalid args");
            String arg2 = ((RubyString)arg0).toString();
            Matcher m = STRING_IPV4_ADDRESS_PATTERN.matcher(arg2);
            if (!m.matches()) {
                IRubyObject obj = SocketUtils.unpack_sockaddr_in(context, arg0);
                if (!(obj instanceof RubyArray)) throw runtime.newArgumentError("invalid address string");
                List list3 = ((RubyArray)obj).getList();
                int len = list3.size();
                if (len != 2) {
                    throw runtime.newArgumentError("invalid address representation");
                }
                host = list3.get(1).toString();
                port = list3.get(0).toString();
            } else {
                host = m.group(3);
                if (host == null || host.length() == 0 || (port = m.group(5)) == null || port.length() == 0) {
                    throw runtime.newArgumentError("invalid address string");
                }
                try {
                    InetAddress ipv6_addr = InetAddress.getByName(host);
                    if (ipv6_addr instanceof Inet6Address) {
                        host = ipv6_addr.getHostAddress();
                    }
                }
                catch (UnknownHostException uhe) {
                    throw runtime.newArgumentError("invalid address string");
                }
            }
        }
        try {
            addr2 = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "unknown host: " + host);
        }
        host = (flags & NameInfo.NI_NUMERICHOST.intValue()) == 0 ? addr2.getCanonicalHostName() : addr2.getHostAddress();
        Service serv = Service.getServiceByPort(Integer.parseInt(port), null);
        if (serv == null) return runtime.newArray((IRubyObject)runtime.newString(host), (IRubyObject)runtime.newString(port));
        port = (flags & NameInfo.NI_NUMERICSERV.intValue()) == 0 ? serv.getName() : Integer.toString(serv.getPort());
        return runtime.newArray((IRubyObject)runtime.newString(host), (IRubyObject)runtime.newString(port));
    }

    public static IRubyObject ip_address_list(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            RubyArray list2 = RubyArray.newArray(runtime);
            RubyClass addrInfoCls = runtime.getClass("Addrinfo");
            Enumeration<NetworkInterface> networkIfcs = NetworkInterface.getNetworkInterfaces();
            while (networkIfcs.hasMoreElements()) {
                Enumeration<InetAddress> addresses = networkIfcs.nextElement().getInetAddresses();
                while (addresses.hasMoreElements()) {
                    list2.append(new Addrinfo(runtime, addrInfoCls, addresses.nextElement()));
                }
            }
            return list2;
        }
        catch (SocketException se) {
            throw SocketUtils.sockerr(runtime, se.getLocalizedMessage());
        }
    }

    public static InetAddress getRubyInetAddress(ByteList address2) throws UnknownHostException {
        String addressString = address2.toString();
        if (addressString.equals(BROADCAST)) {
            return InetAddress.getByAddress(INADDR_BROADCAST);
        }
        if (addressString.equals(ANY)) {
            return InetAddress.getByAddress(INADDR_ANY);
        }
        return InetAddress.getByName(address2.toString());
    }

    public static IRubyObject getaddress(ThreadContext context, IRubyObject hostname) {
        try {
            return context.runtime.newString(InetAddress.getByName(hostname.convertToString().toString()).getHostAddress());
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(context.runtime, "getaddress: name or service not known");
        }
    }

    public static RuntimeException sockerr(Ruby runtime, String msg) {
        return new RaiseException(runtime, runtime.getClass("SocketError"), msg, true);
    }

    public static int getPortFrom(ThreadContext context, IRubyObject _port) {
        int port;
        if (_port instanceof RubyInteger) {
            port = RubyNumeric.fix2int(_port);
        } else {
            RubyString portString = _port.convertToString();
            RubyInteger portInteger = portString.convertToInteger("to_i");
            port = RubyNumeric.fix2int(portInteger);
            if (port <= 0) {
                port = RubyNumeric.fix2int(RubySocket.getservbyname(context, context.runtime.getObject(), new IRubyObject[]{portString}));
            }
        }
        return port;
    }

    private static String getHostAddress(ThreadContext context, InetAddress addr2) {
        return context.runtime.isDoNotReverseLookupEnabled() ? addr2.getHostAddress() : addr2.getCanonicalHostName();
    }

    static AddressFamily addressFamilyFromArg(IRubyObject domain) {
        AddressFamily addressFamily = null;
        if (domain instanceof RubyString || domain instanceof RubySymbol) {
            String domainString = domain.toString();
            addressFamily = AddressFamily.valueOf("AF_" + domainString);
        } else {
            int domainInt = RubyNumeric.fix2int(domain);
            addressFamily = AddressFamily.valueOf(domainInt);
        }
        return addressFamily;
    }

    static Sock sockFromArg(IRubyObject type2) {
        Sock sockType = null;
        if (type2 instanceof RubyString || type2 instanceof RubySymbol) {
            String typeString = type2.toString();
            sockType = Sock.valueOf("SOCK_" + typeString);
        } else {
            int typeInt = RubyNumeric.fix2int(type2);
            sockType = Sock.valueOf(typeInt);
        }
        return sockType;
    }

    static ProtocolFamily protocolFamilyFromArg(IRubyObject protocol2) {
        ProtocolFamily protocolFamily = null;
        if (protocol2 instanceof RubyString || protocol2 instanceof RubySymbol) {
            String protocolString = protocol2.toString();
            protocolFamily = ProtocolFamily.valueOf("PF_" + protocolString);
        } else {
            int protocolInt = RubyNumeric.fix2int(protocol2);
            if (protocolInt == 0) {
                return null;
            }
            protocolFamily = ProtocolFamily.valueOf(protocolInt);
        }
        return protocolFamily;
    }

    public static int portToInt(IRubyObject port) {
        return port.isNil() ? 0 : RubyNumeric.fix2int(port);
    }
}

