/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.io.wait;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    public void load(Ruby runtime, boolean wrap2) {
        RubyClass ioClass = runtime.getIO();
        ioClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod(name={"ready?"})
    public static IRubyObject ready(ThreadContext context, IRubyObject obj) {
        RubyIO io2 = (RubyIO)obj;
        try {
            OpenFile openFile = io2.getOpenFile();
            ChannelDescriptor descriptor = openFile.getMainStreamSafe().getDescriptor();
            if (!descriptor.isOpen() || !openFile.getMainStreamSafe().getModes().isReadable() || openFile.getMainStreamSafe().feof()) {
                return context.runtime.getFalse();
            }
            int avail = openFile.getMainStreamSafe().ready();
            if (avail > 0) {
                return context.runtime.newFixnum(avail);
            }
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (Exception anyEx) {
            return context.runtime.getFalse();
        }
        return context.runtime.getNil();
    }

    @JRubyMethod
    public static IRubyObject io_wait(ThreadContext context, IRubyObject obj) {
        RubyIO io2 = (RubyIO)obj;
        try {
            OpenFile openFile = io2.getOpenFile();
            if (openFile.getMainStreamSafe().feof()) {
                return context.runtime.getNil();
            }
            openFile.getMainStreamSafe().waitUntilReady();
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
        catch (Exception anyEx) {
            return context.runtime.getNil();
        }
        return obj;
    }
}

