/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVarNode
extends Node
implements INameNode {
    private String name;
    private final int location;

    public LocalVarNode(ISourcePosition position, int location, String name2) {
        super(position);
        this.location = location;
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LOCALVARNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitLocalVarNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result2 = context.getCurrentScope().getValue(this.getIndex(), this.getDepth());
        return result2 == null ? runtime.getNil() : result2;
    }

    @Override
    public ByteList definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return LOCAL_VARIABLE_BYTELIST;
    }
}

