/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.CompoundString;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RegexpOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Regexp
extends Operand {
    public final RegexpOptions options;
    private final Operand regexp;
    private RubyRegexp rubyRegexp;

    public Regexp(Operand regexp2, RegexpOptions options2) {
        this.regexp = regexp2;
        this.options = options2;
    }

    @Override
    public boolean hasKnownValue() {
        return this.regexp.hasKnownValue();
    }

    public String toString() {
        return "RE:|" + this.regexp + "|" + this.options;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newRegexp = this.regexp.getSimplifiedOperand(valueMap, force);
        return newRegexp == this.regexp ? this : new Regexp(newRegexp, this.options);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.regexp.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.hasKnownValue() ? this : new Regexp(this.regexp.cloneForInlining(ii), this.options);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        if (!this.regexp.hasKnownValue() && !this.options.isOnce() || this.rubyRegexp == null || context.getRuntime().getKCode() != this.rubyRegexp.getKCode()) {
            RubyRegexp re;
            if (this.regexp instanceof CompoundString) {
                if (context.runtime.is1_9()) {
                    IRubyObject[] pieces = ((CompoundString)this.regexp).retrievePieces(context, self, currDynScope, temp);
                    RubyString pattern = RubyRegexp.preprocessDRegexp(context.getRuntime(), pieces, this.options);
                    re = RubyRegexp.newDRegexp(context.getRuntime(), pattern, this.options);
                } else {
                    RubyString pattern = (RubyString)this.regexp.retrieve(context, self, currDynScope, temp);
                    re = RubyRegexp.newDRegexp(context.getRuntime(), pattern, this.options);
                }
            } else {
                RubyString pattern = (RubyString)this.regexp.retrieve(context, self, currDynScope, temp);
                re = RubyRegexp.newRegexp(context.getRuntime(), pattern.getByteList(), this.options);
            }
            re.setLiteral();
            this.rubyRegexp = re;
        }
        return this.rubyRegexp;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Regexp(this);
    }
}

