/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.RubyBasicObject;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacktickString
extends Operand {
    public final List<Operand> pieces;

    public BacktickString(Operand val) {
        this.pieces = new ArrayList<Operand>();
        this.pieces.add(val);
    }

    public BacktickString(List<Operand> pieces) {
        this.pieces = pieces;
    }

    @Override
    public boolean hasKnownValue() {
        for (Operand o : this.pieces) {
            if (o.hasKnownValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        ArrayList<Operand> newPieces = new ArrayList<Operand>();
        for (Operand p2 : this.pieces) {
            newPieces.add(p2.getSimplifiedOperand(valueMap, force));
        }
        return new BacktickString(newPieces);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this.pieces) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.hasKnownValue()) {
            return this;
        }
        ArrayList<Operand> newPieces = new ArrayList<Operand>();
        for (Operand p2 : this.pieces) {
            newPieces.add(p2.cloneForInlining(ii));
        }
        return new BacktickString(newPieces);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        RubyString newString = context.getRuntime().newString();
        for (Operand p2 : this.pieces) {
            RubyBasicObject piece = (RubyBasicObject)p2.retrieve(context, self, currDynScope, temp);
            newString.append(piece instanceof RubyString ? (RubyString)piece : piece.to_s());
        }
        return self.callMethod(context, "`", newString);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BacktickString(this);
    }
}

