/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetSocketAddress;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIPSocket(runtime, klass);
        }
    };

    static void createIPSocket(Ruby runtime) {
        RubyClass rb_cIPSocket = runtime.defineClass("IPSocket", runtime.getClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        rb_cIPSocket.defineAnnotatedMethods(RubyIPSocket.class);
        runtime.getObject().setConstant("IPsocket", rb_cIPSocket);
    }

    public RubyIPSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        return this.addrCommon(context, true);
    }

    @JRubyMethod(name={"addr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject addr19(ThreadContext context) {
        return this.addrCommon(context, true);
    }

    @JRubyMethod(name={"addr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject addr19(ThreadContext context, IRubyObject reverse2) {
        return this.addrCommon(context, reverse2.isTrue());
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        return this.peeraddrCommon(context, true);
    }

    @JRubyMethod(name={"peeraddr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject peeraddr19(ThreadContext context) {
        return this.peeraddrCommon(context, true);
    }

    @JRubyMethod(name={"peeraddr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject peeraddr19(ThreadContext context, IRubyObject reverse2) {
        return this.peeraddrCommon(context, reverse2.isTrue());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(ThreadContext context, IRubyObject self, IRubyObject hostname) {
        return SocketUtils.getaddress(context, hostname);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length) {
        Ruby runtime = context.runtime;
        try {
            String hostName;
            String hostAddress;
            int port;
            IRubyObject result2 = this.recv(context, _length);
            InetSocketAddress sender = this.getRemoteSocket();
            if (sender == null) {
                port = 0;
                hostAddress = "0.0.0.0";
                hostName = "0.0.0.0";
            } else {
                port = sender.getPort();
                hostName = sender.getHostName();
                hostAddress = sender.getAddress().getHostAddress();
            }
            RubyArray addressArray = context.getRuntime().newArray(runtime.newString("AF_INET"), runtime.newFixnum(port), runtime.newString(hostName), runtime.newString(hostAddress));
            return runtime.newArray(result2, (IRubyObject)addressArray);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    @JRubyMethod(name={"getpeereid"}, compat=CompatVersion.RUBY1_9, notImplemented=true)
    public IRubyObject getpeereid(ThreadContext context) {
        throw context.runtime.newNotImplementedError("getpeereid not implemented");
    }

    protected IRubyObject getSocknameCommon(ThreadContext context, String caller2) {
        try {
            InetSocketAddress sock = this.getSocketAddress();
            return Sockaddr.packSockaddrFromAddress(context, sock);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    public IRubyObject getpeername(ThreadContext context) {
        try {
            InetSocketAddress sock = this.getRemoteSocket();
            return Sockaddr.packSockaddrFromAddress(context, sock);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    private IRubyObject addrCommon(ThreadContext context, boolean reverse2) {
        try {
            InetSocketAddress address2 = this.getSocketAddress();
            if (address2 == null) {
                throw context.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
            }
            return this.addrFor(context, address2, reverse2);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    private IRubyObject peeraddrCommon(ThreadContext context, boolean reverse2) {
        try {
            InetSocketAddress address2 = this.getRemoteSocket();
            if (address2 == null) {
                throw context.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
            }
            return this.addrFor(context, address2, reverse2);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @Deprecated
    public IRubyObject addr() {
        return this.addr(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject peeraddr() {
        return this.peeraddr(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public static IRubyObject getaddress(IRubyObject recv2, IRubyObject hostname) {
        return RubyIPSocket.getaddress(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @Deprecated
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.recvfrom(context, args2[0]);
            }
            case 2: {
                return this.recvfrom(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2, 1, 2);
        return null;
    }
}

