/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.rbconfig;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.util.Platform;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.NormalizedFile;
import org.jruby.util.SafePropertyAccessor;

@JRubyModule(name={"Config"})
public class RbConfigLibrary
implements Library {
    private static final String RUBY_DARWIN = "darwin";
    private static final String RUBY_LINUX = "linux";
    private static final String RUBY_WIN32 = "mswin32";
    private static final String RUBY_SOLARIS = "solaris";
    private static final String RUBY_FREEBSD = "freebsd";
    private static final String RUBY_AIX = "aix";
    private static String normalizedHome;
    public static final Map<String, String> RUBY_OS_NAMES;

    public static String getOSName() {
        if (Platform.IS_WINDOWS) {
            return RUBY_WIN32;
        }
        String OSName = Platform.getOSName();
        String theOSName = RUBY_OS_NAMES.get(OSName);
        return theOSName == null ? OSName : theOSName;
    }

    public static String getArchitecture() {
        String architecture = Platform.ARCH;
        if (architecture == null) {
            architecture = "unknown";
        }
        if (architecture.equals("amd64")) {
            architecture = "x86_64";
        }
        return architecture;
    }

    public void load(Ruby runtime, boolean wrap2) {
        String binDir;
        RubyModule configModule;
        if (runtime.is1_9()) {
            configModule = runtime.defineModule("RbConfig");
            RubyKernel.autoload(runtime.getObject(), runtime.newSymbol("Config"), runtime.newString("rbconfig/obsolete.rb"));
        } else {
            configModule = runtime.defineModule("Config");
            runtime.getObject().defineConstant("RbConfig", configModule);
        }
        configModule.defineAnnotatedMethods(RbConfigLibrary.class);
        RubyHash configHash = RubyHash.newHash(runtime);
        configModule.defineConstant("CONFIG", configHash);
        String[] versionParts = runtime.is1_9() ? "1.9.3".split("\\.") : "1.8.7".split("\\.");
        RbConfigLibrary.setConfig(configHash, "MAJOR", versionParts[0]);
        RbConfigLibrary.setConfig(configHash, "MINOR", versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "TEENY", versionParts[2]);
        RbConfigLibrary.setConfig(configHash, "ruby_version", versionParts[0] + '.' + versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "arch", "universal-java" + System.getProperty("java.specification.version"));
        normalizedHome = runtime.getJRubyHome();
        if (normalizedHome == null && Ruby.isSecurityRestricted()) {
            normalizedHome = "SECURITY RESTRICTED";
        }
        if ((binDir = SafePropertyAccessor.getProperty("jruby.bindir")) == null) {
            binDir = new NormalizedFile(normalizedHome, "bin").getPath();
        }
        RbConfigLibrary.setConfig(configHash, "bindir", binDir);
        RbConfigLibrary.setConfig(configHash, "RUBY_INSTALL_NAME", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(configHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(configHash, "SHELL", RbConfigLibrary.jrubyShell());
        RbConfigLibrary.setConfig(configHash, "prefix", normalizedHome);
        RbConfigLibrary.setConfig(configHash, "exec_prefix", normalizedHome);
        RbConfigLibrary.setConfig(configHash, "host_os", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(configHash, "host_vendor", System.getProperty("java.vendor"));
        RbConfigLibrary.setConfig(configHash, "host_cpu", RbConfigLibrary.getArchitecture());
        RbConfigLibrary.setConfig(configHash, "target_os", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(configHash, "target_cpu", RbConfigLibrary.getArchitecture());
        String jrubyJarFile = "jruby.jar";
        URL jrubyPropertiesUrl = Ruby.getClassLoader().getResource("/org/jruby/Ruby.class");
        if (jrubyPropertiesUrl != null) {
            Pattern jarFile = Pattern.compile("jar:file:.*?([a-zA-Z0-9.\\-]+\\.jar)!/org/jruby/Ruby.class");
            Matcher jarMatcher = jarFile.matcher(jrubyPropertiesUrl.toString());
            jarMatcher.find();
            if (jarMatcher.matches()) {
                jrubyJarFile = jarMatcher.group(1);
            }
        }
        RbConfigLibrary.setConfig(configHash, "LIBRUBY", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "LIBRUBY_SO", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "LIBRUBY_SO", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "LIBRUBY_ALIASES", jrubyJarFile);
        RbConfigLibrary.setConfig(configHash, "build", "java1.6");
        RbConfigLibrary.setConfig(configHash, "target", "java1.5");
        String libdir = SafePropertyAccessor.getProperty("jruby.lib");
        if (libdir == null) {
            libdir = new NormalizedFile(normalizedHome, "lib").getPath();
        } else {
            try {
                libdir = new NormalizedFile(libdir).getCanonicalPath();
            }
            catch (IOException e) {
                libdir = new NormalizedFile(libdir).getAbsolutePath();
            }
        }
        String rubyLibDir = new NormalizedFile(libdir, "ruby/1.8").getPath();
        String siteDir = new NormalizedFile(libdir, "ruby/site_ruby").getPath();
        String siteLibDir = new NormalizedFile(libdir, "ruby/site_ruby/1.8").getPath();
        String siteArchDir = new NormalizedFile(libdir, "ruby/site_ruby/1.8/java").getPath();
        String archDir = new NormalizedFile(libdir, "ruby/1.8/java").getPath();
        String shareDir = new NormalizedFile(normalizedHome, "share").getPath();
        String includeDir = new NormalizedFile(normalizedHome, "lib/native/" + RbConfigLibrary.getOSName()).getPath();
        RbConfigLibrary.setConfig(configHash, "libdir", libdir);
        if (runtime.is1_9()) {
            RbConfigLibrary.setConfig(configHash, "rubylibprefix", libdir + "/ruby");
        }
        RbConfigLibrary.setConfig(configHash, "rubylibdir", rubyLibDir);
        RbConfigLibrary.setConfig(configHash, "sitedir", siteDir);
        RbConfigLibrary.setConfig(configHash, "sitelibdir", siteLibDir);
        RbConfigLibrary.setConfig(configHash, "sitearch", "java");
        RbConfigLibrary.setConfig(configHash, "sitearchdir", siteArchDir);
        RbConfigLibrary.setConfig(configHash, "archdir", archDir);
        RbConfigLibrary.setConfig(configHash, "topdir", archDir);
        RbConfigLibrary.setConfig(configHash, "includedir", includeDir);
        RbConfigLibrary.setConfig(configHash, "configure_args", "");
        RbConfigLibrary.setConfig(configHash, "datadir", shareDir);
        RbConfigLibrary.setConfig(configHash, "mandir", new NormalizedFile(normalizedHome, "man").getPath());
        RbConfigLibrary.setConfig(configHash, "sysconfdir", new NormalizedFile(normalizedHome, "etc").getPath());
        RbConfigLibrary.setConfig(configHash, "localstatedir", new NormalizedFile(normalizedHome, "var").getPath());
        RbConfigLibrary.setConfig(configHash, "DLEXT", "jar");
        if (Platform.IS_WINDOWS) {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", "");
        }
        if (runtime.is1_9()) {
            RbConfigLibrary.setConfig(configHash, "ridir", new NormalizedFile(shareDir, "ri").getPath());
        }
        String gemhome = SafePropertyAccessor.getProperty("jruby.gem.home");
        String gempath = SafePropertyAccessor.getProperty("jruby.gem.path");
        if (gemhome != null) {
            RbConfigLibrary.setConfig(configHash, "default_gem_home", gemhome);
        }
        if (gempath != null) {
            RbConfigLibrary.setConfig(configHash, "default_gem_path", gempath);
        }
        RbConfigLibrary.setConfig(configHash, "joda-time.version", "2.1");
        RbConfigLibrary.setConfig(configHash, "tzdata.version", "2011n");
        RubyHash mkmfHash = RubyHash.newHash(runtime);
        RbConfigLibrary.setConfig(mkmfHash, "libdir", libdir);
        RbConfigLibrary.setConfig(mkmfHash, "arch", "java");
        RbConfigLibrary.setConfig(mkmfHash, "rubylibdir", rubyLibDir);
        RbConfigLibrary.setConfig(mkmfHash, "sitedir", siteDir);
        RbConfigLibrary.setConfig(mkmfHash, "sitelibdir", siteLibDir);
        RbConfigLibrary.setConfig(mkmfHash, "sitearch", "java");
        RbConfigLibrary.setConfig(mkmfHash, "sitearchdir", siteArchDir);
        RbConfigLibrary.setConfig(mkmfHash, "archdir", archDir);
        RbConfigLibrary.setConfig(mkmfHash, "topdir", archDir);
        RbConfigLibrary.setConfig(mkmfHash, "configure_args", "");
        RbConfigLibrary.setConfig(mkmfHash, "datadir", new NormalizedFile(normalizedHome, "share").getPath());
        RbConfigLibrary.setConfig(mkmfHash, "mandir", new NormalizedFile(normalizedHome, "man").getPath());
        RbConfigLibrary.setConfig(mkmfHash, "sysconfdir", new NormalizedFile(normalizedHome, "etc").getPath());
        RbConfigLibrary.setConfig(mkmfHash, "localstatedir", new NormalizedFile(normalizedHome, "var").getPath());
        RbConfigLibrary.setupMakefileConfig(configModule, mkmfHash);
    }

    private static void setupMakefileConfig(RubyModule configModule, RubyHash mkmfHash) {
        Ruby ruby2 = configModule.getRuntime();
        RubyHash envHash = (RubyHash)ruby2.getObject().fetchConstant("ENV".intern());
        String cc = RbConfigLibrary.getRubyEnv(envHash, "CC", "cc");
        String cpp = RbConfigLibrary.getRubyEnv(envHash, "CPP", "cc -E");
        String cxx = RbConfigLibrary.getRubyEnv(envHash, "CXX", "c++");
        String jflags = " -fno-omit-frame-pointer -fno-strict-aliasing ";
        String cflags = jflags + " -fexceptions" + " $(cflags)";
        String cppflags = " $(DEFS) $(cppflags)";
        String cxxflags = cflags + " $(cxxflags)";
        String ldflags = "";
        String dldflags = "";
        String ldsharedflags = " -shared ";
        String archflags = " -m" + (Platform.IS_64_BIT ? "64" : "32");
        String hdr_dir = new NormalizedFile(normalizedHome, "lib/native/include/").getPath();
        if (Platform.IS_WINDOWS) {
            ldflags = ldflags + " -L" + new NormalizedFile(normalizedHome, "lib/native/" + (Platform.IS_64_BIT ? "x86_64" : "i386") + "-Windows").getPath();
            ldflags = ldflags + " -ljruby-cext";
            ldsharedflags = ldsharedflags + " $(if $(filter-out -g -g0,$(debugflags)),,-s)";
            dldflags = "-Wl,--enable-auto-image-base,--enable-auto-import $(DEFFILE)";
            archflags = archflags + " -march=native -mtune=native";
            RbConfigLibrary.setConfig(mkmfHash, "DLEXT", "dll");
        } else if (Platform.IS_MAC) {
            ldsharedflags = " -dynamic -bundle -undefined dynamic_lookup ";
            cflags = " -fPIC -DTARGET_RT_MAC_CFM=0 " + cflags;
            archflags = " -arch " + Platform.ARCH;
            cppflags = " -D_XOPEN_SOURCE -D_DARWIN_C_SOURCE " + cppflags;
            RbConfigLibrary.setConfig(mkmfHash, "DLEXT", "bundle");
        } else {
            cflags = " -fPIC " + cflags;
            RbConfigLibrary.setConfig(mkmfHash, "DLEXT", "so");
        }
        String libext = "a";
        String objext = "o";
        RbConfigLibrary.setConfig(mkmfHash, "configure_args", "");
        RbConfigLibrary.setConfig(mkmfHash, "CFLAGS", cflags);
        RbConfigLibrary.setConfig(mkmfHash, "CPPFLAGS", cppflags);
        RbConfigLibrary.setConfig(mkmfHash, "CXXFLAGS", cxxflags);
        RbConfigLibrary.setConfig(mkmfHash, "ARCH_FLAG", archflags);
        RbConfigLibrary.setConfig(mkmfHash, "LDFLAGS", ldflags);
        RbConfigLibrary.setConfig(mkmfHash, "DLDFLAGS", dldflags);
        RbConfigLibrary.setConfig(mkmfHash, "DEFS", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBEXT", libext);
        RbConfigLibrary.setConfig(mkmfHash, "OBJEXT", objext);
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBYARG_STATIC", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBYARG_SHARED", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBS", "");
        RbConfigLibrary.setConfig(mkmfHash, "DLDLIBS", "");
        RbConfigLibrary.setConfig(mkmfHash, "ENABLED_SHARED", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBY", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBY_A", "");
        RbConfigLibrary.setConfig(mkmfHash, "LIBRUBYARG", "");
        RbConfigLibrary.setConfig(mkmfHash, "prefix", " ");
        RbConfigLibrary.setConfig(mkmfHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(mkmfHash, "LDSHARED", cc + ldsharedflags);
        RbConfigLibrary.setConfig(mkmfHash, "LDSHAREDXX", cxx + ldsharedflags);
        RbConfigLibrary.setConfig(mkmfHash, "RUBY_PLATFORM", RbConfigLibrary.getOSName());
        RbConfigLibrary.setConfig(mkmfHash, "CC", cc);
        RbConfigLibrary.setConfig(mkmfHash, "CPP", cpp);
        RbConfigLibrary.setConfig(mkmfHash, "CXX", cxx);
        RbConfigLibrary.setConfig(mkmfHash, "OUTFLAG", "-o ");
        RbConfigLibrary.setConfig(mkmfHash, "COMMON_HEADERS", "ruby.h");
        RbConfigLibrary.setConfig(mkmfHash, "PATH_SEPARATOR", ":");
        RbConfigLibrary.setConfig(mkmfHash, "INSTALL", "install -c ");
        RbConfigLibrary.setConfig(mkmfHash, "RM", "rm -f");
        RbConfigLibrary.setConfig(mkmfHash, "CP", "cp ");
        RbConfigLibrary.setConfig(mkmfHash, "MAKEDIRS", "mkdir -p ");
        RbConfigLibrary.setConfig(mkmfHash, "includedir", hdr_dir);
        RbConfigLibrary.setConfig(mkmfHash, "rubyhdrdir", hdr_dir);
        RbConfigLibrary.setConfig(mkmfHash, "archdir", hdr_dir);
        ruby2.getObject().defineConstant("CROSS_COMPILING", ruby2.getNil());
        configModule.defineConstant("MAKEFILE_CONFIG", mkmfHash);
    }

    private static void setConfig(RubyHash hash2, String key2, String value2) {
        Ruby runtime = hash2.getRuntime();
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString(key2), runtime.newString(value2));
    }

    public static String jrubyScript() {
        return SafePropertyAccessor.getProperty("jruby.script", "jruby").replace('\\', '/');
    }

    public static String jrubyShell() {
        return SafePropertyAccessor.getProperty("jruby.shell", Platform.IS_WINDOWS ? "cmd.exe" : "/bin/sh").replace('\\', '/');
    }

    @JRubyMethod(name={"ruby"}, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject ruby(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.getRuntime();
        RubyHash configHash = (RubyHash)runtime.getModule("RbConfig").getConstant("CONFIG");
        IRubyObject bindir = configHash.op_aref(context, runtime.newString("bindir"));
        IRubyObject ruby_install_name = configHash.op_aref(context, runtime.newString("ruby_install_name"));
        IRubyObject exeext = configHash.op_aref(context, runtime.newString("EXEEXT"));
        return RuntimeHelpers.invoke(context, (IRubyObject)runtime.getClass("File"), "join", bindir, ruby_install_name.callMethod(context, "+", exeext));
    }

    private static String getRubyEnv(RubyHash envHash, String var, String default_value) {
        return (var = (String)envHash.get(var)) == null ? default_value : var;
    }

    static {
        RUBY_OS_NAMES = new HashMap<String, String>();
        RUBY_OS_NAMES.put("Mac OS X", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Darwin", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Linux", RUBY_LINUX);
        RUBY_OS_NAMES.put("Windows 95", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 98", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Me", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2000", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT (unknown)", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows XP", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2003", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Vista", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 7", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Server 2008", RUBY_WIN32);
        RUBY_OS_NAMES.put("Solaris", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("SunOS", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("FreeBSD", RUBY_FREEBSD);
        RUBY_OS_NAMES.put("AIX", RUBY_AIX);
    }
}

