/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Map;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOInputStream;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.jruby.util.unsafe.UnsafeFactory;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.ScannerException;

public class PsychParser
extends RubyObject {
    private static final Logger LOG = LoggerFactory.getLogger("PsychParser");
    public static final int YAML_ANY_ENCODING = 0;
    public static final int YAML_UTF8_ENCODING = UTF8Encoding.INSTANCE.getIndex();
    public static final int YAML_UTF16LE_ENCODING = UTF16LEEncoding.INSTANCE.getIndex();
    public static final int YAML_UTF16BE_ENCODING = UTF16BEEncoding.INSTANCE.getIndex();
    private Parser parser;
    private Event event;

    public static void initPsychParser(Ruby runtime, RubyModule psych2) {
        RubyClass psychParser = runtime.defineClassUnder("Parser", runtime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new PsychParser(runtime, klazz);
            }
        }, psych2);
        psychParser.defineConstant("ANY", runtime.newFixnum(0));
        psychParser.defineConstant("UTF8", runtime.newFixnum(YAML_UTF8_ENCODING));
        psychParser.defineConstant("UTF16LE", runtime.newFixnum(YAML_UTF16LE_ENCODING));
        psychParser.defineConstant("UTF16BE", runtime.newFixnum(YAML_UTF16BE_ENCODING));
        psychParser.defineAnnotatedMethods(PsychParser.class);
        psych2.defineClassUnder("SyntaxError", runtime.getSyntaxError(), RubyException.EXCEPTION_ALLOCATOR);
    }

    public PsychParser(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context, IRubyObject yaml) {
        Ruby runtime = context.runtime;
        return this.parse(context, yaml, RubyString.newString(runtime, "<unknown>"));
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context, IRubyObject yaml, IRubyObject path2) {
        Ruby runtime = context.runtime;
        boolean tainted = yaml.isTaint();
        try {
            StreamReader reader;
            if (yaml.respondsTo("read")) {
                reader = new StreamReader(new InputStreamReader((InputStream)new IOInputStream(yaml), RubyEncoding.UTF8));
                if (yaml instanceof RubyIO) {
                    tainted = true;
                }
            } else {
                reader = new StreamReader(new StringReader(yaml.convertToString().asJavaString()));
            }
            this.parser = new ParserImpl(reader);
            IRubyObject handler = this.getInstanceVariable("@handler");
            while (true) {
                RubyFixnum style;
                RubyBoolean implicit;
                IRubyObject tag2;
                IRubyObject anchor;
                this.event = this.parser.getEvent();
                if (this.event.is(Event.ID.StreamStart)) {
                    RuntimeHelpers.invoke(context, handler, "start_stream", (IRubyObject)runtime.newFixnum(0));
                    continue;
                }
                if (this.event.is(Event.ID.DocumentStart)) {
                    DocumentStartEvent dse = (DocumentStartEvent)this.event;
                    Integer[] versionInts = dse.getVersion();
                    RubyArray version2 = versionInts == null ? RubyArray.newArray(runtime) : RubyArray.newArray(runtime, runtime.newFixnum(versionInts[0]), runtime.newFixnum(versionInts[1]));
                    Map<String, String> tagsMap = dse.getTags();
                    RubyArray tags = RubyArray.newArray(runtime);
                    if (tags.size() > 0) {
                        for (Map.Entry<String, String> tag3 : tagsMap.entrySet()) {
                            RubyString key2 = RubyString.newString(runtime, tag3.getKey());
                            RubyString value2 = RubyString.newString(runtime, tag3.getValue());
                            key2.setTaint(tainted);
                            value2.setTaint(tainted);
                            tags.append(RubyArray.newArray(runtime, key2, value2));
                        }
                    }
                    RuntimeHelpers.invoke(context, handler, "start_document", (IRubyObject)version2, (IRubyObject)tags, (IRubyObject)runtime.newBoolean(!dse.getExplicit()));
                    continue;
                }
                if (this.event.is(Event.ID.DocumentEnd)) {
                    DocumentEndEvent dee = (DocumentEndEvent)this.event;
                    RuntimeHelpers.invoke(context, handler, "end_document", (IRubyObject)runtime.newBoolean(!dee.getExplicit()));
                    continue;
                }
                if (this.event.is(Event.ID.Alias)) {
                    AliasEvent ae = (AliasEvent)this.event;
                    IRubyObject alias2 = runtime.getNil();
                    if (ae.getAnchor() != null) {
                        alias2 = RubyString.newString(runtime, ae.getAnchor());
                        alias2.setTaint(tainted);
                    }
                    RuntimeHelpers.invoke(context, handler, "alias", alias2);
                    continue;
                }
                if (this.event.is(Event.ID.Scalar)) {
                    ScalarEvent se = (ScalarEvent)this.event;
                    anchor = se.getAnchor() == null ? runtime.getNil() : RubyString.newString(runtime, se.getAnchor());
                    tag2 = se.getTag() == null ? runtime.getNil() : RubyString.newString(runtime, se.getTag());
                    RubyBoolean plain_implicit = runtime.newBoolean(se.getImplicit().canOmitTagInPlainScalar());
                    RubyBoolean quoted_implicit = runtime.newBoolean(se.getImplicit().canOmitTagInNonPlainScalar());
                    RubyFixnum style2 = runtime.newFixnum(PsychParser.translateStyle(se.getStyle()));
                    RubyString val = RubyString.newString(runtime, se.getValue());
                    val.setTaint(tainted);
                    anchor.setTaint(tainted);
                    tag2.setTaint(tainted);
                    RuntimeHelpers.invoke(context, handler, "scalar", val, anchor, tag2, plain_implicit, quoted_implicit, style2);
                    continue;
                }
                if (this.event.is(Event.ID.SequenceStart)) {
                    SequenceStartEvent sse = (SequenceStartEvent)this.event;
                    anchor = sse.getAnchor() == null ? runtime.getNil() : RubyString.newString(runtime, sse.getAnchor());
                    tag2 = sse.getTag() == null ? runtime.getNil() : RubyString.newString(runtime, sse.getTag());
                    implicit = runtime.newBoolean(sse.getImplicit());
                    style = runtime.newFixnum(PsychParser.translateFlowStyle(sse.getFlowStyle()));
                    anchor.setTaint(tainted);
                    tag2.setTaint(tainted);
                    RuntimeHelpers.invoke(context, handler, "start_sequence", anchor, tag2, implicit, style);
                    continue;
                }
                if (this.event.is(Event.ID.SequenceEnd)) {
                    RuntimeHelpers.invoke(context, handler, "end_sequence");
                    continue;
                }
                if (this.event.is(Event.ID.MappingStart)) {
                    MappingStartEvent mse = (MappingStartEvent)this.event;
                    anchor = mse.getAnchor() == null ? runtime.getNil() : RubyString.newString(runtime, mse.getAnchor());
                    tag2 = mse.getTag() == null ? runtime.getNil() : RubyString.newString(runtime, mse.getTag());
                    implicit = runtime.newBoolean(mse.getImplicit());
                    style = runtime.newFixnum(PsychParser.translateFlowStyle(mse.getFlowStyle()));
                    anchor.setTaint(tainted);
                    tag2.setTaint(tainted);
                    RuntimeHelpers.invoke(context, handler, "start_mapping", anchor, tag2, implicit, style);
                    continue;
                }
                if (this.event.is(Event.ID.MappingEnd)) {
                    RuntimeHelpers.invoke(context, handler, "end_mapping");
                    continue;
                }
                if (this.event.is(Event.ID.StreamEnd)) break;
            }
            RuntimeHelpers.invoke(context, handler, "end_stream");
        }
        catch (ParserException pe) {
            this.parser = null;
            RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{runtime.getModule("Psych").getConstant("SyntaxError"), runtime.newString(PsychParser.syntaxError(context, yaml, pe))}, Block.NULL_BLOCK);
        }
        catch (ScannerException se) {
            this.parser = null;
            StringBuilder message2 = new StringBuilder("syntax error");
            if (se.getProblemMark() != null) {
                message2.append(se.getProblemMark().toString());
            }
            throw runtime.newArgumentError(message2.toString());
        }
        catch (ReaderException re) {
            this.parser = null;
            RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{runtime.getModule("Psych").getConstant("SyntaxError"), runtime.newString(re.getLocalizedMessage())}, Block.NULL_BLOCK);
        }
        catch (Throwable t) {
            UnsafeFactory.getUnsafe().throwException(t);
            return this;
        }
        return this;
    }

    private static String syntaxError(ThreadContext context, IRubyObject yaml, MarkedYAMLException mye) {
        String path2 = yaml.respondsTo("path") ? yaml.callMethod(context, "path").toString() : "<unknown>";
        return path2 + ": couldn't parse YAML at line " + mye.getProblemMark().getLine() + " column " + mye.getProblemMark().getColumn();
    }

    private static int translateStyle(Character style) {
        if (style == null) {
            return 0;
        }
        switch (style.charValue()) {
            case '\u0000': {
                return 1;
            }
            case '\'': {
                return 2;
            }
            case '\"': {
                return 3;
            }
            case '|': {
                return 4;
            }
            case '>': {
                return 5;
            }
        }
        return 0;
    }

    private static int translateFlowStyle(Boolean flowStyle) {
        if (flowStyle == null) {
            return 0;
        }
        if (flowStyle.booleanValue()) {
            return 2;
        }
        return 1;
    }

    @JRubyMethod
    public IRubyObject mark(ThreadContext context) {
        Ruby runtime = context.runtime;
        Event event = null;
        if (this.parser != null && (event = this.parser.peekEvent()) == null) {
            event = this.event;
        }
        if (event == null) {
            return ((RubyClass)context.runtime.getClassFromPath("Psych::Parser::Mark")).newInstance(context, runtime.newFixnum(0), runtime.newFixnum(0), runtime.newFixnum(0), Block.NULL_BLOCK);
        }
        Mark mark2 = event.getStartMark();
        return ((RubyClass)context.runtime.getClassFromPath("Psych::Parser::Mark")).newInstance(context, runtime.newFixnum(mark2.getIndex()), runtime.newFixnum(mark2.getLine()), runtime.newFixnum(mark2.getColumn()), Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"external_encoding="})
    public IRubyObject external_encoding_set(ThreadContext context, IRubyObject encoding2) {
        return encoding2;
    }
}

