/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyDSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 2359742219218350277L;
    private static ObjectAllocator PKEYDSA_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKeyDSA(runtime, klass);
        }
    };
    private DSAPrivateKey privKey;
    private DSAPublicKey pubKey;
    private BigInteger[] specValues;
    private static final int SPEC_Y = 0;
    private static final int SPEC_P = 1;
    private static final int SPEC_Q = 2;
    private static final int SPEC_G = 3;

    public static void createPKeyDSA(Ruby runtime, RubyModule mPKey) {
        RubyClass cDSA = mPKey.defineClassUnder("DSA", mPKey.getClass("PKey"), PKEYDSA_ALLOCATOR);
        RubyClass pkeyError = mPKey.getClass("PKeyError");
        mPKey.defineClassUnder("DSAError", pkeyError, pkeyError.getAllocator());
        cDSA.defineAnnotatedMethods(PKeyDSA.class);
    }

    public static RaiseException newDSAError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::PKey::DSAError", message2);
    }

    public PKeyDSA(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    PublicKey getPublicKey() {
        return this.pubKey;
    }

    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    String getAlgorithm() {
        return "DSA";
    }

    @JRubyMethod(name={"generate"}, meta=true)
    public static IRubyObject generate(IRubyObject recv2, IRubyObject arg2) {
        int keysize = RubyNumeric.fix2int(arg2);
        PKeyDSA dsa = new PKeyDSA(recv2.getRuntime(), (RubyClass)recv2);
        PKeyDSA.dsaGenerate(dsa, keysize);
        return dsa;
    }

    private static void dsaGenerate(PKeyDSA dsa, int keysize) throws RaiseException {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
            gen.initialize(keysize, new SecureRandom());
            KeyPair pair = gen.generateKeyPair();
            dsa.privKey = (DSAPrivateKey)pair.getPrivate();
            dsa.pubKey = (DSAPublicKey)pair.getPublic();
        }
        catch (Exception e) {
            throw PKeyDSA.newDSAError(dsa.getRuntime(), e.getMessage());
        }
    }

    @JRubyMethod(rest=true)
    public IRubyObject initialize(IRubyObject[] args2) {
        IRubyObject pass2 = null;
        char[] passwd2 = null;
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 0, 2) == 0) {
            this.privKey = null;
            this.pubKey = null;
        } else {
            IRubyObject arg2 = args2[0];
            if (args2.length > 1) {
                pass2 = args2[1];
            }
            if (arg2 instanceof RubyFixnum) {
                int keysize = RubyNumeric.fix2int(arg2);
                PKeyDSA.dsaGenerate(this, keysize);
            } else {
                if (pass2 != null && !pass2.isNil()) {
                    passwd2 = pass2.toString().toCharArray();
                }
                arg2 = OpenSSLImpl.to_der_if_possible(arg2);
                RubyString str = arg2.convertToString();
                Serializable val = null;
                KeyFactory fact = null;
                try {
                    fact = KeyFactory.getInstance("DSA");
                }
                catch (NoSuchAlgorithmException e) {
                    throw this.getRuntime().newLoadError("unsupported key algorithm (DSA)");
                }
                if (null == val) {
                    try {
                        val = PEMInputOutput.readDSAPrivateKey(new StringReader(str.toString()), passwd2);
                    }
                    catch (NoClassDefFoundError e) {
                        val = null;
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = PEMInputOutput.readDSAPublicKey(new StringReader(str.toString()), passwd2);
                    }
                    catch (NoClassDefFoundError e) {
                        val = null;
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = PEMInputOutput.readDSAPubKey(new StringReader(str.toString()), passwd2);
                    }
                    catch (NoClassDefFoundError e) {
                        val = null;
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = PKey.readDSAPrivateKey(str.getBytes());
                    }
                    catch (NoClassDefFoundError e) {
                        val = null;
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = PKey.readDSAPublicKey(str.getBytes());
                    }
                    catch (NoClassDefFoundError e) {
                        val = null;
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = fact.generatePrivate(new PKCS8EncodedKeySpec(str.getBytes()));
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    try {
                        val = fact.generatePublic(new X509EncodedKeySpec(str.getBytes()));
                    }
                    catch (Exception e) {
                        val = null;
                    }
                }
                if (null == val) {
                    throw PKeyDSA.newDSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
                }
                if (val instanceof KeyPair) {
                    this.privKey = (DSAPrivateKey)((KeyPair)val).getPrivate();
                    this.pubKey = (DSAPublicKey)((KeyPair)val).getPublic();
                } else if (val instanceof DSAPrivateKey) {
                    this.privKey = (DSAPrivateKey)val;
                } else if (val instanceof DSAPublicKey) {
                    this.pubKey = (DSAPublicKey)val;
                    this.privKey = null;
                } else {
                    throw PKeyDSA.newDSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
                }
            }
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"})
    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            byte[] bytes2 = PKey.toDerDSAKey(this.pubKey, this.privKey);
            return RubyString.newString(this.getRuntime(), bytes2);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject to_text() {
        StringBuilder result2 = new StringBuilder();
        if (this.privKey != null) {
            int len = this.privKey.getParams().getP().bitLength();
            result2.append("Private-Key: (").append(len).append(" bit)").append("\n");
            result2.append("priv:");
            PKeyDSA.addSplittedAndFormatted(result2, this.privKey.getX());
        }
        result2.append("pub:");
        PKeyDSA.addSplittedAndFormatted(result2, this.pubKey.getY());
        result2.append("P:");
        PKeyDSA.addSplittedAndFormatted(result2, this.pubKey.getParams().getP());
        result2.append("Q:");
        PKeyDSA.addSplittedAndFormatted(result2, this.pubKey.getParams().getQ());
        result2.append("G:");
        PKeyDSA.addSplittedAndFormatted(result2, this.pubKey.getParams().getG());
        return this.getRuntime().newString(result2.toString());
    }

    @JRubyMethod
    public IRubyObject public_key() {
        PKeyDSA val = new PKeyDSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    @JRubyMethod(name={"export", "to_pem", "to_s"}, rest=true)
    public IRubyObject export(IRubyObject[] args2) {
        StringWriter w = new StringWriter();
        Arity.checkArgumentCount(this.getRuntime(), args2, 0, 2);
        char[] passwd2 = null;
        String algo = null;
        if (args2.length > 0 && !args2[0].isNil()) {
            algo = ((Cipher)args2[0]).getAlgorithm();
            if (args2.length > 1 && !args2[1].isNil()) {
                passwd2 = args2[1].toString().toCharArray();
            }
        }
        try {
            if (this.privKey != null) {
                PEMInputOutput.writeDSAPrivateKey(w, this.privKey, algo, passwd2);
            } else {
                PEMInputOutput.writeDSAPublicKey(w, this.pubKey);
            }
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject syssign(IRubyObject arg2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject sysverify(IRubyObject arg2, IRubyObject arg22) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p"})
    public synchronized IRubyObject get_p() {
        BigInteger param;
        DSAKey key2 = this.pubKey;
        if (key2 != null || (key2 = this.privKey) != null) {
            BigInteger param2 = key2.getParams().getP();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[1]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(IRubyObject p2) {
        return this.setKeySpecComponent(1, p2);
    }

    @JRubyMethod(name={"q"})
    public synchronized IRubyObject get_q() {
        BigInteger param;
        DSAKey key2 = this.pubKey;
        if (key2 != null || (key2 = this.privKey) != null) {
            BigInteger param2 = key2.getParams().getQ();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[2]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(IRubyObject q) {
        return this.setKeySpecComponent(2, q);
    }

    @JRubyMethod(name={"g"})
    public synchronized IRubyObject get_g() {
        BigInteger param;
        DSAKey key2 = this.pubKey;
        if (key2 != null || (key2 = this.privKey) != null) {
            BigInteger param2 = key2.getParams().getG();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[3]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"g="})
    public synchronized IRubyObject set_g(IRubyObject g) {
        return this.setKeySpecComponent(3, g);
    }

    @JRubyMethod(name={"pub_key"})
    public synchronized IRubyObject get_pub_key() {
        BigInteger param;
        DSAPublicKey key2 = this.pubKey;
        if (key2 != null) {
            return BN.newBN(this.getRuntime(), key2.getY());
        }
        if (this.specValues != null && (param = this.specValues[0]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pub_key="})
    public synchronized IRubyObject set_pub_key(IRubyObject pub_key) {
        return this.setKeySpecComponent(0, pub_key);
    }

    private IRubyObject setKeySpecComponent(int index2, IRubyObject value2) {
        BigInteger[] vals;
        block10: {
            block9: {
                if (this.pubKey != null || this.privKey != null) break block9;
                vals = this.specValues;
                if (this.specValues == null || vals[index2] == null) break block10;
            }
            throw PKeyDSA.newDSAError(this.getRuntime(), "illegal modification");
        }
        BigInteger bival = BN.getBigInteger(value2);
        if (vals != null) {
            vals[index2] = bival;
            int i2 = vals.length;
            while (--i2 >= 0) {
                if (vals[i2] != null) continue;
                return value2;
            }
            DSAPublicKeySpec spec = new DSAPublicKeySpec(vals[0], vals[1], vals[2], vals[3]);
            try {
                this.pubKey = (DSAPublicKey)KeyFactory.getInstance("DSA").generatePublic(spec);
            }
            catch (InvalidKeySpecException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "invalid keyspec");
            }
            catch (NoSuchAlgorithmException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "unsupported key algorithm (DSA)");
            }
            this.specValues = null;
        } else {
            this.specValues = new BigInteger[4];
            this.specValues[index2] = bival;
        }
        return value2;
    }
}

