/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.dyn.Coroutine;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.anno.JRubyClass;
import org.jruby.exceptions.JumpException;
import org.jruby.ext.fiber.CoroutineFiberState;
import org.jruby.ext.fiber.Fiber;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Fiber"})
public class CoroutineFiber
extends Fiber {
    private volatile IRubyObject slot;
    private CoroutineFiberState state;
    private CoroutineFiber lastFiber;
    private Coroutine coro;
    private ThreadContext context;
    private JumpException coroException;

    public CoroutineFiber(Ruby runtime, RubyClass type2, Coroutine coro) {
        super(runtime, type2);
        this.root = coro != null;
        this.coro = coro;
        assert (this.root ^ runtime.getCurrentContext().getFiber() != null);
    }

    protected void initFiber(ThreadContext context) {
        Ruby runtime = context.runtime;
        this.slot = runtime.getNil();
        this.context = this.root ? context : ThreadContext.newContext(runtime);
        this.context.setFiber(this);
        this.context.setThread(context.getThread());
        this.state = CoroutineFiberState.SUSPENDED_YIELD;
        if (this.coro == null) {
            this.coro = new Coroutine(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void run() {
                    try {
                        try {
                            CoroutineFiber.this.slot = CoroutineFiber.this.block.yieldArray(CoroutineFiber.this.context, CoroutineFiber.this.slot, null, null);
                        }
                        catch (JumpException t) {
                            CoroutineFiber.this.coroException = t;
                            Object var3_2 = null;
                            CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                            return;
                        }
                        Object var3_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                        throw throwable;
                    }
                    CoroutineFiber.this.state = CoroutineFiberState.FINISHED;
                }
            };
        }
    }

    protected IRubyObject resumeOrTransfer(ThreadContext context, IRubyObject arg2, boolean transfer2) {
        CoroutineFiber current2 = (CoroutineFiber)context.getFiber();
        Ruby runtime = context.runtime;
        this.slot = arg2;
        if (context.getThread() != this.parent) {
            throw context.runtime.newFiberError("resuming fiber from different thread: " + this);
        }
        switch (this.state) {
            case SUSPENDED_YIELD: {
                if (transfer2) {
                    current2.state = CoroutineFiberState.SUSPENDED_TRANSFER;
                } else {
                    current2.state = CoroutineFiberState.SUSPENDED_RESUME;
                    this.lastFiber = (CoroutineFiber)context.getFiber();
                }
                this.state = CoroutineFiberState.RUNNING;
                runtime.getThreadService().setCurrentContext(context);
                context.setThread(context.getThread());
                Coroutine.yieldTo((Coroutine)this.coro);
                break;
            }
            case SUSPENDED_TRANSFER: {
                if (!transfer2) {
                    throw runtime.newFiberError("double resume");
                }
                current2.state = CoroutineFiberState.SUSPENDED_TRANSFER;
                this.state = CoroutineFiberState.RUNNING;
                runtime.getThreadService().setCurrentContext(context);
                context.setThread(context.getThread());
                Coroutine.yieldTo((Coroutine)this.coro);
                break;
            }
            case FINISHED: {
                throw runtime.newFiberError("dead fiber called");
            }
            default: {
                throw runtime.newFiberError("fiber in an invalid state: " + (Object)((Object)this.state));
            }
        }
        try {
            if (this.coroException != null) {
                throw this.coroException;
            }
        }
        catch (JumpException.RetryJump rtry) {
            context.getThread().raise(new IRubyObject[]{runtime.newSyntaxError("Invalid retry").getException()}, Block.NULL_BLOCK);
        }
        catch (JumpException.BreakJump brk) {
            context.getThread().raise(new IRubyObject[]{runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, runtime.getNil(), "break from proc-closure").getException()}, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump ret) {
            context.getThread().raise(new IRubyObject[]{runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, runtime.getNil(), "unexpected return").getException()}, Block.NULL_BLOCK);
        }
        context.pollThreadEvents();
        return this.slot;
    }

    public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
        assert (!this.root);
        if (this.lastFiber.state != CoroutineFiberState.SUSPENDED_RESUME) {
            if (this.lastFiber.state == CoroutineFiberState.SUSPENDED_TRANSFER) {
                throw context.getRuntime().newFiberError("a Fiber that was transferred to cannot yield");
            }
            throw context.getRuntime().newFiberError("invalid state of last Fiber at yield: " + (Object)((Object)this.lastFiber.state));
        }
        this.slot = arg2;
        this.state = CoroutineFiberState.SUSPENDED_YIELD;
        this.lastFiber.state = CoroutineFiberState.RUNNING;
        context.getRuntime().getThreadService().setCurrentContext(this.lastFiber.context);
        ThreadContext o = this.lastFiber.context;
        this.lastFiber.context.setThread(context.getThread());
        Coroutine.yieldTo((Coroutine)this.lastFiber.coro);
        context.pollThreadEvents();
        return this.slot;
    }

    public boolean isAlive() {
        return this.state != CoroutineFiberState.FINISHED;
    }
}

