/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.TypeSizeMapper;

public class FFI {
    public final RubyModule ffiModule;
    public final RubyClass memoryClass;
    public final RubyClass bufferClass;
    public final RubyClass pointerClass;
    public final RubyClass memptrClass;
    public final RubyClass structClass;
    public final RubyClass functionClass;
    public final RubyClass callbackClass;
    public final RubyClass typeClass;
    public final RubyHash typedefs;
    private final NullMemoryIO nullMemoryIO;
    private final TypeSizeMapper sizeMapper;

    public FFI(RubyModule ffiModule) {
        this.ffiModule = ffiModule;
        this.bufferClass = ffiModule.getClass("Buffer");
        this.pointerClass = ffiModule.getClass("Pointer");
        this.memptrClass = ffiModule.getClass("MemoryPointer");
        this.memoryClass = ffiModule.getClass("AbstractMemory");
        this.structClass = ffiModule.getClass("Struct");
        this.functionClass = ffiModule.getClass("Function");
        this.callbackClass = ffiModule.getClass("Callback");
        this.typeClass = ffiModule.getClass("Type");
        this.typedefs = (RubyHash)ffiModule.getConstant("TypeDefs");
        this.sizeMapper = new TypeSizeMapper(this);
        this.nullMemoryIO = new NullMemoryIO(ffiModule.getRuntime());
    }

    public TypeSizeMapper getSizeMapper() {
        return this.sizeMapper;
    }

    public NullMemoryIO getNullMemoryIO() {
        return this.nullMemoryIO;
    }
}

