/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.NoFunctionalitySignalFacade;
import org.jruby.util.SignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNALS = RubySignal.getSignalFacade();

    private static final SignalFacade getSignalFacade() {
        try {
            Class<?> realFacadeClass = Class.forName("org.jruby.util.SunSignalFacade");
            return (SignalFacade)realFacadeClass.newInstance();
        }
        catch (Throwable e) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby runtime) {
        RubyModule mSignal = runtime.defineModule("Signal");
        mSignal.defineAnnotatedMethods(RubySignal.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        RubyHash names2 = RubyHash.newHash(runtime);
        for (Signal s2 : Signal.values()) {
            if (!s2.description().startsWith("SIG")) continue;
            long longValue = s2.longValue();
            if (s2 == Signal.SIGCLD) {
                longValue = Signal.SIGCHLD.longValue();
            }
            if (longValue >= 20000L) continue;
            names2.op_aset(context, runtime.newString(s2.description().substring("SIG".length())), runtime.newFixnum(longValue));
        }
        names2.op_aset(context, runtime.newString("EXIT"), runtime.newFixnum(0));
        return names2;
    }

    @JRubyMethod(name={"__jtrap_kernel"}, required=2, module=true)
    public static IRubyObject __jtrap_kernel(IRubyObject recv2, IRubyObject block, IRubyObject sig) {
        return SIGNALS.trap(recv2, block, sig);
    }

    @JRubyMethod(name={"__jtrap_platform_kernel"}, required=1, module=true)
    public static IRubyObject __jtrap_platform_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.restorePlatformDefault(recv2, sig);
    }

    @JRubyMethod(name={"__jtrap_osdefault_kernel"}, required=1, module=true)
    public static IRubyObject __jtrap_osdefault_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.restoreOSDefault(recv2, sig);
    }

    @JRubyMethod(name={"__jtrap_ignore_kernel"}, required=1, module=true)
    public static IRubyObject __jtrap_restore_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.ignore(recv2, sig);
    }
}

