/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Random;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Random"})
public class RubyRandom
extends RubyObject {
    private static final int DEFAULT_SEED_CNT = 4;
    private static ObjectAllocator RANDOM_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyRandom(runtime, klass);
        }
    };
    private RandomType random = null;

    static int getIntBigIntegerBuffer(byte[] src, int loc) {
        int v = 0;
        int idx = src.length - loc * 4 - 1;
        if (idx >= 0) {
            v |= src[idx--] & 0xFF;
            if (idx >= 0) {
                v |= (src[idx--] & 0xFF) << 8;
                if (idx >= 0) {
                    v |= (src[idx--] & 0xFF) << 16;
                    if (idx >= 0) {
                        v |= (src[idx--] & 0xFF) << 24;
                    }
                }
            }
        }
        return v;
    }

    static void setIntBigIntegerBuffer(byte[] dest, int loc, int value2) {
        int idx = dest.length - loc * 4 - 1;
        if (idx >= 0) {
            dest[idx--] = (byte)(value2 & 0xFF);
            if (idx >= 0) {
                dest[idx--] = (byte)(value2 >> 8 & 0xFF);
                if (idx >= 0) {
                    dest[idx--] = (byte)(value2 >> 16 & 0xFF);
                    if (idx >= 0) {
                        dest[idx--] = (byte)(value2 >> 24 & 0xFF);
                    }
                }
            }
        }
    }

    public static RubyBignum randomSeed(Ruby runtime) {
        byte[] seed2 = new byte[16];
        runtime.getRandom().nextBytes(seed2);
        return RubyBignum.newBignum(runtime, new BigInteger(seed2).abs());
    }

    public static RubyClass createRandomClass(Ruby runtime) {
        RubyClass randomClass = runtime.defineClass("Random", runtime.getObject(), RANDOM_ALLOCATOR);
        randomClass.defineAnnotatedMethods(RubyRandom.class);
        RubyRandom defaultRand = new RubyRandom(runtime, randomClass);
        defaultRand.random = new RandomType(RubyRandom.randomSeed(runtime));
        randomClass.setConstant("DEFAULT", defaultRand);
        runtime.setDefaultRand(defaultRand.random);
        runtime.setRandomClass(randomClass);
        return randomClass;
    }

    RubyRandom(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.random = new RandomType(args2.length == 0 ? RubyRandom.randomSeed(context.runtime) : args2[0]);
        return this;
    }

    @JRubyMethod(name={"seed"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject seed(ThreadContext context) {
        return this.random.getSeed();
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject orig) {
        if (!(orig instanceof RubyRandom)) {
            throw this.getRuntime().newTypeError(String.format("wrong argument type %s (expected %s)", orig.getMetaClass().getName(), this.getMetaClass().getName()));
        }
        this.random = new RandomType(((RubyRandom)orig).random);
        return this;
    }

    @JRubyMethod(name={"rand"}, meta=true, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyRandom.randCommon19(context, recv2, args2);
    }

    public static IRubyObject randCommon19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (args2.length == 0) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject arg2 = args2[0];
        if (arg2.isNil()) {
            return RubyRandom.randFloat(context, random);
        }
        RubyInteger max2 = arg2.convertToInteger();
        return RubyRandom.randCommon(context, random, max2);
    }

    public static IRubyObject randCommon18(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RandomType random = RubyRandom.getDefaultRand(context);
        if (args2.length == 0) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject arg2 = args2[0];
        if (arg2.isNil()) {
            return RubyRandom.randFloat(context, random);
        }
        RubyInteger max2 = (RubyInteger)RubyKernel.new_integer(context, recv2, arg2);
        return RubyRandom.randCommon(context, random, max2);
    }

    private static IRubyObject randCommon(ThreadContext context, RandomType random, RubyInteger max2) {
        if (max2.zero_p(context).isTrue()) {
            return RubyRandom.randFloat(context, random);
        }
        IRubyObject r = RubyRandom.randInt(context, random, max2, false);
        if (r.isNil()) {
            return RubyRandom.randFloat(context, random);
        }
        return r;
    }

    @JRubyMethod(name={"rand"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject randObj(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            return RubyRandom.randFloat(context, this.random);
        }
        return RubyRandom.randomRand(context, args2[0], this.random);
    }

    private static IRubyObject randInt(ThreadContext context, RandomType random, RubyInteger vmax, boolean restrictive) {
        if (vmax instanceof RubyFixnum) {
            long max2 = RubyNumeric.fix2long(vmax);
            if (max2 == 0L) {
                return context.nil;
            }
            if (max2 < 0L) {
                if (restrictive) {
                    return context.nil;
                }
                max2 = -max2;
            }
            return RubyRandom.randLimitedFixnum(context, random, max2 - 1L);
        }
        BigInteger big = vmax.getBigIntegerValue();
        if (big.equals(BigInteger.ZERO)) {
            return context.nil;
        }
        if (big.signum() < 0) {
            if (restrictive) {
                return context.nil;
            }
            big = big.abs();
        }
        big = big.subtract(BigInteger.ONE);
        return RubyRandom.randLimitedBignum(context, random, RubyBignum.newBignum(context.runtime, big));
    }

    public static RubyFloat randFloat(ThreadContext context, RandomType random) {
        return context.runtime.newFloat(random.genrandReal());
    }

    private static IRubyObject randLimitedFixnum(ThreadContext context, RandomType random, long limit2) {
        long val;
        if (limit2 == 0L) {
            val = 0L;
        } else {
            long mask = RubyRandom.makeMask(limit2);
            block0: while (true) {
                val = 0L;
                for (int i2 = 1; 0 <= i2; --i2) {
                    if ((mask >>> i2 * 32 & 0xFFFFFFFFL) != 0L) {
                        val |= ((long)random.genrandInt32() & 0xFFFFFFFFL) << i2 * 32;
                        val &= mask;
                    }
                    if (limit2 < val) continue block0;
                }
                break;
            }
        }
        return context.runtime.newFixnum(val);
    }

    private static IRubyObject randLimitedBignum(ThreadContext context, RandomType random, RubyBignum limit2) {
        byte[] buf = limit2.getBigIntegerValue().toByteArray();
        byte[] bytes2 = new byte[buf.length];
        int len = (buf.length + 3) / 4;
        block0: while (true) {
            long mask = 0L;
            boolean boundary = true;
            for (int idx = len - 1; 0 <= idx; --idx) {
                long rnd;
                long lim = (long)RubyRandom.getIntBigIntegerBuffer(buf, idx) & 0xFFFFFFFFL;
                long l = mask = mask != 0L ? 0xFFFFFFFFL : RubyRandom.makeMask(lim);
                if (mask != 0L) {
                    rnd = (long)random.genrandInt32() & 0xFFFFFFFFL & mask;
                    if (boundary) {
                        if (lim < rnd) continue block0;
                        if (rnd < lim) {
                            boundary = false;
                        }
                    }
                } else {
                    rnd = 0L;
                }
                RubyRandom.setIntBigIntegerBuffer(bytes2, idx, (int)rnd);
            }
            break;
        }
        return RubyBignum.newBignum(context.runtime, new BigInteger(bytes2));
    }

    private static long makeMask(long x) {
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        x |= x >>> 32;
        return x;
    }

    private static RandomType getDefaultRand(ThreadContext context) {
        return context.runtime.getDefaultRand();
    }

    private static IRubyObject randomRand(ThreadContext context, IRubyObject vmax, RandomType random) {
        IRubyObject f;
        IRubyObject v = null;
        RangeLike range = null;
        if (vmax.isNil()) {
            v = context.nil;
        } else {
            v = RubyRandom.checkMaxInt(context, vmax);
            if (v != null) {
                v = RubyRandom.randInt(context, random, (RubyInteger)v, true);
            } else {
                v = TypeConverter.checkFloatType(context.runtime, vmax);
                if (!v.isNil()) {
                    double max2 = RubyRandom.floatValue(v);
                    v = max2 > 0.0 ? context.runtime.newFloat(max2 * random.genrandReal()) : context.nil;
                } else {
                    range = RubyRandom.rangeValues(context, vmax);
                    if (range != null) {
                        v = RubyRandom.checkMaxInt(context, range.range);
                        if (v != null) {
                            if (v instanceof RubyFixnum) {
                                long max3 = ((RubyFixnum)v).getLongValue();
                                if (range.excl) {
                                    --max3;
                                }
                                v = max3 >= 0L ? RubyRandom.randLimitedFixnum(context, random, max3) : context.nil;
                            } else if (v instanceof RubyBignum) {
                                BigInteger big = ((RubyBignum)v).getBigIntegerValue();
                                if (!big.equals(BigInteger.ZERO) && big.signum() > 0) {
                                    if (range.excl) {
                                        big = big.subtract(BigInteger.ONE);
                                    }
                                    v = RubyRandom.randLimitedBignum(context, random, RubyBignum.newBignum(context.runtime, big));
                                } else {
                                    v = context.nil;
                                }
                            } else {
                                v = context.nil;
                            }
                        } else {
                            v = TypeConverter.checkFloatType(context.runtime, range.range);
                            if (!v.isNil()) {
                                int scale = 1;
                                double max4 = ((RubyFloat)v).getDoubleValue();
                                double mid = 0.5;
                                double r = 0.0;
                                if (Double.isInfinite(max4)) {
                                    double min2 = RubyRandom.floatValue(range.begin) / 2.0;
                                    max4 = RubyRandom.floatValue(range.end) / 2.0;
                                    scale = 2;
                                    mid = max4 + min2;
                                    max4 -= min2;
                                } else {
                                    RubyRandom.floatValue(v);
                                }
                                v = context.nil;
                                if (max4 > 0.0) {
                                    r = range.excl ? random.genrandReal() : random.genrandReal2();
                                    if (scale > 1) {
                                        return context.runtime.newFloat((r - 0.5) * max4 * (double)scale + mid);
                                    }
                                    v = context.runtime.newFloat(r * max4);
                                } else if (max4 == 0.0 && !range.excl) {
                                    v = context.runtime.newFloat(0.0);
                                }
                            }
                        }
                    } else {
                        v = context.nil;
                        RubyNumeric.num2long(vmax);
                    }
                }
            }
        }
        if (v.isNil()) {
            throw context.runtime.newArgumentError("invalid argument - " + vmax.toString());
        }
        if (range == null) {
            return v;
        }
        if (range.begin instanceof RubyFixnum && v instanceof RubyFixnum) {
            long x = ((RubyFixnum)range.begin).getLongValue() + ((RubyFixnum)v).getLongValue();
            return context.runtime.newFixnum(x);
        }
        if (v instanceof RubyBignum) {
            return ((RubyBignum)v).op_plus(context, range.begin);
        }
        if (v instanceof RubyFloat && !(f = TypeConverter.checkFloatType(context.runtime, range.begin)).isNil()) {
            return ((RubyFloat)v).op_plus(context, f);
        }
        return RuntimeHelpers.invoke(context, range.begin, "+", v);
    }

    private static double floatValue(IRubyObject v) {
        double x;
        if (v instanceof RubyFloat) {
            x = ((RubyFloat)v).getDoubleValue();
        } else if (v instanceof RubyNumeric) {
            x = ((RubyNumeric)v).convertToFloat().getDoubleValue();
        } else {
            throw v.getRuntime().newTypeError(v, v.getRuntime().getFloat());
        }
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw v.getRuntime().newErrnoEDOMError("Numerical argument out of domain");
        }
        return x;
    }

    private static IRubyObject checkMaxInt(ThreadContext context, IRubyObject vmax) {
        IRubyObject v;
        if (!(vmax instanceof RubyFloat) && !(v = TypeConverter.checkIntegerType(context.runtime, vmax, "to_int")).isNil()) {
            return v;
        }
        return null;
    }

    private static RangeLike rangeValues(ThreadContext context, IRubyObject range) {
        RangeLike like = new RangeLike();
        if (range instanceof RubyRange) {
            RubyRange vrange = (RubyRange)range;
            like.begin = vrange.first();
            like.end = vrange.last();
            like.excl = vrange.exclude_end_p().isTrue();
        } else {
            if (!(range.respondsTo("begin") && range.respondsTo("end") && range.respondsTo("exclude_end?"))) {
                return null;
            }
            like.begin = RuntimeHelpers.invoke(context, range, "begin");
            like.end = RuntimeHelpers.invoke(context, range, "end");
            like.excl = RuntimeHelpers.invoke(context, range, "exlucde_end?").isTrue();
        }
        like.range = RuntimeHelpers.invoke(context, like.end, "-", like.begin);
        return like;
    }

    @JRubyMethod(meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2);
    }

    @JRubyMethod(meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2, IRubyObject seed2) {
        return RubyRandom.srandCommon(context, recv2, seed2);
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2, RubyRandom.randomSeed(context.runtime));
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv2, IRubyObject newSeed2) {
        RandomType defaultRand = RubyRandom.getDefaultRand(context);
        IRubyObject previousSeed = defaultRand.getSeed();
        defaultRand = new RandomType(newSeed2);
        context.runtime.setDefaultRand(defaultRand);
        if (context.runtime.is1_9()) {
            ((RubyRandom)context.runtime.getRandomClass().getConstant("DEFAULT")).setRandomType(defaultRand);
        }
        return previousSeed;
    }

    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        if (!this.getType().equals(obj.getType())) {
            return context.runtime.getFalse();
        }
        return context.runtime.newBoolean(this.random.equals(((RubyRandom)obj).random));
    }

    @JRubyMethod(name={"state"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject stateObj(ThreadContext context) {
        return this.random.getState();
    }

    @JRubyMethod(name={"left"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject leftObj(ThreadContext context) {
        return RubyNumeric.int2fix(context.runtime, this.random.getLeft());
    }

    @JRubyMethod(name={"state"}, meta=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject state(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.getDefaultRand(context).getState();
    }

    @JRubyMethod(name={"left"}, meta=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject left(ThreadContext context, IRubyObject recv2) {
        return RubyNumeric.int2fix(context.runtime, RubyRandom.getDefaultRand(context).getLeft());
    }

    @JRubyMethod(name={"marshal_dump"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyBignum state2 = this.random.getState();
        RubyInteger left2 = (RubyInteger)RubyNumeric.int2fix(context.runtime, this.random.getLeft());
        RubyArray dump2 = context.getRuntime().newArray(state2, left2, this.random.getSeed());
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        if (load2.size() != 3) {
            throw context.runtime.newArgumentError("wrong dump data");
        }
        if (!(load2.eltInternal(0) instanceof RubyBignum)) {
            throw context.runtime.newTypeError(load2.eltInternal(0), context.runtime.getBignum());
        }
        RubyBignum state2 = (RubyBignum)load2.eltInternal(0);
        int left2 = RubyNumeric.num2int(load2.eltInternal(1));
        IRubyObject seed2 = load2.eltInternal(2);
        this.random = new RandomType(seed2, state2, left2);
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        return this;
    }

    @JRubyMethod(name={"bytes"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject bytes(ThreadContext context, IRubyObject arg2) {
        int i2;
        int r;
        int n;
        byte[] bytes2 = new byte[n];
        int idx = 0;
        for (n = RubyNumeric.num2int(arg2); n >= 4; n -= 4) {
            r = this.random.genrandInt32();
            for (i2 = 0; i2 < 4; ++i2) {
                bytes2[idx++] = (byte)(r & 0xFF);
                r >>>= 8;
            }
        }
        if (n > 0) {
            r = this.random.genrandInt32();
            for (i2 = 0; i2 < n; ++i2) {
                bytes2[idx++] = (byte)(r & 0xFF);
                r >>>= 8;
            }
        }
        return context.getRuntime().newString(new ByteList(bytes2));
    }

    public static double randomReal(ThreadContext context, IRubyObject obj) {
        RandomType random = null;
        if (obj.equals(context.runtime.getRandomClass())) {
            random = RubyRandom.getDefaultRand(context);
        }
        if (obj instanceof RubyRandom) {
            random = ((RubyRandom)obj).random;
        }
        if (random != null) {
            return random.genrandReal();
        }
        double d = RubyNumeric.num2dbl(RuntimeHelpers.invoke(context, obj, "rand"));
        if (d < 0.0 || d >= 1.0) {
            throw context.runtime.newRangeError("random number too big: " + d);
        }
        return d;
    }

    @JRubyMethod(name={"new_seed"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject newSeed(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.randomSeed(context.runtime);
    }

    private void setRandomType(RandomType random) {
        this.random = random;
    }

    static class RangeLike {
        public IRubyObject begin = null;
        public IRubyObject end = null;
        boolean excl = false;
        public IRubyObject range = null;

        RangeLike() {
        }
    }

    public static class RandomType {
        private final IRubyObject seed;
        private final Random mt;

        RandomType(Ruby runtime) {
            this(RubyRandom.randomSeed(runtime));
        }

        RandomType(IRubyObject vseed) {
            this.seed = vseed.convertToInteger();
            if (this.seed instanceof RubyFixnum) {
                long v = Math.abs(RubyNumeric.num2long(this.seed));
                if (v == (v & 0xFFFFFFFFL)) {
                    this.mt = new Random((int)v);
                } else {
                    int[] ints = new int[]{(int)v, (int)(v >> 32)};
                    this.mt = new Random(ints);
                }
            } else if (this.seed instanceof RubyBignum) {
                BigInteger big = ((RubyBignum)this.seed).getBigIntegerValue();
                if (big.signum() < 0) {
                    big = big.abs();
                }
                byte[] buf = big.toByteArray();
                int buflen = buf.length;
                if (buf[0] == 0) {
                    --buflen;
                }
                int len = Math.min((buflen + 3) / 4, Random.N);
                int[] ints = this.bigEndianToInts(buf, len);
                this.mt = len <= 1 ? new Random(ints[0]) : new Random(ints);
            } else {
                throw vseed.getRuntime().newTypeError(String.format("failed to convert %s into Integer", vseed.getMetaClass().getName()));
            }
        }

        RandomType(IRubyObject vseed, RubyBignum state2, int left2) {
            this.seed = vseed.convertToInteger();
            byte[] bytes2 = state2.getBigIntegerValue().toByteArray();
            int[] ints = new int[bytes2.length / 4];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                ints[i2] = RubyRandom.getIntBigIntegerBuffer(bytes2, i2);
            }
            this.mt = new Random(ints, left2);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RandomType)) {
                return false;
            }
            RandomType rhs = (RandomType)obj;
            return this.seed.op_equal(this.seed.getRuntime().getCurrentContext(), rhs.seed).isTrue() && this.mt.equals(rhs.mt);
        }

        public int hashCode() {
            return (629 + this.seed.hashCode()) * 37 + this.mt.hashCode();
        }

        RandomType(RandomType orig) {
            this.seed = orig.seed;
            this.mt = new Random(orig.mt);
        }

        int genrandInt32() {
            return this.mt.genrandInt32();
        }

        double genrandReal() {
            return this.mt.genrandReal();
        }

        double genrandReal2() {
            return this.mt.genrandReal2();
        }

        IRubyObject getSeed() {
            return this.seed;
        }

        RubyBignum getState() {
            int[] ints = this.mt.getState();
            byte[] bytes2 = new byte[ints.length * 4];
            for (int idx = 0; idx < ints.length; ++idx) {
                RubyRandom.setIntBigIntegerBuffer(bytes2, idx, ints[idx]);
            }
            return RubyBignum.newBignum(this.seed.getRuntime(), new BigInteger(bytes2));
        }

        int getLeft() {
            return this.mt.getLeft();
        }

        private int[] bigEndianToInts(byte[] buf, int initKeyLen) {
            int[] initKey = new int[initKeyLen];
            for (int idx = 0; idx < initKey.length; ++idx) {
                initKey[idx] = RubyRandom.getIntBigIntegerBuffer(buf, idx);
            }
            return initKey;
        }
    }
}

