/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.MethodInvoker;
import org.jruby.java.invokers.StaticFieldGetter;
import org.jruby.java.invokers.StaticFieldSetter;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProxy
extends RubyObject {
    private static final boolean DEBUG = false;
    private JavaObject javaObject;
    protected Object object;
    private static final String NONPERSISTENT_IVAR_MESSAGE = "instance vars on non-persistent Java type {0} (http://wiki.jruby.org/Persistence)";
    private static final String NONPERSISTENT_SINGLETON_MESSAGE = "singleton on non-persistent Java type {0} (http://wiki.jruby.org/Persistence)";

    public JavaProxy(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    public JavaProxy(Ruby runtime, RubyClass klazz, Object object) {
        super(runtime, klazz);
        this.object = object;
    }

    @Override
    public Object dataGetStruct() {
        this.lazyJavaObject();
        return this.javaObject;
    }

    @Override
    public void dataWrapStruct(Object object) {
        this.javaObject = (JavaObject)object;
        this.object = this.javaObject.getValue();
    }

    public Object getObject() {
        if (this.object == null) {
            if (this.javaObject == null) {
                throw this.getRuntime().newRuntimeError("Java wrapper with no contents: " + this.getMetaClass().getName());
            }
            this.object = this.javaObject.getValue();
        }
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    private void lazyJavaObject() {
        if (this.javaObject == null) {
            this.javaObject = JavaObject.wrap(this.getRuntime(), this.object);
        }
    }

    @Override
    public Class getJavaClass() {
        return this.object.getClass();
    }

    public static RubyClass createJavaProxy(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyClass javaProxy = runtime.defineClass("JavaProxy", runtime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new JavaProxy(runtime, klazz);
            }
        });
        RubyClass singleton = javaProxy.getSingletonClass();
        singleton.addReadWriteAttribute(context, "java_class");
        javaProxy.defineAnnotatedMethods(JavaProxy.class);
        javaProxy.includeModule(runtime.getModule("JavaProxyMethods"));
        return javaProxy;
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        IRubyObject subJavaClass = RuntimeHelpers.invoke(context, subclass, "java_class");
        if (subJavaClass.isNil()) {
            subJavaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
            RuntimeHelpers.invoke(context, subclass, "java_class=", subJavaClass);
        }
        return RuntimeHelpers.invokeSuper(context, recv2, subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return ((RubyClass)recv2).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject javaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
        if (args2.length > 0) {
            ArrayJavaProxyCreator ajpc = new ArrayJavaProxyCreator(context.runtime);
            ajpc.setup(context, javaClass, args2);
            return ajpc;
        }
        return Java.get_proxy_class(javaClass, RuntimeHelpers.invoke(context, javaClass, "array_class"));
    }

    @JRubyMethod(name={"__persistent__="}, meta=true)
    public static IRubyObject persistent(IRubyObject cls, IRubyObject value2) {
        ((RubyClass)cls).getRealClass().setCacheProxy(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"__persistent__"}, meta=true)
    public static IRubyObject persistent(ThreadContext context, IRubyObject cls) {
        return context.runtime.newBoolean(((RubyClass)cls).getRealClass().getCacheProxy());
    }

    @Override
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        this.setObject(((JavaProxy)original).object);
        return this;
    }

    private static Class<?> getJavaClass(ThreadContext context, RubyModule module) {
        try {
            IRubyObject jClass = RuntimeHelpers.invoke(context, module, "java_class");
            return !(jClass instanceof JavaClass) ? null : ((JavaClass)jClass).javaClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Map<String, String> getFieldListFromArgs(IRubyObject[] args2) {
        final HashMap<String, String> map = new HashMap<String, String>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2] instanceof RubyHash) {
                ((RubyHash)args2[i2]).visitAll(new RubyHash.Visitor(){

                    public void visit(IRubyObject key2, IRubyObject value2) {
                        map.put(key2.asString().toString(), value2.asString().toString());
                    }
                });
                continue;
            }
            String value2 = args2[i2].asString().toString();
            map.put(value2, value2);
        }
        return map;
    }

    private static void installField(ThreadContext context, Map<String, String> fieldMap, Field field2, RubyModule module, boolean asReader, boolean asWriter) {
        boolean isFinal = Modifier.isFinal(field2.getModifiers());
        Iterator<Map.Entry<String, String>> iter = fieldMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String key2 = entry.getKey();
            if (!key2.equals(field2.getName())) continue;
            if (Ruby.isSecurityRestricted() && !Modifier.isPublic(field2.getModifiers())) {
                throw context.runtime.newSecurityError("Cannot change accessibility on fields in a restricted mode: field '" + field2.getName() + "'");
            }
            String asName = entry.getValue();
            if (Modifier.isStatic(field2.getModifiers())) {
                if (asReader) {
                    module.getSingletonClass().addMethod(asName, new StaticFieldGetter(key2, module, field2));
                }
                if (asWriter) {
                    if (isFinal) {
                        throw context.runtime.newSecurityError("Cannot change final field '" + field2.getName() + "'");
                    }
                    module.getSingletonClass().addMethod(asName + "=", new StaticFieldSetter(key2, module, field2));
                }
            } else {
                if (asReader) {
                    module.addMethod(asName, new InstanceFieldGetter(key2, module, field2));
                }
                if (asWriter) {
                    if (isFinal) {
                        throw context.runtime.newSecurityError("Cannot change final field '" + field2.getName() + "'");
                    }
                    module.addMethod(asName + "=", new InstanceFieldSetter(key2, module, field2));
                }
            }
            iter.remove();
            break;
        }
    }

    private static void findFields(ThreadContext context, RubyModule topModule, IRubyObject[] args2, boolean asReader, boolean asWriter) {
        Map<String, String> fieldMap = JavaProxy.getFieldListFromArgs(args2);
        for (RubyModule module = topModule; module != null; module = module.getSuperClass()) {
            Class<?> javaClass = JavaProxy.getJavaClass(context, module);
            if (javaClass == null) continue;
            Field[] fields2 = JavaClass.getDeclaredFields(javaClass);
            for (int j = 0; j < fields2.length; ++j) {
                JavaProxy.installField(context, fieldMap, fields2[j], module, asReader, asWriter);
            }
        }
        if (!fieldMap.isEmpty()) {
            throw JavaClass.undefinedFieldError(context.runtime, topModule.getName(), fieldMap.keySet().iterator().next());
        }
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_accessor(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, true);
        return context.runtime.getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_reader(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, false);
        return context.runtime.getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_writer(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, false, true);
        return context.runtime.getNil();
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof JavaProxy) {
            boolean equal = this.getObject() == ((JavaProxy)other).getObject();
            return runtime.newBoolean(equal);
        }
        return runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        Ruby runtime = context.runtime;
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, new Class[0]));
        return method2.invokeDirect(this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime = context.runtime;
        if (argTypesAry.size() != 0) {
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime, argTypesClasses);
        }
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, new Class[0]));
        return method2.invokeDirect(this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime = context.runtime;
        if (argTypesAry.size() != 1) {
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime, argTypesClasses);
        }
        Class argTypeClass = (Class)argTypesAry.eltInternal(0).toJava(Class.class);
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, argTypeClass));
        return method2.invokeDirect(this.getObject(), arg0.toJava(argTypeClass));
    }

    @JRubyMethod(required=4, rest=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        String name2 = args2[0].asJavaString();
        RubyArray argTypesAry = args2[1].convertToArray();
        int argsLen = args2.length - 2;
        if (argTypesAry.size() != argsLen) {
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime, argTypesClasses);
        }
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
        Object[] argsAry = new Object[argsLen];
        for (int i2 = 0; i2 < argsLen; ++i2) {
            argsAry[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
        }
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, argTypesClasses));
        return method2.invokeDirect(this.getObject(), argsAry);
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        return this.getRubyMethod(name2, new Class[0]);
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
        return this.getRubyMethod(name2, argTypesClasses);
    }

    @JRubyMethod
    public IRubyObject marshal_dump() {
        if (Serializable.class.isAssignableFrom(this.object.getClass())) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.object);
                return this.getRuntime().newString(new ByteList(baos.toByteArray()));
            }
            catch (IOException ioe) {
                throw this.getRuntime().newTypeError("Java type is not serializable: " + ioe.getMessage());
            }
        }
        throw this.getRuntime().newTypeError("Java type is not serializable, cannot be marshaled " + this.getJavaClass());
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            JRubyObjectInputStream ois = new JRubyObjectInputStream(context.runtime, bais);
            this.object = ois.readObject();
            return this;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw context.runtime.newTypeError("Class not found unmarshaling Java type: " + cnfe.getLocalizedMessage());
        }
    }

    @Override
    protected int inspectHashCode() {
        return System.identityHashCode(this.object);
    }

    private Method getMethod(String name2, Class ... argTypes) {
        try {
            return this.getObject().getClass().getMethod(name2, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw JavaMethod.newMethodNotFoundError(this.getRuntime(), this.getObject().getClass(), name2 + CodegenUtils.prettyParams(argTypes), name2);
        }
    }

    private MethodInvoker getMethodInvoker(Method method2) {
        if (Modifier.isStatic(method2.getModifiers())) {
            return new StaticMethodInvoker(this.metaClass.getMetaClass(), method2);
        }
        return new InstanceMethodInvoker((RubyModule)this.metaClass, method2);
    }

    private RubyMethod getRubyMethod(String name2, Class ... argTypes) {
        Method jmethod = this.getMethod(name2, argTypes);
        if (Modifier.isStatic(jmethod.getModifiers())) {
            return RubyMethod.newMethod(this.metaClass.getSingletonClass(), CodegenUtils.prettyParams(argTypes), this.metaClass.getSingletonClass(), name2, this.getMethodInvoker(jmethod), this.getMetaClass());
        }
        return RubyMethod.newMethod(this.metaClass, CodegenUtils.prettyParams(argTypes), this.metaClass, name2, this.getMethodInvoker(jmethod), this);
    }

    @Override
    public Object toJava(Class type2) {
        Object obj = this.getObject();
        if (type2.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        return super.toJava(type2);
    }

    @Override
    public Object getVariable(int index2) {
        this.confirmCachedProxy(NONPERSISTENT_IVAR_MESSAGE);
        return super.getVariable(index2);
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.confirmCachedProxy(NONPERSISTENT_IVAR_MESSAGE);
        super.setVariable(index2, value2);
    }

    @Override
    public RubyClass getSingletonClass() {
        this.confirmCachedProxy(NONPERSISTENT_SINGLETON_MESSAGE);
        return super.getSingletonClass();
    }

    private void confirmCachedProxy(String message2) {
        RubyClass realClass = this.metaClass.getRealClass();
        if (!realClass.getCacheProxy()) {
            if (Java.OBJECT_PROXY_CACHE) {
                this.getRuntime().getWarnings().warnOnce(IRubyWarnings.ID.NON_PERSISTENT_JAVA_PROXY, MessageFormat.format(message2, realClass));
            } else {
                this.getRuntime().getWarnings().warn(MessageFormat.format(message2, realClass));
                realClass.setCacheProxy(true);
                this.getRuntime().getJavaSupport().getObjectProxyCache().put(this.getObject(), this);
            }
        }
    }

    public Object unwrap() {
        return this.getObject();
    }
}

