/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Instr {
    public static final Operand[] EMPTY_OPERANDS = new Operand[0];
    private final Operation operation;
    private boolean isDead;
    private boolean hasUnusedResult;

    public Instr(Operation operation) {
        this.operation = operation;
    }

    public String toString() {
        return "" + (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult ? "[DEAD-RESULT]" : "") + (this instanceof ResultInstr ? ((ResultInstr)((Object)this)).getResult() + " = " : "") + (Object)((Object)this.operation);
    }

    @Interp
    public Operation getOperation() {
        return this.operation;
    }

    public boolean hasSideEffects() {
        return this.operation.hasSideEffects();
    }

    public boolean canRaiseException() {
        return this.operation.canRaiseException();
    }

    public boolean transfersControl() {
        return this.operation.transfersControl();
    }

    public boolean canBeDeleted(IRScope s2) {
        if (this.hasSideEffects() || this.getOperation().isDebugOp() || this.getOperation().canRaiseException() || this.transfersControl()) {
            return false;
        }
        if (this instanceof ResultInstr) {
            Variable r = ((ResultInstr)((Object)this)).getResult();
            if (s2.bindingHasEscaped() && !r.getName().equals("%block")) {
                return !(r instanceof LocalVariable);
            }
            if (s2.usesEval() && r.getName().equals("%block")) {
                return false;
            }
            return !s2.usesZSuper() || !this.getOperation().isArgReceive();
        }
        return true;
    }

    public void markDead() {
        this.isDead = true;
    }

    @Interp
    public boolean isDead() {
        return this.isDead;
    }

    public void markUnusedResult() {
        this.hasUnusedResult = true;
    }

    public boolean hasUnusedResult() {
        return this.hasUnusedResult;
    }

    @Interp
    public abstract Operand[] getOperands();

    public List<Variable> getUsedVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Operand o : this.getOperands()) {
            o.addUsedVariables(vars);
        }
        return vars;
    }

    public void renameVars(Map<Operand, Operand> renameMap) {
        ResultInstr ri;
        Variable oldVar;
        Variable newVar;
        this.simplifyOperands(renameMap, true);
        if (this instanceof ResultInstr && (newVar = (Variable)renameMap.get(oldVar = (ri = (ResultInstr)((Object)this)).getResult())) != null) {
            ri.updateResult(newVar);
        }
    }

    public Instr cloneForInlining(InlinerInfo inlinerInfo) {
        throw new RuntimeException("cloneForInlining: Not implemented for: " + (Object)((Object)this.getOperation()));
    }

    public Instr cloneForInlinedScope(InlinerInfo ii) {
        return this.cloneForInlining(ii);
    }

    public Instr cloneForInlinedClosure(InlinerInfo ii) {
        return this.cloneForInlinedScope(ii);
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return this.cloneForInlining(ii);
    }

    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        if (this.getOperands() != EMPTY_OPERANDS) {
            System.out.println("simplifyOperands: Missing implementation for: " + (Object)((Object)this.getOperation()));
            throw new RuntimeException("simplifyOperands: Missing implementation for: " + (Object)((Object)this.getOperation()));
        }
    }

    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        return null;
    }

    @Interp
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    public void visit(IRVisitor visitor) {
        throw new RuntimeException(this.getClass().getSimpleName() + " has no compile logic");
    }
}

