/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.io;

import java.nio.channels.Channel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.io.FileDescriptorByteChannel;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"FFI::FileDescriptorIO"}, parent="IO")
public class FileDescriptorIO
extends RubyIO {
    public static final String CLASS_NAME = "FileDescriptorIO";

    public FileDescriptorIO(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public FileDescriptorIO(Ruby runtime, IRubyObject fd) {
        super(runtime, runtime.getModule("FFI").getClass(CLASS_NAME));
        try {
            ModeFlags modes = FileDescriptorIO.newModeFlags(runtime, ModeFlags.RDWR);
            this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), new ChannelDescriptor((Channel)new FileDescriptorByteChannel(this.getRuntime(), RubyNumeric.fix2int(fd)), modes)));
            this.openFile.setPipeStream(this.openFile.getMainStreamSafe());
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.getMainStreamSafe().setSync(true);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
    }

    public static RubyClass createFileDescriptorIOClass(Ruby runtime, RubyModule module) {
        RubyClass result2 = runtime.defineClassUnder(CLASS_NAME, runtime.getClass("IO"), Allocator.INSTANCE, module);
        result2.defineAnnotatedMethods(FileDescriptorIO.class);
        result2.defineAnnotatedConstants(FileDescriptorIO.class);
        return result2;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static FileDescriptorIO newInstance(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.runtime, fd);
    }

    @JRubyMethod(name={"wrap"}, required=1, meta=true)
    public static RubyIO wrap(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.runtime, fd);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new FileDescriptorIO(runtime, klass);
        }
    }
}

