/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnsureNode
extends Node {
    private final Node bodyNode;
    private final Node ensureNode;

    public EnsureNode(ISourcePosition position, Node bodyNode, Node ensureNode) {
        super(position);
        assert (bodyNode != null) : "bodyNode is not null";
        this.bodyNode = bodyNode;
        this.ensureNode = ensureNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ENSURENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitEnsureNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getEnsureNode() {
        return this.ensureNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.bodyNode, this.ensureNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.ensureNode != null) {
            try {
                IRubyObject iRubyObject = this.bodyNode.interpret(runtime, context, self, aBlock);
                return iRubyObject;
            }
            finally {
                this.ensureNode.interpret(runtime, context, self, aBlock);
            }
        }
        return this.bodyNode.interpret(runtime, context, self, aBlock);
    }
}

