/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.StrNode;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.DefinedMessage;

public abstract class DNode
extends ListNode {
    protected Encoding encoding;

    public DNode(ISourcePosition position) {
        this(position, (Encoding)null);
    }

    public DNode(ISourcePosition position, Encoding encoding2) {
        super(position);
        this.encoding = encoding2;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.buildDynamicString(runtime, context, self, aBlock);
    }

    public boolean is19() {
        return this.encoding != null;
    }

    public boolean isSameEncoding(StrNode strNode) {
        return strNode.getValue().getEncoding() == this.encoding;
    }

    protected RubyString allocateString(Ruby runtime) {
        RubyString string2 = RubyString.newString(runtime, new ByteList());
        if (this.is19()) {
            string2.setEncoding(this.encoding);
        }
        return string2;
    }

    public void appendToString(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, RubyString string2, Node node) {
        if (node instanceof StrNode) {
            StrNode strNode = (StrNode)node;
            if (!this.is19() || this.isSameEncoding(strNode)) {
                string2.getByteList().append(strNode.getValue());
            } else {
                string2.cat19(strNode.getValue(), strNode.getCodeRange());
            }
        } else if (node instanceof EvStrNode) {
            EvStrNode evStrNode = (EvStrNode)node;
            Node bodyNode = evStrNode.getBody();
            if (bodyNode == null) {
                return;
            }
            IRubyObject body = bodyNode.interpret(runtime, context, self, aBlock);
            RuntimeHelpers.shortcutAppend(string2, body);
        } else if (this.is19()) {
            string2.append19(node.interpret(runtime, context, self, aBlock));
        } else {
            string2.append(node.interpret(runtime, context, self, aBlock));
        }
    }

    public RubyString buildDynamicString(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyString string2 = this.allocateString(runtime);
        int size2 = this.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            this.appendToString(runtime, context, self, aBlock, string2, this.get(i2));
        }
        return string2;
    }

    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyString definition = super.definition(runtime, context, self, aBlock);
        return this.is19() && definition == null ? runtime.getDefinedMessage(DefinedMessage.EXPRESSION) : definition;
    }
}

