/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.symmetric;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEBlockCipher;
import org.bouncycastle.jce.provider.JCEKeyGenerator;
import org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator;
import org.bouncycastle.jce.provider.JDKAlgorithmParameters;

public final class CAST5 {
    private CAST5() {
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for CAST5 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = AlgorithmParameters.getInstance("CAST5", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception2.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters {
        private byte[] iv;
        private int keyLength = 128;

        protected byte[] engineGetEncoded() {
            byte[] byArray = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
            return byArray;
        }

        protected byte[] engineGetEncoded(String string2) throws IOException {
            if (this.isASN1FormatString(string2)) {
                return new CAST5CBCParameters(this.engineGetEncoded(), this.keyLength).getEncoded();
            }
            if (string2.equals("RAW")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == IvParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to CAST5 parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a CAST5 parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }

        protected void engineInit(byte[] byArray) throws IOException {
            this.iv = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] byArray, String string2) throws IOException {
            if (this.isASN1FormatString(string2)) {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
                CAST5CBCParameters cAST5CBCParameters = CAST5CBCParameters.getInstance(aSN1InputStream.readObject());
                this.keyLength = cAST5CBCParameters.getKeyLength();
                this.iv = cAST5CBCParameters.getIV();
                return;
            }
            if (string2.equals("RAW")) {
                this.engineInit(byArray);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "CAST5 Parameters";
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new CAST5Engine()), 64);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new CAST5Engine());
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            super("CAST5", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends HashMap {
        public Mappings() {
            this.put("AlgorithmParameters.CAST5", "org.bouncycastle.jce.provider.symmetric.CAST5$AlgParams");
            this.put("Alg.Alias.AlgorithmParameters.1.2.840.113533.7.66.10", "CAST5");
            this.put("AlgorithmParameterGenerator.CAST5", "org.bouncycastle.jce.provider.symmetric.CAST5$AlgParamGen");
            this.put("Alg.Alias.AlgorithmParameterGenerator.1.2.840.113533.7.66.10", "CAST5");
            this.put("Cipher.CAST5", "org.bouncycastle.jce.provider.symmetric.CAST5$ECB");
            this.put("Cipher.1.2.840.113533.7.66.10", "org.bouncycastle.jce.provider.symmetric.CAST5$CBC");
            this.put("KeyGenerator.CAST5", "org.bouncycastle.jce.provider.symmetric.CAST5$KeyGen");
            this.put("Alg.Alias.KeyGenerator.1.2.840.113533.7.66.10", "CAST5");
        }
    }
}

