/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsBlockCipher(TlsClientContext tlsClientContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest2, Digest digest3, int n) {
        this.context = tlsClientContext;
        this.encryptCipher = blockCipher;
        this.decryptCipher = blockCipher2;
        int n2 = 2 * n + digest2.getDigestSize() + digest3.getDigestSize() + blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        SecurityParameters securityParameters = tlsClientContext.getSecurityParameters();
        byte[] byArray = TlsUtils.PRF(securityParameters.masterSecret, "key expansion", TlsUtils.concat(securityParameters.serverRandom, securityParameters.clientRandom), n2);
        int n3 = 0;
        this.writeMac = new TlsMac(digest2, byArray, n3, digest2.getDigestSize());
        this.readMac = new TlsMac(digest3, byArray, n3 += digest2.getDigestSize(), digest3.getDigestSize());
        this.initCipher(true, blockCipher, byArray, n, n3 += digest3.getDigestSize(), n3 + n * 2);
        this.initCipher(false, blockCipher2, byArray, n, n3 += n, n3 + n + blockCipher.getBlockSize());
    }

    protected void initCipher(boolean bl, BlockCipher blockCipher, byte[] byArray, int n, int n2, int n3) {
        KeyParameter keyParameter = new KeyParameter(byArray, n2, n);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray, n3, blockCipher.getBlockSize());
        blockCipher.init(bl, parametersWithIV);
    }

    public byte[] encodePlaintext(short s2, byte[] byArray, int n, int n2) {
        int n3;
        int n4 = this.encryptCipher.getBlockSize();
        int n5 = n4 - (n2 + this.writeMac.getSize() + 1) % n4;
        int n6 = (255 - n5) / n4;
        int n7 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n6);
        int n8 = n5 + n7 * n4;
        int n9 = n2 + this.writeMac.getSize() + n8 + 1;
        byte[] byArray2 = new byte[n9];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = this.writeMac.calculateMac(s2, byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        int n10 = n2 + byArray3.length;
        for (n3 = 0; n3 <= n8; ++n3) {
            byArray2[n3 + n10] = (byte)n8;
        }
        for (n3 = 0; n3 < n9; n3 += n4) {
            this.encryptCipher.processBlock(byArray2, n3, byArray2, n3);
        }
        return byArray2;
    }

    public byte[] decodeCiphertext(short s2, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5 = this.readMac.getSize() + 1;
        int n6 = this.decryptCipher.getBlockSize();
        boolean bl = false;
        if (n2 < n5) {
            throw new TlsFatalAlert(50);
        }
        if (n2 % n6 != 0) {
            throw new TlsFatalAlert(21);
        }
        for (n4 = 0; n4 < n2; n4 += n6) {
            this.decryptCipher.processBlock(byArray, n4 + n, byArray, n4 + n);
        }
        n4 = n + n2 - 1;
        byte by = byArray[n4];
        int n7 = by & 0xFF;
        int n8 = n2 - n5;
        if (n7 > n8) {
            bl = true;
            n7 = 0;
        } else {
            n3 = 0;
            for (int j = n4 - n7; j < n4; ++j) {
                n3 = (byte)(n3 | byArray[j] ^ by);
            }
            if (n3 != 0) {
                bl = true;
                n7 = 0;
            }
        }
        n3 = n2 - n5 - n7;
        byte[] byArray2 = this.readMac.calculateMac(s2, byArray, n, n3);
        byte[] byArray3 = new byte[byArray2.length];
        System.arraycopy(byArray, n + n3, byArray3, 0, byArray2.length);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
            bl = true;
        }
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n, byArray4, 0, n3);
        return byArray4;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n) {
        int n2 = secureRandom.nextInt();
        int n3 = this.lowestBitSet(n2);
        return Math.min(n3, n);
    }

    protected int lowestBitSet(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 0;
        while ((n & 1) == 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }
}

