/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class ReceiveClosureInstr
extends Instr
implements ResultInstr {
    private Variable result;

    public ReceiveClosureInstr(Variable result2) {
        super(Operation.RECV_CLOSURE);
        assert (result2 != null) : "ReceiveClosureInstr result is null";
        this.result = result2;
    }

    public Operand[] getOperands() {
        return EMPTY_OPERANDS;
    }

    public Variable getResult() {
        return this.result;
    }

    public void updateResult(Variable v) {
        this.result = v;
    }

    public Instr cloneForInlinedScope(InlinerInfo ii) {
        if (ii.getCallClosure() instanceof WrappedIRClosure) {
            return NopInstr.NOP;
        }
        return new CopyInstr(ii.getRenamedVariable(this.result), ii.getCallClosure());
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new ReceiveClosureInstr(ii.getRenamedVariable(this.result));
    }

    public void visit(IRVisitor visitor) {
        visitor.ReceiveClosureInstr(this);
    }
}

